/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container for a status of bank connection update")
public class InlineResponse2005LastManualUpdate {
    @SerializedName(value="result")
    private ResultEnum result = null;
    @SerializedName(value="errorMessage")
    private String errorMessage = null;
    @SerializedName(value="errorType")
    private ErrorTypeEnum errorType = null;
    @SerializedName(value="timestamp")
    private String timestamp = null;

    public InlineResponse2005LastManualUpdate result(ResultEnum result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Note that 'OK' just means that finAPI could successfully connect and log in to the bank server. However, it does not necessarily mean that all accounts could be updated successfully. For the latter, please refer to the 'status' field of the Account resource.")
    public ResultEnum getResult() {
        return this.result;
    }

    public void setResult(ResultEnum result) {
        this.result = result;
    }

    public InlineResponse2005LastManualUpdate errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="In case the update result is not <code>OK</code>, this field may contain an error message with details about why the update failed (it is not guaranteed that a message is available though). In case the update result is <code>OK</code>, the field will always be null.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public InlineResponse2005LastManualUpdate errorType(ErrorTypeEnum errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(example="null", value="In case the update result is not <code>OK</code>, this field contains the type of the error that occurred. BUSINESS means that the bank server responded with a non-technical error message for the user. TECHNICAL means that some internal error has occurred in finAPI or at the bank server.")
    public ErrorTypeEnum getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorTypeEnum errorType) {
        this.errorType = errorType;
    }

    public InlineResponse2005LastManualUpdate timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Time of the update. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineResponse2005LastManualUpdate inlineResponse2005LastManualUpdate = (InlineResponse2005LastManualUpdate)o;
        return Objects.equals((Object)this.result, (Object)inlineResponse2005LastManualUpdate.result) && Objects.equals(this.errorMessage, inlineResponse2005LastManualUpdate.errorMessage) && Objects.equals((Object)this.errorType, (Object)inlineResponse2005LastManualUpdate.errorType) && Objects.equals(this.timestamp, inlineResponse2005LastManualUpdate.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.result, this.errorMessage, this.errorType, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineResponse2005LastManualUpdate {\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString((Object)this.errorType)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ErrorTypeEnum {
        BUSINESS("BUSINESS"),
        TECHNICAL("TECHNICAL");

        private String value;

        private ErrorTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ResultEnum {
        OK("OK"),
        BANK_SERVER_REJECTION("BANK_SERVER_REJECTION"),
        INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR");

        private String value;

        private ResultEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

