/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Container for a security position's data")
public class InlineResponse20017Securities {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="accountId")
    private Long accountId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="isin")
    private String isin = null;
    @SerializedName(value="wkn")
    private String wkn = null;
    @SerializedName(value="quote")
    private BigDecimal quote = null;
    @SerializedName(value="quoteCurrency")
    private String quoteCurrency = null;
    @SerializedName(value="quoteType")
    private QuoteTypeEnum quoteType = null;
    @SerializedName(value="quoteDate")
    private String quoteDate = null;
    @SerializedName(value="quantityNominal")
    private BigDecimal quantityNominal = null;
    @SerializedName(value="quantityNominalType")
    private QuantityNominalTypeEnum quantityNominalType = null;
    @SerializedName(value="marketValue")
    private BigDecimal marketValue = null;
    @SerializedName(value="entryQuote")
    private BigDecimal entryQuote = null;
    @SerializedName(value="entryQuoteCurrency")
    private String entryQuoteCurrency = null;

    public InlineResponse20017Securities id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier. Note: Whenever a security account is being updated, its security positions will be internally re-created, meaning that the identifier of a security position might change over time.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public InlineResponse20017Securities accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Security account identifier")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public InlineResponse20017Securities name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InlineResponse20017Securities isin(String isin) {
        this.isin = isin;
        return this;
    }

    @ApiModelProperty(example="null", value="ISIN")
    public String getIsin() {
        return this.isin;
    }

    public void setIsin(String isin) {
        this.isin = isin;
    }

    public InlineResponse20017Securities wkn(String wkn) {
        this.wkn = wkn;
        return this;
    }

    @ApiModelProperty(example="null", value="WKN")
    public String getWkn() {
        return this.wkn;
    }

    public void setWkn(String wkn) {
        this.wkn = wkn;
    }

    public InlineResponse20017Securities quote(BigDecimal quote) {
        this.quote = quote;
        return this;
    }

    @ApiModelProperty(example="null", value="Quote")
    public BigDecimal getQuote() {
        return this.quote;
    }

    public void setQuote(BigDecimal quote) {
        this.quote = quote;
    }

    public InlineResponse20017Securities quoteCurrency(String quoteCurrency) {
        this.quoteCurrency = quoteCurrency;
        return this;
    }

    @ApiModelProperty(example="null", value="Currency of quote")
    public String getQuoteCurrency() {
        return this.quoteCurrency;
    }

    public void setQuoteCurrency(String quoteCurrency) {
        this.quoteCurrency = quoteCurrency;
    }

    public InlineResponse20017Securities quoteType(QuoteTypeEnum quoteType) {
        this.quoteType = quoteType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of quote. 'PERC' if quote is a percentage value, 'ACTU' if quote is the actual amount")
    public QuoteTypeEnum getQuoteType() {
        return this.quoteType;
    }

    public void setQuoteType(QuoteTypeEnum quoteType) {
        this.quoteType = quoteType;
    }

    public InlineResponse20017Securities quoteDate(String quoteDate) {
        this.quoteDate = quoteDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Quote date")
    public String getQuoteDate() {
        return this.quoteDate;
    }

    public void setQuoteDate(String quoteDate) {
        this.quoteDate = quoteDate;
    }

    public InlineResponse20017Securities quantityNominal(BigDecimal quantityNominal) {
        this.quantityNominal = quantityNominal;
        return this;
    }

    @ApiModelProperty(example="null", value="Value of quantity or nominal")
    public BigDecimal getQuantityNominal() {
        return this.quantityNominal;
    }

    public void setQuantityNominal(BigDecimal quantityNominal) {
        this.quantityNominal = quantityNominal;
    }

    public InlineResponse20017Securities quantityNominalType(QuantityNominalTypeEnum quantityNominalType) {
        this.quantityNominalType = quantityNominalType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of quantity or nominal value. 'UNIT' if value is a quantity, 'FAMT' if value is the nominal amount")
    public QuantityNominalTypeEnum getQuantityNominalType() {
        return this.quantityNominalType;
    }

    public void setQuantityNominalType(QuantityNominalTypeEnum quantityNominalType) {
        this.quantityNominalType = quantityNominalType;
    }

    public InlineResponse20017Securities marketValue(BigDecimal marketValue) {
        this.marketValue = marketValue;
        return this;
    }

    @ApiModelProperty(example="null", value="Market value")
    public BigDecimal getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(BigDecimal marketValue) {
        this.marketValue = marketValue;
    }

    public InlineResponse20017Securities entryQuote(BigDecimal entryQuote) {
        this.entryQuote = entryQuote;
        return this;
    }

    @ApiModelProperty(example="null", value="Entry quote")
    public BigDecimal getEntryQuote() {
        return this.entryQuote;
    }

    public void setEntryQuote(BigDecimal entryQuote) {
        this.entryQuote = entryQuote;
    }

    public InlineResponse20017Securities entryQuoteCurrency(String entryQuoteCurrency) {
        this.entryQuoteCurrency = entryQuoteCurrency;
        return this;
    }

    @ApiModelProperty(example="null", value="Currency of entry quote")
    public String getEntryQuoteCurrency() {
        return this.entryQuoteCurrency;
    }

    public void setEntryQuoteCurrency(String entryQuoteCurrency) {
        this.entryQuoteCurrency = entryQuoteCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineResponse20017Securities inlineResponse20017Securities = (InlineResponse20017Securities)o;
        return Objects.equals(this.id, inlineResponse20017Securities.id) && Objects.equals(this.accountId, inlineResponse20017Securities.accountId) && Objects.equals(this.name, inlineResponse20017Securities.name) && Objects.equals(this.isin, inlineResponse20017Securities.isin) && Objects.equals(this.wkn, inlineResponse20017Securities.wkn) && Objects.equals(this.quote, inlineResponse20017Securities.quote) && Objects.equals(this.quoteCurrency, inlineResponse20017Securities.quoteCurrency) && Objects.equals((Object)this.quoteType, (Object)inlineResponse20017Securities.quoteType) && Objects.equals(this.quoteDate, inlineResponse20017Securities.quoteDate) && Objects.equals(this.quantityNominal, inlineResponse20017Securities.quantityNominal) && Objects.equals((Object)this.quantityNominalType, (Object)inlineResponse20017Securities.quantityNominalType) && Objects.equals(this.marketValue, inlineResponse20017Securities.marketValue) && Objects.equals(this.entryQuote, inlineResponse20017Securities.entryQuote) && Objects.equals(this.entryQuoteCurrency, inlineResponse20017Securities.entryQuoteCurrency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountId, this.name, this.isin, this.wkn, this.quote, this.quoteCurrency, this.quoteType, this.quoteDate, this.quantityNominal, this.quantityNominalType, this.marketValue, this.entryQuote, this.entryQuoteCurrency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineResponse20017Securities {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isin: ").append(this.toIndentedString(this.isin)).append("\n");
        sb.append("    wkn: ").append(this.toIndentedString(this.wkn)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    quoteCurrency: ").append(this.toIndentedString(this.quoteCurrency)).append("\n");
        sb.append("    quoteType: ").append(this.toIndentedString((Object)this.quoteType)).append("\n");
        sb.append("    quoteDate: ").append(this.toIndentedString(this.quoteDate)).append("\n");
        sb.append("    quantityNominal: ").append(this.toIndentedString(this.quantityNominal)).append("\n");
        sb.append("    quantityNominalType: ").append(this.toIndentedString((Object)this.quantityNominalType)).append("\n");
        sb.append("    marketValue: ").append(this.toIndentedString(this.marketValue)).append("\n");
        sb.append("    entryQuote: ").append(this.toIndentedString(this.entryQuote)).append("\n");
        sb.append("    entryQuoteCurrency: ").append(this.toIndentedString(this.entryQuoteCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum QuantityNominalTypeEnum {
        UNIT("UNIT"),
        FAMT("FAMT");

        private String value;

        private QuantityNominalTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum QuoteTypeEnum {
        ACTU("ACTU"),
        PERC("PERC");

        private String value;

        private QuoteTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

