/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Client configuration parameters")
public class InlineResponse20011 {
    @SerializedName(value="isAutomaticBatchUpdateEnabled")
    private Boolean isAutomaticBatchUpdateEnabled = false;
    @SerializedName(value="userNotificationCallbackUrl")
    private String userNotificationCallbackUrl = null;
    @SerializedName(value="userSynchronizationCallbackUrl")
    private String userSynchronizationCallbackUrl = null;
    @SerializedName(value="refreshTokensValidityPeriod")
    private Integer refreshTokensValidityPeriod = null;
    @SerializedName(value="userAccessTokensValidityPeriod")
    private Integer userAccessTokensValidityPeriod = null;
    @SerializedName(value="clientAccessTokensValidityPeriod")
    private Integer clientAccessTokensValidityPeriod = null;
    @SerializedName(value="maxUserLoginAttempts")
    private Integer maxUserLoginAttempts = null;
    @SerializedName(value="isUserAutoVerificationEnabled")
    private Boolean isUserAutoVerificationEnabled = false;
    @SerializedName(value="isMandatorAdmin")
    private Boolean isMandatorAdmin = false;
    @SerializedName(value="isWebScrapingEnabled")
    private Boolean isWebScrapingEnabled = false;

    public InlineResponse20011 isAutomaticBatchUpdateEnabled(Boolean isAutomaticBatchUpdateEnabled) {
        this.isAutomaticBatchUpdateEnabled = isAutomaticBatchUpdateEnabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether finAPI performs a regular automatic update of your users' bank connections. To find out how the automatic batch update is configured for your client, i.e. which bank connections get updated, and at which time and interval, please contact your Sys-Admin. Note that even if the automatic batch update is enabled for your client, individual users can still disable the feature for their own bank connections.")
    public Boolean getIsAutomaticBatchUpdateEnabled() {
        return this.isAutomaticBatchUpdateEnabled;
    }

    public void setIsAutomaticBatchUpdateEnabled(Boolean isAutomaticBatchUpdateEnabled) {
        this.isAutomaticBatchUpdateEnabled = isAutomaticBatchUpdateEnabled;
    }

    public InlineResponse20011 userNotificationCallbackUrl(String userNotificationCallbackUrl) {
        this.userNotificationCallbackUrl = userNotificationCallbackUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="Callback URL to which finAPI sends the notification messages that are triggered from the automatic batch update of the users' bank connections. This field is only relevant if the automatic batch update is enabled for your client. For details about what the notification messages look like, please see the documentation in the 'Notification Rules' section. finAPI will call this URL with HTTP method POST. Note that the response of the call is not processed by finAPI. Also note that while the callback URL may be a non-secured (http) URL on the finAPI sandbox or alpha environment, it MUST be a SSL-secured (https) URL on the finAPI live system.")
    public String getUserNotificationCallbackUrl() {
        return this.userNotificationCallbackUrl;
    }

    public void setUserNotificationCallbackUrl(String userNotificationCallbackUrl) {
        this.userNotificationCallbackUrl = userNotificationCallbackUrl;
    }

    public InlineResponse20011 userSynchronizationCallbackUrl(String userSynchronizationCallbackUrl) {
        this.userSynchronizationCallbackUrl = userSynchronizationCallbackUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="Callback URL for user synchronization. This field should be set if you - as a finAPI customer - have multiple clients using finAPI. In such case, all of your clients will share the same user base, making it possible for a user to be created in one client, but then deleted in another. To keep the client-side user data consistent in all clients, you should set a callback URL for each client. finAPI will send a notification to the callback URL of each client whenever a user of your user base gets deleted. Note that finAPI will send a deletion notification to ALL clients, including the one that made the user deletion request to finAPI. So when deleting a user in finAPI, a client should rely on the callback to delete the user on its own side. <p>The notification that finAPI sends to the clients' callback URLs will be a POST request, with this body: <pre>{    \"userId\" : string // contains the identifier of the deleted user    \"event\" : string // this will always be \"DELETED\" }</pre><br>Note that finAPI does not process the response of this call. Also note that while the callback URL may be a non-secured (http) URL on the finAPI sandbox or alpha environment, it MUST be a SSL-secured (https) URL on the finAPI live system.</p>As long as you have just one client, you can ignore this field and let it be null. However keep in mind that in this case your client will not receive any callback when a user gets deleted - so the deletion of the user on the client-side must not be forgotten. Of course you may still use the callback URL even for just one client, if you want to implement the deletion of the user on the client-side via the callback from finAPI.")
    public String getUserSynchronizationCallbackUrl() {
        return this.userSynchronizationCallbackUrl;
    }

    public void setUserSynchronizationCallbackUrl(String userSynchronizationCallbackUrl) {
        this.userSynchronizationCallbackUrl = userSynchronizationCallbackUrl;
    }

    public InlineResponse20011 refreshTokensValidityPeriod(Integer refreshTokensValidityPeriod) {
        this.refreshTokensValidityPeriod = refreshTokensValidityPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="The validity period that newly requested refresh tokens initially have (in seconds). A value of 0 means that the tokens never expire (Unless explicitly invalidated, e.g. by revocation, or when a user gets locked, or when the password is reset for a user).")
    public Integer getRefreshTokensValidityPeriod() {
        return this.refreshTokensValidityPeriod;
    }

    public void setRefreshTokensValidityPeriod(Integer refreshTokensValidityPeriod) {
        this.refreshTokensValidityPeriod = refreshTokensValidityPeriod;
    }

    public InlineResponse20011 userAccessTokensValidityPeriod(Integer userAccessTokensValidityPeriod) {
        this.userAccessTokensValidityPeriod = userAccessTokensValidityPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="The validity period that newly requested access tokens for users initially have (in seconds). A value of 0 means that the tokens never expire (Unless explicitly invalidated, e.g. by revocation , or when a user gets locked, or when the password is reset for a user).")
    public Integer getUserAccessTokensValidityPeriod() {
        return this.userAccessTokensValidityPeriod;
    }

    public void setUserAccessTokensValidityPeriod(Integer userAccessTokensValidityPeriod) {
        this.userAccessTokensValidityPeriod = userAccessTokensValidityPeriod;
    }

    public InlineResponse20011 clientAccessTokensValidityPeriod(Integer clientAccessTokensValidityPeriod) {
        this.clientAccessTokensValidityPeriod = clientAccessTokensValidityPeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="The validity period that newly requested access tokens for clients initially have (in seconds). A value of 0 means that the tokens never expire (Unless explicitly invalidated, e.g. by revocation).")
    public Integer getClientAccessTokensValidityPeriod() {
        return this.clientAccessTokensValidityPeriod;
    }

    public void setClientAccessTokensValidityPeriod(Integer clientAccessTokensValidityPeriod) {
        this.clientAccessTokensValidityPeriod = clientAccessTokensValidityPeriod;
    }

    public InlineResponse20011 maxUserLoginAttempts(Integer maxUserLoginAttempts) {
        this.maxUserLoginAttempts = maxUserLoginAttempts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Number of consecutive failed login attempts of a user into his finAPI account that is allowed before finAPI locks the user's account. When a user's account is locked, finAPI will invalidate all user's tokens and it will deny any service call in the context of this user (i.e. any call to a service using one of the user's authorization tokens, as well as the service for requesting a new token for this user). To unlock a user's account, a new password must be set for the account by the client (see the services /users/requestPasswordChange and /users/executePasswordChange). Once a new password has been set, all services will be available again for this user and the user's failed login attempts counter is reset to 0. The user's failed login attempts counter is also reset whenever a new authorization token has been successfully retrieved, or whenever the user himself changes his password.<br><br>Note that when this field has a value of 0, it means that there is no limit for user login attempts, i.e. finAPI will never lock user accounts.")
    public Integer getMaxUserLoginAttempts() {
        return this.maxUserLoginAttempts;
    }

    public void setMaxUserLoginAttempts(Integer maxUserLoginAttempts) {
        this.maxUserLoginAttempts = maxUserLoginAttempts;
    }

    public InlineResponse20011 isUserAutoVerificationEnabled(Boolean isUserAutoVerificationEnabled) {
        this.isUserAutoVerificationEnabled = isUserAutoVerificationEnabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether users that are created with this client are automatically verified on creation. If this field is set to 'false', then any user that is created with this client must first be verified with the \"Verify a user\" service before he can be authorized. If the field is 'true', then no verification is required by the client and the user can be authorized immediately after creation.")
    public Boolean getIsUserAutoVerificationEnabled() {
        return this.isUserAutoVerificationEnabled;
    }

    public void setIsUserAutoVerificationEnabled(Boolean isUserAutoVerificationEnabled) {
        this.isUserAutoVerificationEnabled = isUserAutoVerificationEnabled;
    }

    public InlineResponse20011 isMandatorAdmin(Boolean isMandatorAdmin) {
        this.isMandatorAdmin = isMandatorAdmin;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this client is a 'Mandator Admin'. Mandator Admins are special clients that can access the 'Mandator Administration' section of finAPI. If you do not yet have credentials for a Mandator Admin, please contact us at support@finapi.io. For further information, please refer to <a href='https://finapi.zendesk.com/hc/en-us/articles/115003661827-Difference-between-app-clients-and-mandator-admin-client'>this article</a> on our Dev Portal.")
    public Boolean getIsMandatorAdmin() {
        return this.isMandatorAdmin;
    }

    public void setIsMandatorAdmin(Boolean isMandatorAdmin) {
        this.isMandatorAdmin = isMandatorAdmin;
    }

    public InlineResponse20011 isWebScrapingEnabled(Boolean isWebScrapingEnabled) {
        this.isWebScrapingEnabled = isWebScrapingEnabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether finAPI is allowed to use web scrapers for data download. If this field is set to 'true', then finAPI might download data from the online banking websites of banks (either in addition to using the FinTS interface, or as the sole data source for the download). If this field is set to 'false', then finAPI will not use any web scrapers and instead download data only from FinTS servers. For banks where no FinTS interface is available, finAPI will not allow any data download at all if web scraping is disabled for your client. Please contact your Sys-Admin if you want to change this setting.")
    public Boolean getIsWebScrapingEnabled() {
        return this.isWebScrapingEnabled;
    }

    public void setIsWebScrapingEnabled(Boolean isWebScrapingEnabled) {
        this.isWebScrapingEnabled = isWebScrapingEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineResponse20011 inlineResponse20011 = (InlineResponse20011)o;
        return Objects.equals(this.isAutomaticBatchUpdateEnabled, inlineResponse20011.isAutomaticBatchUpdateEnabled) && Objects.equals(this.userNotificationCallbackUrl, inlineResponse20011.userNotificationCallbackUrl) && Objects.equals(this.userSynchronizationCallbackUrl, inlineResponse20011.userSynchronizationCallbackUrl) && Objects.equals(this.refreshTokensValidityPeriod, inlineResponse20011.refreshTokensValidityPeriod) && Objects.equals(this.userAccessTokensValidityPeriod, inlineResponse20011.userAccessTokensValidityPeriod) && Objects.equals(this.clientAccessTokensValidityPeriod, inlineResponse20011.clientAccessTokensValidityPeriod) && Objects.equals(this.maxUserLoginAttempts, inlineResponse20011.maxUserLoginAttempts) && Objects.equals(this.isUserAutoVerificationEnabled, inlineResponse20011.isUserAutoVerificationEnabled) && Objects.equals(this.isMandatorAdmin, inlineResponse20011.isMandatorAdmin) && Objects.equals(this.isWebScrapingEnabled, inlineResponse20011.isWebScrapingEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.isAutomaticBatchUpdateEnabled, this.userNotificationCallbackUrl, this.userSynchronizationCallbackUrl, this.refreshTokensValidityPeriod, this.userAccessTokensValidityPeriod, this.clientAccessTokensValidityPeriod, this.maxUserLoginAttempts, this.isUserAutoVerificationEnabled, this.isMandatorAdmin, this.isWebScrapingEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InlineResponse20011 {\n");
        sb.append("    isAutomaticBatchUpdateEnabled: ").append(this.toIndentedString(this.isAutomaticBatchUpdateEnabled)).append("\n");
        sb.append("    userNotificationCallbackUrl: ").append(this.toIndentedString(this.userNotificationCallbackUrl)).append("\n");
        sb.append("    userSynchronizationCallbackUrl: ").append(this.toIndentedString(this.userSynchronizationCallbackUrl)).append("\n");
        sb.append("    refreshTokensValidityPeriod: ").append(this.toIndentedString(this.refreshTokensValidityPeriod)).append("\n");
        sb.append("    userAccessTokensValidityPeriod: ").append(this.toIndentedString(this.userAccessTokensValidityPeriod)).append("\n");
        sb.append("    clientAccessTokensValidityPeriod: ").append(this.toIndentedString(this.clientAccessTokensValidityPeriod)).append("\n");
        sb.append("    maxUserLoginAttempts: ").append(this.toIndentedString(this.maxUserLoginAttempts)).append("\n");
        sb.append("    isUserAutoVerificationEnabled: ").append(this.toIndentedString(this.isUserAutoVerificationEnabled)).append("\n");
        sb.append("    isMandatorAdmin: ").append(this.toIndentedString(this.isMandatorAdmin)).append("\n");
        sb.append("    isWebScrapingEnabled: ").append(this.toIndentedString(this.isWebScrapingEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

