/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Balance data for a single day")
public class DailyBalance {
    @SerializedName(value="date")
    private String date = null;
    @SerializedName(value="balance")
    private BigDecimal balance = null;
    @SerializedName(value="income")
    private BigDecimal income = null;
    @SerializedName(value="spending")
    private BigDecimal spending = null;
    @SerializedName(value="transactions")
    private List<Long> transactions = new ArrayList<Long>();

    public DailyBalance date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public DailyBalance balance(BigDecimal balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Calculated account balance at the end of the given day.")
    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public DailyBalance income(BigDecimal income) {
        this.income = income;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sum of income of the given day.")
    public BigDecimal getIncome() {
        return this.income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public DailyBalance spending(BigDecimal spending) {
        this.spending = spending;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sum of spending of the given day.")
    public BigDecimal getSpending() {
        return this.spending;
    }

    public void setSpending(BigDecimal spending) {
        this.spending = spending;
    }

    public DailyBalance transactions(List<Long> transactions) {
        this.transactions = transactions;
        return this;
    }

    public DailyBalance addTransactionsItem(Long transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Transactions for the given day")
    public List<Long> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Long> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyBalance dailyBalance = (DailyBalance)o;
        return Objects.equals(this.date, dailyBalance.date) && Objects.equals(this.balance, dailyBalance.balance) && Objects.equals(this.income, dailyBalance.income) && Objects.equals(this.spending, dailyBalance.spending) && Objects.equals(this.transactions, dailyBalance.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.balance, this.income, this.spending, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyBalance {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    income: ").append(this.toIndentedString(this.income)).append("\n");
        sb.append("    spending: ").append(this.toIndentedString(this.spending)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

