/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container for bank connection update parameters")
public class Body4 {
    @SerializedName(value="bankConnectionId")
    private Long bankConnectionId = null;
    @SerializedName(value="bankingPin")
    private String bankingPin = null;
    @SerializedName(value="importNewAccounts")
    private Boolean importNewAccounts = false;
    @SerializedName(value="skipPositionsDownload")
    private Boolean skipPositionsDownload = false;

    public Body4 bankConnectionId(Long bankConnectionId) {
        this.bankConnectionId = bankConnectionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Bank connection identifier")
    public Long getBankConnectionId() {
        return this.bankConnectionId;
    }

    public void setBankConnectionId(Long bankConnectionId) {
        this.bankConnectionId = bankConnectionId;
    }

    public Body4 bankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
        return this;
    }

    @ApiModelProperty(example="null", value="Online banking PIN. If a PIN is stored in the bank connection, then this field may remain unset. If the field is set though then it will always be used (even if there is some other PIN stored in the bank connection)")
    public String getBankingPin() {
        return this.bankingPin;
    }

    public void setBankingPin(String bankingPin) {
        this.bankingPin = bankingPin;
    }

    public Body4 importNewAccounts(Boolean importNewAccounts) {
        this.importNewAccounts = importNewAccounts;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether new accounts that have not yet been imported will be imported or not. Default is false. <br>NOTES:<br><br>&bull; For best performance of the bank connection update, you should not enable this flag unless you really expect new accounts to be available in the connection. It is recommended to let your users tell you through your application when they want the service to look for new accounts.<br>&bull; If you have imported a bank connection using specific <code>accountTypeIds</code> (e.g. <code>1,2</code> to import checking and saving accounts), you would import all other accounts (e.g. security accounts or credit cards) by setting <code>importNewAccounts</code> to <code>true</code>. To avoid importing account types that you are not interested in, make sure this field is undefined or set to false.")
    public Boolean getImportNewAccounts() {
        return this.importNewAccounts;
    }

    public void setImportNewAccounts(Boolean importNewAccounts) {
        this.importNewAccounts = importNewAccounts;
    }

    public Body4 skipPositionsDownload(Boolean skipPositionsDownload) {
        this.skipPositionsDownload = skipPositionsDownload;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to skip the download of transactions and securities or not. If set to true, then finAPI will download just the accounts list with the accounts' information (like account name, number, holder, etc), as well as the accounts' balances (if possible), but skip the download of transactions and securities. Default is false.<br>NOTES:<br><br>&bull; If you skip the download of transactions and securities during an import or update, you can still download them on a later update (though you might not get all positions at a later point, because the date range in which the bank servers provide this data is usually limited). However, once finAPI has downloaded the transactions or securities for the first time, you will not be able to go back to skipping the download of transactions and securities! In other words: Once you make your first request with <code>skipPositionsDownload=false</code> for a certain bank connection, you will no longer be able to make a request with <code>skipPositionsDownload=true</code> for that same bank connection.<br>&bull; If this bank connection is updated via finAPI's automatic batch update, then transactions and security positions <u>will</u> be downloaded in any case!<br>&bull; For security accounts, skipping the downloading of the securities might result in the account's balance also not being downloaded.")
    public Boolean getSkipPositionsDownload() {
        return this.skipPositionsDownload;
    }

    public void setSkipPositionsDownload(Boolean skipPositionsDownload) {
        this.skipPositionsDownload = skipPositionsDownload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body4 body4 = (Body4)o;
        return Objects.equals(this.bankConnectionId, body4.bankConnectionId) && Objects.equals(this.bankingPin, body4.bankingPin) && Objects.equals(this.importNewAccounts, body4.importNewAccounts) && Objects.equals(this.skipPositionsDownload, body4.skipPositionsDownload);
    }

    public int hashCode() {
        return Objects.hash(this.bankConnectionId, this.bankingPin, this.importNewAccounts, this.skipPositionsDownload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Body4 {\n");
        sb.append("    bankConnectionId: ").append(this.toIndentedString(this.bankConnectionId)).append("\n");
        sb.append("    bankingPin: ").append(this.toIndentedString(this.bankingPin)).append("\n");
        sb.append("    importNewAccounts: ").append(this.toIndentedString(this.importNewAccounts)).append("\n");
        sb.append("    skipPositionsDownload: ").append(this.toIndentedString(this.skipPositionsDownload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

