/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Container for an account's name, type and 'isNew' flag'.")
public class Body2 {
    @SerializedName(value="accountName")
    private String accountName = null;
    @SerializedName(value="accountTypeId")
    private Long accountTypeId = null;
    @SerializedName(value="isNew")
    private Boolean isNew = false;

    public Body2 accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(example="null", value="Account name. Maximum length is 512.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Body2 accountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier of account type.<br><br>1 = Checking,<br>2 = Savings,<br>3 = CreditCard,<br>4 = Security,<br>5 = Loan,<br>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br>7 = Membership<br><br>")
    public Long getAccountTypeId() {
        return this.accountTypeId;
    }

    public void setAccountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
    }

    public Body2 isNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this account should be flagged as 'new' or not. Any newly imported account will have this flag initially set to true, and remain so until you set it to false (see PATCH /accounts/<id>). How you use this field is up to your interpretation, however it is recommended to set the flag to false for all accounts right after the initial import of the bank connection. This way, you will be able recognize accounts that get newly imported during a later update of the bank connection, by checking for any accounts with the flag set to true after every update of the bank connection.")
    public Boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body2 body2 = (Body2)o;
        return Objects.equals(this.accountName, body2.accountName) && Objects.equals(this.accountTypeId, body2.accountTypeId) && Objects.equals(this.isNew, body2.isNew);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.accountTypeId, this.isNew);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Body2 {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountTypeId: ").append(this.toIndentedString(this.accountTypeId)).append("\n");
        sb.append("    isNew: ").append(this.toIndentedString(this.isNew)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

