/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Update transactions parameters")
public class Body15 {
    @SerializedName(value="isNew")
    private Boolean isNew = false;
    @SerializedName(value="isPotentialDuplicate")
    private Boolean isPotentialDuplicate = false;
    @SerializedName(value="categoryId")
    private Long categoryId = null;
    @SerializedName(value="labelIds")
    private List<Long> labelIds = new ArrayList<Long>();

    public Body15 isNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this transactions should be flagged as 'new' or not. Any newly imported transaction will have this flag initially set to true. How you use this field is up to your interpretation. For example, you might want to set it to false once a user has clicked on/seen the transaction.")
    public Boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public Body15 isPotentialDuplicate(Boolean isPotentialDuplicate) {
        this.isPotentialDuplicate = isPotentialDuplicate;
        return this;
    }

    @ApiModelProperty(example="null", value="You can set this field only to 'false'. finAPI marks transactions as a potential duplicates  when its internal duplicate detection algorithm is signaling so. Transactions that are flagged as duplicates can be deleted by the user. To prevent the user from deleting original transactions, which might lead to incorrect balances, it is not possible to manually set this flag to 'true'.")
    public Boolean getIsPotentialDuplicate() {
        return this.isPotentialDuplicate;
    }

    public void setIsPotentialDuplicate(Boolean isPotentialDuplicate) {
        this.isPotentialDuplicate = isPotentialDuplicate;
    }

    public Body15 categoryId(Long categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier of the new category to apply to the transaction. When updating the transaction's category, the category's fields 'id', 'name', 'parentId', 'parentName', and 'isCustom' will all get updated. To clear the category for the transaction, the categoryId field must be passed with value 0.")
    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Body15 labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public Body15 addLabelIdsItem(Long labelIdsItem) {
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Identifiers of labels to apply to the transaction. To clear transactions' labels, pass an empty array of identifiers: '[]'")
    public List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body15 body15 = (Body15)o;
        return Objects.equals(this.isNew, body15.isNew) && Objects.equals(this.isPotentialDuplicate, body15.isPotentialDuplicate) && Objects.equals(this.categoryId, body15.categoryId) && Objects.equals(this.labelIds, body15.labelIds);
    }

    public int hashCode() {
        return Objects.hash(this.isNew, this.isPotentialDuplicate, this.categoryId, this.labelIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Body15 {\n");
        sb.append("    isNew: ").append(this.toIndentedString(this.isNew)).append("\n");
        sb.append("    isPotentialDuplicate: ").append(this.toIndentedString(this.isPotentialDuplicate)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

