/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Bank server's response to some request")
public class BankResponse {
    @SerializedName(value="successMessage")
    private String successMessage = null;
    @SerializedName(value="warnMessage")
    private String warnMessage = null;

    public BankResponse successMessage(String successMessage) {
        this.successMessage = successMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="Technical message from the bank server, confirming the success of the request. Typically, you would not want to present this message to the user. Note that this field may not be set. However if it is not set, it does not necessarily mean that there was an error in processing the request.")
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public BankResponse warnMessage(String warnMessage) {
        this.warnMessage = warnMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="In some cases, a bank server may accept the requested order, but return a warn message. This message may be of technical nature, but could also be of interest to the user.")
    public String getWarnMessage() {
        return this.warnMessage;
    }

    public void setWarnMessage(String warnMessage) {
        this.warnMessage = warnMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankResponse bankResponse = (BankResponse)o;
        return Objects.equals(this.successMessage, bankResponse.successMessage) && Objects.equals(this.warnMessage, bankResponse.warnMessage);
    }

    public int hashCode() {
        return Objects.hash(this.successMessage, this.warnMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankResponse {\n");
        sb.append("    successMessage: ").append(this.toIndentedString(this.successMessage)).append("\n");
        sb.append("    warnMessage: ").append(this.toIndentedString(this.warnMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

