/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for a bank's data")
public class Bank {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="loginHint")
    private String loginHint = null;
    @SerializedName(value="bic")
    private String bic = null;
    @SerializedName(value="blz")
    private String blz = null;
    @SerializedName(value="blzs")
    private List<String> blzs = new ArrayList<String>();
    @SerializedName(value="loginFieldUserId")
    private String loginFieldUserId = null;
    @SerializedName(value="loginFieldCustomerId")
    private String loginFieldCustomerId = null;
    @SerializedName(value="loginFieldPin")
    private String loginFieldPin = null;
    @SerializedName(value="isSupported")
    private Boolean isSupported = false;
    @SerializedName(value="supportedDataSources")
    private List<SupportedDataSourcesEnum> supportedDataSources = new ArrayList<SupportedDataSourcesEnum>();

    public Bank id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Bank identifier")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Bank name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of bank")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bank loginHint(String loginHint) {
        this.loginHint = loginHint;
        return this;
    }

    @ApiModelProperty(example="null", value="Login hint. Contains a German message for the user that explains what kind of credentials are expected.<br><br>Please note that it is strongly recommended to always show the login hint to the user if there is one, as the credentials that finAPI requires for the bank might be different to the credentials that the user knows from the bank's website.<br><br>Also note that the contents of this field should always be interpreted as HTML, as the text might contain HTML tags for highlighted words, paragraphs, etc.")
    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public Bank bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(example="null", value="BIC of bank")
    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public Bank blz(String blz) {
        this.blz = blz;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="BLZ of bank")
    public String getBlz() {
        return this.blz;
    }

    public void setBlz(String blz) {
        this.blz = blz;
    }

    public Bank blzs(List<String> blzs) {
        this.blzs = blzs;
        return this;
    }

    public Bank addBlzsItem(String blzsItem) {
        this.blzs.add(blzsItem);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of BLZs that belong to this bank. NOTE: This field is deprecated and will be removed at some point. Please refer to field 'blz' instead.")
    public List<String> getBlzs() {
        return this.blzs;
    }

    public void setBlzs(List<String> blzs) {
        this.blzs = blzs;
    }

    public Bank loginFieldUserId(String loginFieldUserId) {
        this.loginFieldUserId = loginFieldUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="Label for the user ID login field, as it is called on the bank's website (e.g. \"Nutzerkennung\"). If this field is set (i.e. not null) then you should prompt your users to enter the required data in a text field which you can label with this field's value.")
    public String getLoginFieldUserId() {
        return this.loginFieldUserId;
    }

    public void setLoginFieldUserId(String loginFieldUserId) {
        this.loginFieldUserId = loginFieldUserId;
    }

    public Bank loginFieldCustomerId(String loginFieldCustomerId) {
        this.loginFieldCustomerId = loginFieldCustomerId;
        return this;
    }

    @ApiModelProperty(example="null", value="Label for the customer ID login field, as it is called on the bank's website (e.g. \"Kundennummer\"). If this field is set (i.e. not null) then you should prompt your users to enter the required data in a text field which you can label with this field's value.")
    public String getLoginFieldCustomerId() {
        return this.loginFieldCustomerId;
    }

    public void setLoginFieldCustomerId(String loginFieldCustomerId) {
        this.loginFieldCustomerId = loginFieldCustomerId;
    }

    public Bank loginFieldPin(String loginFieldPin) {
        this.loginFieldPin = loginFieldPin;
        return this;
    }

    @ApiModelProperty(example="null", value="Label for the PIN field, as it is called on the bank's website (mostly \"PIN\"). If this field is set (i.e. not null) then you should prompt your users to enter the required data in a text field which you can label with this field's value.")
    public String getLoginFieldPin() {
        return this.loginFieldPin;
    }

    public void setLoginFieldPin(String loginFieldPin) {
        this.loginFieldPin = loginFieldPin;
    }

    public Bank isSupported(Boolean isSupported) {
        this.isSupported = isSupported;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this bank is supported by finAPI, i.e. whether you can import/update a bank connection of this bank.")
    public Boolean getIsSupported() {
        return this.isSupported;
    }

    public void setIsSupported(Boolean isSupported) {
        this.isSupported = isSupported;
    }

    public Bank supportedDataSources(List<SupportedDataSourcesEnum> supportedDataSources) {
        this.supportedDataSources = supportedDataSources;
        return this;
    }

    public Bank addSupportedDataSourcesItem(SupportedDataSourcesEnum supportedDataSourcesItem) {
        this.supportedDataSources.add(supportedDataSourcesItem);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of the data sources that finAPI will use for data download for this bank. Possible values:<br><br> - FINTS_SERVER - means that finAPI will download data via the bank's FinTS interface.<br> - WEB_SCRAPER - means that finAPI will parse data from the bank's online banking website.<br><br>Note that this list will be empty for non-supported banks. Note also that web scraping might be disabled for your client (see GET /clientConfiguration). When this is the case, then finAPI will not use the web scraper for data download, and if the web scraper is the only supported data source of this bank, then finAPI will not allow to download any data for this bank at all (for details, see POST /bankConnections/import and POST /bankConnections/update).")
    public List<SupportedDataSourcesEnum> getSupportedDataSources() {
        return this.supportedDataSources;
    }

    public void setSupportedDataSources(List<SupportedDataSourcesEnum> supportedDataSources) {
        this.supportedDataSources = supportedDataSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bank bank = (Bank)o;
        return Objects.equals(this.id, bank.id) && Objects.equals(this.name, bank.name) && Objects.equals(this.loginHint, bank.loginHint) && Objects.equals(this.bic, bank.bic) && Objects.equals(this.blz, bank.blz) && Objects.equals(this.blzs, bank.blzs) && Objects.equals(this.loginFieldUserId, bank.loginFieldUserId) && Objects.equals(this.loginFieldCustomerId, bank.loginFieldCustomerId) && Objects.equals(this.loginFieldPin, bank.loginFieldPin) && Objects.equals(this.isSupported, bank.isSupported) && Objects.equals(this.supportedDataSources, bank.supportedDataSources);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.loginHint, this.bic, this.blz, this.blzs, this.loginFieldUserId, this.loginFieldCustomerId, this.loginFieldPin, this.isSupported, this.supportedDataSources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bank {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    loginHint: ").append(this.toIndentedString(this.loginHint)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    blz: ").append(this.toIndentedString(this.blz)).append("\n");
        sb.append("    blzs: ").append(this.toIndentedString(this.blzs)).append("\n");
        sb.append("    loginFieldUserId: ").append(this.toIndentedString(this.loginFieldUserId)).append("\n");
        sb.append("    loginFieldCustomerId: ").append(this.toIndentedString(this.loginFieldCustomerId)).append("\n");
        sb.append("    loginFieldPin: ").append(this.toIndentedString(this.loginFieldPin)).append("\n");
        sb.append("    isSupported: ").append(this.toIndentedString(this.isSupported)).append("\n");
        sb.append("    supportedDataSources: ").append(this.toIndentedString(this.supportedDataSources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SupportedDataSourcesEnum {
        WEB_SCRAPER("WEB_SCRAPER"),
        FINTS_SERVER("FINTS_SERVER");

        private String value;

        private SupportedDataSourcesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

