/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Apiv1testsmockBatchUpdateNewTransactions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Mock account data")
public class Apiv1testsmockBatchUpdateMockAccountsData {
    @SerializedName(value="accountId")
    private Long accountId = null;
    @SerializedName(value="accountBalance")
    private BigDecimal accountBalance = null;
    @SerializedName(value="newTransactions")
    private List<Apiv1testsmockBatchUpdateNewTransactions> newTransactions = new ArrayList<Apiv1testsmockBatchUpdateNewTransactions>();

    public Apiv1testsmockBatchUpdateMockAccountsData accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Account identifier")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Apiv1testsmockBatchUpdateMockAccountsData accountBalance(BigDecimal accountBalance) {
        this.accountBalance = accountBalance;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The balance that this account should be set to. Note that when the balance does not add up to the current balance plus the sum of the transactions you pass in the 'newTransactions' field, finAPI will fix the balance deviation with the insertion of a 'Zwischensaldo' transaction.")
    public BigDecimal getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(BigDecimal accountBalance) {
        this.accountBalance = accountBalance;
    }

    public Apiv1testsmockBatchUpdateMockAccountsData newTransactions(List<Apiv1testsmockBatchUpdateNewTransactions> newTransactions) {
        this.newTransactions = newTransactions;
        return this;
    }

    public Apiv1testsmockBatchUpdateMockAccountsData addNewTransactionsItem(Apiv1testsmockBatchUpdateNewTransactions newTransactionsItem) {
        this.newTransactions.add(newTransactionsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="New transactions that should be imported into the account (maximum 1000 transactions at once). Please make sure that the value you pass in the 'accountBalance' field equals the current account balance plus the sum of the new transactions that you pass here, otherwise finAPI will detect a deviation in the balance and fix it with the insertion of a 'Zwischensaldo' transaction. Please also note that it is not guaranteed that all transactions that you pass here will actually get imported. More specifically, finAPI will ignore any transactions whose booking date is prior to the booking date of the latest currently existing transactions minus 10 days (which is the 'update window' that finAPI uses when importing new transactions). Also, finAPI will ignore any transactions that are considered duplicates of already existing transactions within the update window. This is the case for instance when you try to import a new transaction with the same booking date and same amount as an already existing transaction. In such cases, you might get a 'Zwischensaldo' transaction too, as your given balance might not add up to the transactions that will exist in the account after the update.")
    public List<Apiv1testsmockBatchUpdateNewTransactions> getNewTransactions() {
        return this.newTransactions;
    }

    public void setNewTransactions(List<Apiv1testsmockBatchUpdateNewTransactions> newTransactions) {
        this.newTransactions = newTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Apiv1testsmockBatchUpdateMockAccountsData apiv1testsmockBatchUpdateMockAccountsData = (Apiv1testsmockBatchUpdateMockAccountsData)o;
        return Objects.equals(this.accountId, apiv1testsmockBatchUpdateMockAccountsData.accountId) && Objects.equals(this.accountBalance, apiv1testsmockBatchUpdateMockAccountsData.accountBalance) && Objects.equals(this.newTransactions, apiv1testsmockBatchUpdateMockAccountsData.newTransactions);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountBalance, this.newTransactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Apiv1testsmockBatchUpdateMockAccountsData {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountBalance: ").append(this.toIndentedString(this.accountBalance)).append("\n");
        sb.append("    newTransactions: ").append(this.toIndentedString(this.newTransactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

