/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Recipient data for a single money transfer order")
public class Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers {
    @SerializedName(value="recipientName")
    private String recipientName = null;
    @SerializedName(value="recipientIban")
    private String recipientIban = null;
    @SerializedName(value="recipientBic")
    private String recipientBic = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="purpose")
    private String purpose = null;

    public Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers recipientName(String recipientName) {
        this.recipientName = recipientName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the recipient. Note: Neither finAPI nor the involved bank servers are guaranteed to validate the recipient name. Even if the recipient name does not depict the actual registered account holder of the specified recipient account, the money transfer request might still be successful.")
    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers recipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="IBAN of the recipient's account")
    public String getRecipientIban() {
        return this.recipientIban;
    }

    public void setRecipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
    }

    public Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers recipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
        return this;
    }

    @ApiModelProperty(example="null", value="BIC of the recipient's account. Note: This field is optional if - and only if - the bank connection of the account that you want to transfer money from supports the IBAN-Only money transfer. You can find this out via GET /bankConnections/<id>. Also note that when a BIC is given, then this BIC will be used for the money transfer request independent of whether it is required or not.")
    public String getRecipientBic() {
        return this.recipientBic;
    }

    public void setRecipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
    }

    public Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The amount to transfer. Must be a positive decimal number with at most two decimal places (e.g. 99.90)")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The purpose of the transfer transaction")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers = (Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers)o;
        return Objects.equals(this.recipientName, apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers.recipientName) && Objects.equals(this.recipientIban, apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers.recipientIban) && Objects.equals(this.recipientBic, apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers.recipientBic) && Objects.equals(this.amount, apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers.amount) && Objects.equals(this.purpose, apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers.purpose);
    }

    public int hashCode() {
        return Objects.hash(this.recipientName, this.recipientIban, this.recipientBic, this.amount, this.purpose);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Apiv1accountsrequestSepaMoneyTransferAdditionalMoneyTransfers {\n");
        sb.append("    recipientName: ").append(this.toIndentedString(this.recipientName)).append("\n");
        sb.append("    recipientIban: ").append(this.toIndentedString(this.recipientIban)).append("\n");
        sb.append("    recipientBic: ").append(this.toIndentedString(this.recipientBic)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

