/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Container for a bank account's data")
public class Account {
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="bankConnectionId")
    private Long bankConnectionId = null;
    @SerializedName(value="accountName")
    private String accountName = null;
    @SerializedName(value="accountNumber")
    private String accountNumber = null;
    @SerializedName(value="subAccountNumber")
    private String subAccountNumber = null;
    @SerializedName(value="iban")
    private String iban = null;
    @SerializedName(value="accountHolderName")
    private String accountHolderName = null;
    @SerializedName(value="accountHolderId")
    private String accountHolderId = null;
    @SerializedName(value="accountCurrency")
    private String accountCurrency = null;
    @SerializedName(value="accountTypeId")
    private Long accountTypeId = null;
    @SerializedName(value="accountTypeName")
    private String accountTypeName = null;
    @SerializedName(value="balance")
    private BigDecimal balance = null;
    @SerializedName(value="overdraft")
    private BigDecimal overdraft = null;
    @SerializedName(value="overdraftLimit")
    private BigDecimal overdraftLimit = null;
    @SerializedName(value="availableFunds")
    private BigDecimal availableFunds = null;
    @SerializedName(value="lastSuccessfulUpdate")
    private String lastSuccessfulUpdate = null;
    @SerializedName(value="lastUpdateAttempt")
    private String lastUpdateAttempt = null;
    @SerializedName(value="isNew")
    private Boolean isNew = false;
    @SerializedName(value="status")
    private StatusEnum status = null;

    public Account id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Account identifier")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Account bankConnectionId(Long bankConnectionId) {
        this.bankConnectionId = bankConnectionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier of the bank connection that this account belongs to")
    public Long getBankConnectionId() {
        return this.bankConnectionId;
    }

    public void setBankConnectionId(Long bankConnectionId) {
        this.bankConnectionId = bankConnectionId;
    }

    public Account accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(example="null", value="Account name")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Account accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="(National) account number. Note that this value might change whenever the account is updated (for example, leading zeros might be added or removed).")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Account subAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Account's sub-account-number. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.")
    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public Account iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(example="null", value="Account's IBAN. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public Account accountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the account holder")
    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public Account accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(example="null", value="Bank's internal identification of the account holder")
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public Account accountCurrency(String accountCurrency) {
        this.accountCurrency = accountCurrency;
        return this;
    }

    @ApiModelProperty(example="null", value="Account's currency")
    public String getAccountCurrency() {
        return this.accountCurrency;
    }

    public void setAccountCurrency(String accountCurrency) {
        this.accountCurrency = accountCurrency;
    }

    public Account accountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier of the account's type. Note that, in general, the type of an account can change any time when the account is being updated. This is subject to changes within the bank's internal account management. However, if the account's type has previously been changed explicitly (via the PATCH method), then the explicitly set type will NOT be automatically changed anymore, even if the type has changed on the bank side. <br>1 = Checking,<br>2 = Savings,<br>3 = CreditCard,<br>4 = Security,<br>5 = Loan,<br>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br>7 = Membership<br>")
    public Long getAccountTypeId() {
        return this.accountTypeId;
    }

    public void setAccountTypeId(Long accountTypeId) {
        this.accountTypeId = accountTypeId;
    }

    public Account accountTypeName(String accountTypeName) {
        this.accountTypeName = accountTypeName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the account's type")
    public String getAccountTypeName() {
        return this.accountTypeName;
    }

    public void setAccountTypeName(String accountTypeName) {
        this.accountTypeName = accountTypeName;
    }

    public Account balance(BigDecimal balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(example="null", value="Current account balance")
    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Account overdraft(BigDecimal overdraft) {
        this.overdraft = overdraft;
        return this;
    }

    @ApiModelProperty(example="null", value="Current overdraft")
    public BigDecimal getOverdraft() {
        return this.overdraft;
    }

    public void setOverdraft(BigDecimal overdraft) {
        this.overdraft = overdraft;
    }

    public Account overdraftLimit(BigDecimal overdraftLimit) {
        this.overdraftLimit = overdraftLimit;
        return this;
    }

    @ApiModelProperty(example="null", value="Overdraft limit")
    public BigDecimal getOverdraftLimit() {
        return this.overdraftLimit;
    }

    public void setOverdraftLimit(BigDecimal overdraftLimit) {
        this.overdraftLimit = overdraftLimit;
    }

    public Account availableFunds(BigDecimal availableFunds) {
        this.availableFunds = availableFunds;
        return this;
    }

    @ApiModelProperty(example="null", value="Current available funds. Note that this field is only set if finAPI can make a definite statement about the current available funds. This might not always be the case, for example if there is not enough information available about the overdraft limit and current overdraft.")
    public BigDecimal getAvailableFunds() {
        return this.availableFunds;
    }

    public void setAvailableFunds(BigDecimal availableFunds) {
        this.availableFunds = availableFunds;
    }

    public Account lastSuccessfulUpdate(String lastSuccessfulUpdate) {
        this.lastSuccessfulUpdate = lastSuccessfulUpdate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp of when the account was last successfully updated (or initially imported); more precisely: time when the account data (balance and positions) has been stored into the finAPI databases. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getLastSuccessfulUpdate() {
        return this.lastSuccessfulUpdate;
    }

    public void setLastSuccessfulUpdate(String lastSuccessfulUpdate) {
        this.lastSuccessfulUpdate = lastSuccessfulUpdate;
    }

    public Account lastUpdateAttempt(String lastUpdateAttempt) {
        this.lastUpdateAttempt = lastUpdateAttempt;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp of when the account was last tried to be updated (or initially imported); more precisely: time when the update (or initial import) was triggered. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
    public String getLastUpdateAttempt() {
        return this.lastUpdateAttempt;
    }

    public void setLastUpdateAttempt(String lastUpdateAttempt) {
        this.lastUpdateAttempt = lastUpdateAttempt;
    }

    public Account isNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicating whether this account is 'new' or not. Any newly imported account will have this flag initially set to true, and remain so until you set it to false (see PATCH /accounts/<id>). How you use this field is up to your interpretation, however it is recommended to set the flag to false for all accounts right after the initial import of the bank connection. This way, you will be able recognize accounts that get newly imported during a later update of the bank connection, by checking for any accounts with the flag set to true right after an update.")
    public Boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public Account status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The current status of the account. Possible values are:<br>&bull; <code>UPDATED</code> means that the account is up to date from finAPI's point of view. This means that no current import/update is running, and the previous import/update could successfully update the account's data (e.g. transactions and securities), and the bank given balance matched the transaction's calculated sum, meaning that no 'Zwischensaldo' was inserted.<br>&bull; <code>UPDATED_FIXED</code> means that the account is up to date from finAPI's point of view (no current import/update is running, and the previous import/update could successfully update the account's data), BUT there was a deviation in the bank given balance which was fixed by a 'Zwischensaldo' transaction.<br>&bull; <code>DOWNLOAD_IN_PROGRESS</code> means that the account's data is currently being imported/updated.<br>&bull; <code>DOWNLOAD_FAILED</code> means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account's balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.<br>&bull; <code>DEPRECATED</code> means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account's data (name, type, iban, account number, etc.) has been changed by the bank.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.id, account.id) && Objects.equals(this.bankConnectionId, account.bankConnectionId) && Objects.equals(this.accountName, account.accountName) && Objects.equals(this.accountNumber, account.accountNumber) && Objects.equals(this.subAccountNumber, account.subAccountNumber) && Objects.equals(this.iban, account.iban) && Objects.equals(this.accountHolderName, account.accountHolderName) && Objects.equals(this.accountHolderId, account.accountHolderId) && Objects.equals(this.accountCurrency, account.accountCurrency) && Objects.equals(this.accountTypeId, account.accountTypeId) && Objects.equals(this.accountTypeName, account.accountTypeName) && Objects.equals(this.balance, account.balance) && Objects.equals(this.overdraft, account.overdraft) && Objects.equals(this.overdraftLimit, account.overdraftLimit) && Objects.equals(this.availableFunds, account.availableFunds) && Objects.equals(this.lastSuccessfulUpdate, account.lastSuccessfulUpdate) && Objects.equals(this.lastUpdateAttempt, account.lastUpdateAttempt) && Objects.equals(this.isNew, account.isNew) && Objects.equals((Object)this.status, (Object)account.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.bankConnectionId, this.accountName, this.accountNumber, this.subAccountNumber, this.iban, this.accountHolderName, this.accountHolderId, this.accountCurrency, this.accountTypeId, this.accountTypeName, this.balance, this.overdraft, this.overdraftLimit, this.availableFunds, this.lastSuccessfulUpdate, this.lastUpdateAttempt, this.isNew, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    bankConnectionId: ").append(this.toIndentedString(this.bankConnectionId)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    subAccountNumber: ").append(this.toIndentedString(this.subAccountNumber)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    accountHolderName: ").append(this.toIndentedString(this.accountHolderName)).append("\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    accountCurrency: ").append(this.toIndentedString(this.accountCurrency)).append("\n");
        sb.append("    accountTypeId: ").append(this.toIndentedString(this.accountTypeId)).append("\n");
        sb.append("    accountTypeName: ").append(this.toIndentedString(this.accountTypeName)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    overdraft: ").append(this.toIndentedString(this.overdraft)).append("\n");
        sb.append("    overdraftLimit: ").append(this.toIndentedString(this.overdraftLimit)).append("\n");
        sb.append("    availableFunds: ").append(this.toIndentedString(this.availableFunds)).append("\n");
        sb.append("    lastSuccessfulUpdate: ").append(this.toIndentedString(this.lastSuccessfulUpdate)).append("\n");
        sb.append("    lastUpdateAttempt: ").append(this.toIndentedString(this.lastUpdateAttempt)).append("\n");
        sb.append("    isNew: ").append(this.toIndentedString(this.isNew)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UPDATED("UPDATED"),
        UPDATED_FIXED("UPDATED_FIXED"),
        DOWNLOAD_IN_PROGRESS("DOWNLOAD_IN_PROGRESS"),
        DOWNLOAD_FAILED("DOWNLOAD_FAILED"),
        DEPRECATED("DEPRECATED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

