/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Body13;
import io.swagger.client.model.Body14;
import io.swagger.client.model.Body15;
import io.swagger.client.model.Body16;
import io.swagger.client.model.Body17;
import io.swagger.client.model.InlineResponse2001;
import io.swagger.client.model.InlineResponse20019;
import io.swagger.client.model.InlineResponse20019Transactions;
import io.swagger.client.model.InlineResponse20020;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransactionsApi {
    private ApiClient apiClient;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call deleteAllTransactionsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAllTransactionsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.deleteAllTransactionsCall(progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2001 deleteAllTransactions() throws ApiException {
        ApiResponse<InlineResponse2001> resp = this.deleteAllTransactionsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<InlineResponse2001> deleteAllTransactionsWithHttpInfo() throws ApiException {
        Call call = this.deleteAllTransactionsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAllTransactionsAsync(final ApiCallback<InlineResponse2001> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAllTransactionsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTransactionValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTransaction(Async)");
        }
        Call call = this.deleteTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTransaction(Long id) throws ApiException {
        this.deleteTransactionWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteTransactionWithHttpInfo(Long id) throws ApiException {
        Call call = this.deleteTransactionValidateBeforeCall(id, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTransactionAsync(Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call editMultipleTransactionsCall(Body13 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body13 localVarPostBody = body;
        String localVarPath = "/api/v1/transactions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call editMultipleTransactionsValidateBeforeCall(Body13 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editMultipleTransactions(Async)");
        }
        Call call = this.editMultipleTransactionsCall(body, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2001 editMultipleTransactions(Body13 body) throws ApiException {
        ApiResponse<InlineResponse2001> resp = this.editMultipleTransactionsWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<InlineResponse2001> editMultipleTransactionsWithHttpInfo(Body13 body) throws ApiException {
        Call call = this.editMultipleTransactionsValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call editMultipleTransactionsAsync(Body13 body, final ApiCallback<InlineResponse2001> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editMultipleTransactionsValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call editMultipleTransactionsDeprecatedCall(List<Long> ids, Body15 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body15 localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/{ids}".replaceAll("\\{format\\}", "json").replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call editMultipleTransactionsDeprecatedValidateBeforeCall(List<Long> ids, Body15 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling editMultipleTransactionsDeprecated(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editMultipleTransactionsDeprecated(Async)");
        }
        Call call = this.editMultipleTransactionsDeprecatedCall(ids, body, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2001 editMultipleTransactionsDeprecated(List<Long> ids, Body15 body) throws ApiException {
        ApiResponse<InlineResponse2001> resp = this.editMultipleTransactionsDeprecatedWithHttpInfo(ids, body);
        return resp.getData();
    }

    public ApiResponse<InlineResponse2001> editMultipleTransactionsDeprecatedWithHttpInfo(List<Long> ids, Body15 body) throws ApiException {
        Call call = this.editMultipleTransactionsDeprecatedValidateBeforeCall(ids, body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call editMultipleTransactionsDeprecatedAsync(List<Long> ids, Body15 body, final ApiCallback<InlineResponse2001> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editMultipleTransactionsDeprecatedValidateBeforeCall(ids, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call editTransactionCall(Long id, Body16 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body16 localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call editTransactionValidateBeforeCall(Long id, Body16 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling editTransaction(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling editTransaction(Async)");
        }
        Call call = this.editTransactionCall(id, body, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20019Transactions editTransaction(Long id, Body16 body) throws ApiException {
        ApiResponse<InlineResponse20019Transactions> resp = this.editTransactionWithHttpInfo(id, body);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20019Transactions> editTransactionWithHttpInfo(Long id, Body16 body) throws ApiException {
        Call call = this.editTransactionValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call editTransactionAsync(Long id, Body16 body, final ApiCallback<InlineResponse20019Transactions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.editTransactionValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAndSearchAllTransactionsCall(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (ids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search", search));
        }
        if (counterpart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "counterpart", counterpart));
        }
        if (accountIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "accountIds", accountIds));
        }
        if (minBankBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minBankBookingDate", minBankBookingDate));
        }
        if (maxBankBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxBankBookingDate", maxBankBookingDate));
        }
        if (minFinapiBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minFinapiBookingDate", minFinapiBookingDate));
        }
        if (maxFinapiBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxFinapiBookingDate", maxFinapiBookingDate));
        }
        if (minAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minAmount", minAmount));
        }
        if (maxAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxAmount", maxAmount));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "direction", direction));
        }
        if (labelIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "labelIds", labelIds));
        }
        if (categoryIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "categoryIds", categoryIds));
        }
        if (includeChildCategories != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeChildCategories", includeChildCategories));
        }
        if (isNew != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "isNew", isNew));
        }
        if (isPotentialDuplicate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "isPotentialDuplicate", isPotentialDuplicate));
        }
        if (minImportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minImportDate", minImportDate));
        }
        if (maxImportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxImportDate", maxImportDate));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "perPage", perPage));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAndSearchAllTransactionsValidateBeforeCall(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (view == null) {
            throw new ApiException("Missing the required parameter 'view' when calling getAndSearchAllTransactions(Async)");
        }
        Call call = this.getAndSearchAllTransactionsCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, minImportDate, maxImportDate, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20019 getAndSearchAllTransactions(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<InlineResponse20019> resp = this.getAndSearchAllTransactionsWithHttpInfo(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, minImportDate, maxImportDate, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20019> getAndSearchAllTransactionsWithHttpInfo(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getAndSearchAllTransactionsValidateBeforeCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, minImportDate, maxImportDate, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20019>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAndSearchAllTransactionsAsync(String view, List<Long> ids, String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean includeChildCategories, Boolean isNew, Boolean isPotentialDuplicate, String minImportDate, String maxImportDate, Integer page, Integer perPage, List<String> order, final ApiCallback<InlineResponse20019> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAndSearchAllTransactionsValidateBeforeCall(view, ids, search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, includeChildCategories, isNew, isPotentialDuplicate, minImportDate, maxImportDate, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20019>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getMultipleTransactionsCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{ids}".replaceAll("\\{format\\}", "json").replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMultipleTransactionsValidateBeforeCall(List<Long> ids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleTransactions(Async)");
        }
        Call call = this.getMultipleTransactionsCall(ids, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20020 getMultipleTransactions(List<Long> ids) throws ApiException {
        ApiResponse<InlineResponse20020> resp = this.getMultipleTransactionsWithHttpInfo(ids);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20020> getMultipleTransactionsWithHttpInfo(List<Long> ids) throws ApiException {
        Call call = this.getMultipleTransactionsValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20020>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMultipleTransactionsAsync(List<Long> ids, final ApiCallback<InlineResponse20020> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMultipleTransactionsValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20020>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransactionValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTransaction(Async)");
        }
        Call call = this.getTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20019Transactions getTransaction(Long id) throws ApiException {
        ApiResponse<InlineResponse20019Transactions> resp = this.getTransactionWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20019Transactions> getTransactionWithHttpInfo(Long id) throws ApiException {
        Call call = this.getTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransactionAsync(Long id, final ApiCallback<InlineResponse20019Transactions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call restoreTransactionCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/transactions/{id}/restore".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call restoreTransactionValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restoreTransaction(Async)");
        }
        Call call = this.restoreTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20019Transactions restoreTransaction(Long id) throws ApiException {
        ApiResponse<InlineResponse20019Transactions> resp = this.restoreTransactionWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20019Transactions> restoreTransactionWithHttpInfo(Long id) throws ApiException {
        Call call = this.restoreTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call restoreTransactionAsync(Long id, final ApiCallback<InlineResponse20019Transactions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.restoreTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call splitTransactionCall(Long id, Body17 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body17 localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/{id}/split".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call splitTransactionValidateBeforeCall(Long id, Body17 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling splitTransaction(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling splitTransaction(Async)");
        }
        Call call = this.splitTransactionCall(id, body, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20019Transactions splitTransaction(Long id, Body17 body) throws ApiException {
        ApiResponse<InlineResponse20019Transactions> resp = this.splitTransactionWithHttpInfo(id, body);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20019Transactions> splitTransactionWithHttpInfo(Long id, Body17 body) throws ApiException {
        Call call = this.splitTransactionValidateBeforeCall(id, body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call splitTransactionAsync(Long id, Body17 body, final ApiCallback<InlineResponse20019Transactions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.splitTransactionValidateBeforeCall(id, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20019Transactions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call triggerCategorizationCall(Body14 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body14 localVarPostBody = body;
        String localVarPath = "/api/v1/transactions/triggerCategorization".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call triggerCategorizationValidateBeforeCall(Body14 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling triggerCategorization(Async)");
        }
        Call call = this.triggerCategorizationCall(body, progressListener, progressRequestListener);
        return call;
    }

    public void triggerCategorization(Body14 body) throws ApiException {
        this.triggerCategorizationWithHttpInfo(body);
    }

    public ApiResponse<Void> triggerCategorizationWithHttpInfo(Body14 body) throws ApiException {
        Call call = this.triggerCategorizationValidateBeforeCall(body, null, null);
        return this.apiClient.execute(call);
    }

    public Call triggerCategorizationAsync(Body14 body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.triggerCategorizationValidateBeforeCall(body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

