/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Body10;
import io.swagger.client.model.InlineResponse20014;
import io.swagger.client.model.InlineResponse20015;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MandatorAdministrationApi {
    private ApiClient apiClient;

    public MandatorAdministrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MandatorAdministrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call deleteUsersCall(Body10 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body10 localVarPostBody = body;
        String localVarPath = "/api/v1/mandatorAdmin/deleteUsers".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteUsersValidateBeforeCall(Body10 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteUsers(Async)");
        }
        Call call = this.deleteUsersCall(body, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20014 deleteUsers(Body10 body) throws ApiException {
        ApiResponse<InlineResponse20014> resp = this.deleteUsersWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20014> deleteUsersWithHttpInfo(Body10 body) throws ApiException {
        Call call = this.deleteUsersValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20014>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteUsersAsync(Body10 body, final ApiCallback<InlineResponse20014> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUsersValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20014>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUserListCall(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/mandatorAdmin/getUserList".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (minRegistrationDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minRegistrationDate", minRegistrationDate));
        }
        if (maxRegistrationDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxRegistrationDate", maxRegistrationDate));
        }
        if (minDeletionDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minDeletionDate", minDeletionDate));
        }
        if (maxDeletionDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxDeletionDate", maxDeletionDate));
        }
        if (minLastActiveDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minLastActiveDate", minLastActiveDate));
        }
        if (maxLastActiveDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxLastActiveDate", maxLastActiveDate));
        }
        if (isDeleted != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "isDeleted", isDeleted));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "perPage", perPage));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserListValidateBeforeCall(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getUserListCall(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, isDeleted, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20015 getUserList(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<InlineResponse20015> resp = this.getUserListWithHttpInfo(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, isDeleted, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20015> getUserListWithHttpInfo(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getUserListValidateBeforeCall(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, isDeleted, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20015>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserListAsync(String minRegistrationDate, String maxRegistrationDate, String minDeletionDate, String maxDeletionDate, String minLastActiveDate, String maxLastActiveDate, Boolean isDeleted, Integer page, Integer perPage, List<String> order, final ApiCallback<InlineResponse20015> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserListValidateBeforeCall(minRegistrationDate, maxRegistrationDate, minDeletionDate, maxDeletionDate, minLastActiveDate, maxLastActiveDate, isDeleted, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20015>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

