/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.Body6;
import io.swagger.client.model.InlineResponse2001;
import io.swagger.client.model.InlineResponse20010;
import io.swagger.client.model.InlineResponse2008;
import io.swagger.client.model.InlineResponse2008Categories;
import io.swagger.client.model.InlineResponse2009;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CategoriesApi {
    private ApiClient apiClient;

    public CategoriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CategoriesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createCategoryCall(Body6 body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Body6 localVarPostBody = body;
        String localVarPath = "/api/v1/categories".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createCategoryValidateBeforeCall(Body6 body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createCategoryCall(body, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2008Categories createCategory(Body6 body) throws ApiException {
        ApiResponse<InlineResponse2008Categories> resp = this.createCategoryWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<InlineResponse2008Categories> createCategoryWithHttpInfo(Body6 body) throws ApiException {
        Call call = this.createCategoryValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2008Categories>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createCategoryAsync(Body6 body, final ApiCallback<InlineResponse2008Categories> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCategoryValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2008Categories>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteAllCategoriesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/categories".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAllCategoriesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.deleteAllCategoriesCall(progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2001 deleteAllCategories() throws ApiException {
        ApiResponse<InlineResponse2001> resp = this.deleteAllCategoriesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<InlineResponse2001> deleteAllCategoriesWithHttpInfo() throws ApiException {
        Call call = this.deleteAllCategoriesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAllCategoriesAsync(final ApiCallback<InlineResponse2001> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAllCategoriesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteCategoryCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/categories/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCategoryValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteCategory(Async)");
        }
        Call call = this.deleteCategoryCall(id, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCategory(Long id) throws ApiException {
        this.deleteCategoryWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteCategoryWithHttpInfo(Long id) throws ApiException {
        Call call = this.deleteCategoryValidateBeforeCall(id, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCategoryAsync(Long id, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCategoryValidateBeforeCall(id, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getAndSearchAllCategoriesCall(List<Long> ids, String search, Boolean isCustom, Integer page, Integer perPage, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/categories".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (ids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search", search));
        }
        if (isCustom != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "isCustom", isCustom));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "perPage", perPage));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAndSearchAllCategoriesValidateBeforeCall(List<Long> ids, String search, Boolean isCustom, Integer page, Integer perPage, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAndSearchAllCategoriesCall(ids, search, isCustom, page, perPage, order, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2008 getAndSearchAllCategories(List<Long> ids, String search, Boolean isCustom, Integer page, Integer perPage, List<String> order) throws ApiException {
        ApiResponse<InlineResponse2008> resp = this.getAndSearchAllCategoriesWithHttpInfo(ids, search, isCustom, page, perPage, order);
        return resp.getData();
    }

    public ApiResponse<InlineResponse2008> getAndSearchAllCategoriesWithHttpInfo(List<Long> ids, String search, Boolean isCustom, Integer page, Integer perPage, List<String> order) throws ApiException {
        Call call = this.getAndSearchAllCategoriesValidateBeforeCall(ids, search, isCustom, page, perPage, order, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2008>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAndSearchAllCategoriesAsync(List<Long> ids, String search, Boolean isCustom, Integer page, Integer perPage, List<String> order, final ApiCallback<InlineResponse2008> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAndSearchAllCategoriesValidateBeforeCall(ids, search, isCustom, page, perPage, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2008>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCashFlowsCall(String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean isNew, String minImportDate, String maxImportDate, Boolean includeSubCashFlows, List<String> order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/categories/cashFlows".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (search != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search", search));
        }
        if (counterpart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "counterpart", counterpart));
        }
        if (accountIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "accountIds", accountIds));
        }
        if (minBankBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minBankBookingDate", minBankBookingDate));
        }
        if (maxBankBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxBankBookingDate", maxBankBookingDate));
        }
        if (minFinapiBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minFinapiBookingDate", minFinapiBookingDate));
        }
        if (maxFinapiBookingDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxFinapiBookingDate", maxFinapiBookingDate));
        }
        if (minAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minAmount", minAmount));
        }
        if (maxAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxAmount", maxAmount));
        }
        if (direction != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "direction", direction));
        }
        if (labelIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "labelIds", labelIds));
        }
        if (categoryIds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "categoryIds", categoryIds));
        }
        if (isNew != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "isNew", isNew));
        }
        if (minImportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "minImportDate", minImportDate));
        }
        if (maxImportDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxImportDate", maxImportDate));
        }
        if (includeSubCashFlows != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeSubCashFlows", includeSubCashFlows));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCashFlowsValidateBeforeCall(String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean isNew, String minImportDate, String maxImportDate, Boolean includeSubCashFlows, List<String> order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCashFlowsCall(search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, isNew, minImportDate, maxImportDate, includeSubCashFlows, order, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2009 getCashFlows(String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean isNew, String minImportDate, String maxImportDate, Boolean includeSubCashFlows, List<String> order) throws ApiException {
        ApiResponse<InlineResponse2009> resp = this.getCashFlowsWithHttpInfo(search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, isNew, minImportDate, maxImportDate, includeSubCashFlows, order);
        return resp.getData();
    }

    public ApiResponse<InlineResponse2009> getCashFlowsWithHttpInfo(String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean isNew, String minImportDate, String maxImportDate, Boolean includeSubCashFlows, List<String> order) throws ApiException {
        Call call = this.getCashFlowsValidateBeforeCall(search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, isNew, minImportDate, maxImportDate, includeSubCashFlows, order, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2009>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCashFlowsAsync(String search, String counterpart, List<Long> accountIds, String minBankBookingDate, String maxBankBookingDate, String minFinapiBookingDate, String maxFinapiBookingDate, BigDecimal minAmount, BigDecimal maxAmount, String direction, List<Long> labelIds, List<Long> categoryIds, Boolean isNew, String minImportDate, String maxImportDate, Boolean includeSubCashFlows, List<String> order, final ApiCallback<InlineResponse2009> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCashFlowsValidateBeforeCall(search, counterpart, accountIds, minBankBookingDate, maxBankBookingDate, minFinapiBookingDate, maxFinapiBookingDate, minAmount, maxAmount, direction, labelIds, categoryIds, isNew, minImportDate, maxImportDate, includeSubCashFlows, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2009>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getCategoryCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/categories/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCategoryValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCategory(Async)");
        }
        Call call = this.getCategoryCall(id, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2008Categories getCategory(Long id) throws ApiException {
        ApiResponse<InlineResponse2008Categories> resp = this.getCategoryWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<InlineResponse2008Categories> getCategoryWithHttpInfo(Long id) throws ApiException {
        Call call = this.getCategoryValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2008Categories>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCategoryAsync(Long id, final ApiCallback<InlineResponse2008Categories> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCategoryValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2008Categories>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getMultipleCategoriesCall(List<Long> ids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/categories/{ids}".replaceAll("\\{format\\}", "json").replaceAll("\\{ids\\}", this.apiClient.escapeString(ids.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMultipleCategoriesValidateBeforeCall(List<Long> ids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling getMultipleCategories(Async)");
        }
        Call call = this.getMultipleCategoriesCall(ids, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20010 getMultipleCategories(List<Long> ids) throws ApiException {
        ApiResponse<InlineResponse20010> resp = this.getMultipleCategoriesWithHttpInfo(ids);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20010> getMultipleCategoriesWithHttpInfo(List<Long> ids) throws ApiException {
        Call call = this.getMultipleCategoriesValidateBeforeCall(ids, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20010>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMultipleCategoriesAsync(List<Long> ids, final ApiCallback<InlineResponse20010> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMultipleCategoriesValidateBeforeCall(ids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20010>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

