/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.InlineResponse20024;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AuthorizationApi {
    private ApiClient apiClient;

    public AuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getTokenCall(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth/token".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (grantType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "grant_type", grantType));
        }
        if (clientId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "client_id", clientId));
        }
        if (clientSecret != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "client_secret", clientSecret));
        }
        if (refreshToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "refresh_token", refreshToken));
        }
        if (username != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "username", username));
        }
        if (password != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "password", password));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenValidateBeforeCall(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling getToken(Async)");
        }
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling getToken(Async)");
        }
        if (clientSecret == null) {
            throw new ApiException("Missing the required parameter 'clientSecret' when calling getToken(Async)");
        }
        Call call = this.getTokenCall(grantType, clientId, clientSecret, refreshToken, username, password, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse20024 getToken(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password) throws ApiException {
        ApiResponse<InlineResponse20024> resp = this.getTokenWithHttpInfo(grantType, clientId, clientSecret, refreshToken, username, password);
        return resp.getData();
    }

    public ApiResponse<InlineResponse20024> getTokenWithHttpInfo(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password) throws ApiException {
        Call call = this.getTokenValidateBeforeCall(grantType, clientId, clientSecret, refreshToken, username, password, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20024>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenAsync(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password, final ApiCallback<InlineResponse20024> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenValidateBeforeCall(grantType, clientId, clientSecret, refreshToken, username, password, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20024>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call revokeTokenCall(String token, String tokenTypeHint, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth/revoke".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (token != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "token", token));
        }
        if (tokenTypeHint != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "token_type_hint", tokenTypeHint));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"finapi_auth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call revokeTokenValidateBeforeCall(String token, String tokenTypeHint, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling revokeToken(Async)");
        }
        Call call = this.revokeTokenCall(token, tokenTypeHint, progressListener, progressRequestListener);
        return call;
    }

    public void revokeToken(String token, String tokenTypeHint) throws ApiException {
        this.revokeTokenWithHttpInfo(token, tokenTypeHint);
    }

    public ApiResponse<Void> revokeTokenWithHttpInfo(String token, String tokenTypeHint) throws ApiException {
        Call call = this.revokeTokenValidateBeforeCall(token, tokenTypeHint, null, null);
        return this.apiClient.execute(call);
    }

    public Call revokeTokenAsync(String token, String tokenTypeHint, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.revokeTokenValidateBeforeCall(token, tokenTypeHint, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

