/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.20.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
 * Container for a bank account&#39;s data
 */
@ApiModel(description = "Container for a bank account's data")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-05-17T14:26:47.047Z")
public class InlineResponse200Accounts {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("bankConnectionId")
  private Long bankConnectionId = null;

  @SerializedName("accountName")
  private String accountName = null;

  @SerializedName("accountNumber")
  private String accountNumber = null;

  @SerializedName("subAccountNumber")
  private String subAccountNumber = null;

  @SerializedName("iban")
  private String iban = null;

  @SerializedName("accountHolderName")
  private String accountHolderName = null;

  @SerializedName("accountHolderId")
  private String accountHolderId = null;

  @SerializedName("accountCurrency")
  private String accountCurrency = null;

  @SerializedName("accountTypeId")
  private Long accountTypeId = null;

  @SerializedName("accountTypeName")
  private String accountTypeName = null;

  @SerializedName("balance")
  private BigDecimal balance = null;

  @SerializedName("overdraft")
  private BigDecimal overdraft = null;

  @SerializedName("overdraftLimit")
  private BigDecimal overdraftLimit = null;

  @SerializedName("availableFunds")
  private BigDecimal availableFunds = null;

  @SerializedName("lastSuccessfulUpdate")
  private String lastSuccessfulUpdate = null;

  @SerializedName("lastUpdateAttempt")
  private String lastUpdateAttempt = null;

  @SerializedName("isNew")
  private Boolean isNew = false;

  /**
   * The current status of the account. Possible values are:<br>&bull; <code>UPDATED</code> means that the account is up to date from finAPI's point of view. This means that no current import/update is running, and the previous import/update could successfully update the account's data (e.g. transactions and securities), and the bank given balance matched the transaction's calculated sum, meaning that no 'Zwischensaldo' was inserted.<br>&bull; <code>UPDATED_FIXED</code> means that the account is up to date from finAPI's point of view (no current import/update is running, and the previous import/update could successfully update the account's data), BUT there was a deviation in the bank given balance which was fixed by a 'Zwischensaldo' transaction.<br>&bull; <code>DOWNLOAD_IN_PROGRESS</code> means that the account's data is currently being imported/updated.<br>&bull; <code>DOWNLOAD_FAILED</code> means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account's balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.<br>&bull; <code>DEPRECATED</code> means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account's data (name, type, iban, account number, etc.) has been changed by the bank.
   */
  public enum StatusEnum {
    @SerializedName("UPDATED")
    UPDATED("UPDATED"),
    
    @SerializedName("UPDATED_FIXED")
    UPDATED_FIXED("UPDATED_FIXED"),
    
    @SerializedName("DOWNLOAD_IN_PROGRESS")
    DOWNLOAD_IN_PROGRESS("DOWNLOAD_IN_PROGRESS"),
    
    @SerializedName("DOWNLOAD_FAILED")
    DOWNLOAD_FAILED("DOWNLOAD_FAILED"),
    
    @SerializedName("DEPRECATED")
    DEPRECATED("DEPRECATED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @SerializedName("status")
  private StatusEnum status = null;

  public InlineResponse200Accounts id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Account identifier
   * @return id
  **/
  @ApiModelProperty(example = "null", required = true, value = "Account identifier")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public InlineResponse200Accounts bankConnectionId(Long bankConnectionId) {
    this.bankConnectionId = bankConnectionId;
    return this;
  }

   /**
   * Identifier of the bank connection that this account belongs to
   * @return bankConnectionId
  **/
  @ApiModelProperty(example = "null", required = true, value = "Identifier of the bank connection that this account belongs to")
  public Long getBankConnectionId() {
    return bankConnectionId;
  }

  public void setBankConnectionId(Long bankConnectionId) {
    this.bankConnectionId = bankConnectionId;
  }

  public InlineResponse200Accounts accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

   /**
   * Account name
   * @return accountName
  **/
  @ApiModelProperty(example = "null", value = "Account name")
  public String getAccountName() {
    return accountName;
  }

  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }

  public InlineResponse200Accounts accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * (National) account number. Note that this value might change whenever the account is updated (for example, leading zeros might be added or removed).
   * @return accountNumber
  **/
  @ApiModelProperty(example = "null", required = true, value = "(National) account number. Note that this value might change whenever the account is updated (for example, leading zeros might be added or removed).")
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }

  public InlineResponse200Accounts subAccountNumber(String subAccountNumber) {
    this.subAccountNumber = subAccountNumber;
    return this;
  }

   /**
   * Account's sub-account-number. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.
   * @return subAccountNumber
  **/
  @ApiModelProperty(example = "null", value = "Account's sub-account-number. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.")
  public String getSubAccountNumber() {
    return subAccountNumber;
  }

  public void setSubAccountNumber(String subAccountNumber) {
    this.subAccountNumber = subAccountNumber;
  }

  public InlineResponse200Accounts iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * Account's IBAN. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.
   * @return iban
  **/
  @ApiModelProperty(example = "null", value = "Account's IBAN. Note that this field can change from 'null' to a value - or vice versa - any time when the account is being updated. This is subject to changes within the bank's internal account management.")
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }

  public InlineResponse200Accounts accountHolderName(String accountHolderName) {
    this.accountHolderName = accountHolderName;
    return this;
  }

   /**
   * Name of the account holder
   * @return accountHolderName
  **/
  @ApiModelProperty(example = "null", value = "Name of the account holder")
  public String getAccountHolderName() {
    return accountHolderName;
  }

  public void setAccountHolderName(String accountHolderName) {
    this.accountHolderName = accountHolderName;
  }

  public InlineResponse200Accounts accountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
    return this;
  }

   /**
   * Bank's internal identification of the account holder
   * @return accountHolderId
  **/
  @ApiModelProperty(example = "null", value = "Bank's internal identification of the account holder")
  public String getAccountHolderId() {
    return accountHolderId;
  }

  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }

  public InlineResponse200Accounts accountCurrency(String accountCurrency) {
    this.accountCurrency = accountCurrency;
    return this;
  }

   /**
   * Account's currency
   * @return accountCurrency
  **/
  @ApiModelProperty(example = "null", value = "Account's currency")
  public String getAccountCurrency() {
    return accountCurrency;
  }

  public void setAccountCurrency(String accountCurrency) {
    this.accountCurrency = accountCurrency;
  }

  public InlineResponse200Accounts accountTypeId(Long accountTypeId) {
    this.accountTypeId = accountTypeId;
    return this;
  }

   /**
   * Identifier of the account's type. Note that, in general, the type of an account can change any time when the account is being updated. This is subject to changes within the bank's internal account management. However, if the account's type has previously been changed explicitly (via the PATCH method), then the explicitly set type will NOT be automatically changed anymore, even if the type has changed on the bank side. <br>1 = Checking,<br>2 = Savings,<br>3 = CreditCard,<br>4 = Security,<br>5 = Loan,<br>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br>7 = Membership<br>
   * @return accountTypeId
  **/
  @ApiModelProperty(example = "null", required = true, value = "Identifier of the account's type. Note that, in general, the type of an account can change any time when the account is being updated. This is subject to changes within the bank's internal account management. However, if the account's type has previously been changed explicitly (via the PATCH method), then the explicitly set type will NOT be automatically changed anymore, even if the type has changed on the bank side. <br>1 = Checking,<br>2 = Savings,<br>3 = CreditCard,<br>4 = Security,<br>5 = Loan,<br>6 = Pocket (DEPRECATED; will not be returned for any account unless this type has explicitly been set via PATCH),<br>7 = Membership<br>")
  public Long getAccountTypeId() {
    return accountTypeId;
  }

  public void setAccountTypeId(Long accountTypeId) {
    this.accountTypeId = accountTypeId;
  }

  public InlineResponse200Accounts accountTypeName(String accountTypeName) {
    this.accountTypeName = accountTypeName;
    return this;
  }

   /**
   * Name of the account's type
   * @return accountTypeName
  **/
  @ApiModelProperty(example = "null", required = true, value = "Name of the account's type")
  public String getAccountTypeName() {
    return accountTypeName;
  }

  public void setAccountTypeName(String accountTypeName) {
    this.accountTypeName = accountTypeName;
  }

  public InlineResponse200Accounts balance(BigDecimal balance) {
    this.balance = balance;
    return this;
  }

   /**
   * Current account balance
   * @return balance
  **/
  @ApiModelProperty(example = "null", value = "Current account balance")
  public BigDecimal getBalance() {
    return balance;
  }

  public void setBalance(BigDecimal balance) {
    this.balance = balance;
  }

  public InlineResponse200Accounts overdraft(BigDecimal overdraft) {
    this.overdraft = overdraft;
    return this;
  }

   /**
   * Current overdraft
   * @return overdraft
  **/
  @ApiModelProperty(example = "null", value = "Current overdraft")
  public BigDecimal getOverdraft() {
    return overdraft;
  }

  public void setOverdraft(BigDecimal overdraft) {
    this.overdraft = overdraft;
  }

  public InlineResponse200Accounts overdraftLimit(BigDecimal overdraftLimit) {
    this.overdraftLimit = overdraftLimit;
    return this;
  }

   /**
   * Overdraft limit
   * @return overdraftLimit
  **/
  @ApiModelProperty(example = "null", value = "Overdraft limit")
  public BigDecimal getOverdraftLimit() {
    return overdraftLimit;
  }

  public void setOverdraftLimit(BigDecimal overdraftLimit) {
    this.overdraftLimit = overdraftLimit;
  }

  public InlineResponse200Accounts availableFunds(BigDecimal availableFunds) {
    this.availableFunds = availableFunds;
    return this;
  }

   /**
   * Current available funds. Note that this field is only set if finAPI can make a definite statement about the current available funds. This might not always be the case, for example if there is not enough information available about the overdraft limit and current overdraft.
   * @return availableFunds
  **/
  @ApiModelProperty(example = "null", value = "Current available funds. Note that this field is only set if finAPI can make a definite statement about the current available funds. This might not always be the case, for example if there is not enough information available about the overdraft limit and current overdraft.")
  public BigDecimal getAvailableFunds() {
    return availableFunds;
  }

  public void setAvailableFunds(BigDecimal availableFunds) {
    this.availableFunds = availableFunds;
  }

  public InlineResponse200Accounts lastSuccessfulUpdate(String lastSuccessfulUpdate) {
    this.lastSuccessfulUpdate = lastSuccessfulUpdate;
    return this;
  }

   /**
   * Timestamp of when the account was last successfully updated (or initially imported); more precisely: time when the account data (balance and positions) has been stored into the finAPI databases. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).
   * @return lastSuccessfulUpdate
  **/
  @ApiModelProperty(example = "null", value = "Timestamp of when the account was last successfully updated (or initially imported); more precisely: time when the account data (balance and positions) has been stored into the finAPI databases. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
  public String getLastSuccessfulUpdate() {
    return lastSuccessfulUpdate;
  }

  public void setLastSuccessfulUpdate(String lastSuccessfulUpdate) {
    this.lastSuccessfulUpdate = lastSuccessfulUpdate;
  }

  public InlineResponse200Accounts lastUpdateAttempt(String lastUpdateAttempt) {
    this.lastUpdateAttempt = lastUpdateAttempt;
    return this;
  }

   /**
   * Timestamp of when the account was last tried to be updated (or initially imported); more precisely: time when the update (or initial import) was triggered. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).
   * @return lastUpdateAttempt
  **/
  @ApiModelProperty(example = "null", value = "Timestamp of when the account was last tried to be updated (or initially imported); more precisely: time when the update (or initial import) was triggered. The value is returned in the format 'yyyy-MM-dd HH:mm:ss.SSS' (german time).")
  public String getLastUpdateAttempt() {
    return lastUpdateAttempt;
  }

  public void setLastUpdateAttempt(String lastUpdateAttempt) {
    this.lastUpdateAttempt = lastUpdateAttempt;
  }

  public InlineResponse200Accounts isNew(Boolean isNew) {
    this.isNew = isNew;
    return this;
  }

   /**
   * Indicating whether this account is 'new' or not. Any newly imported account will have this flag initially set to true, and remain so until you set it to false (see PATCH /accounts/<id>). How you use this field is up to your interpretation, however it is recommended to set the flag to false for all accounts right after the initial import of the bank connection. This way, you will be able recognize accounts that get newly imported during a later update of the bank connection, by checking for any accounts with the flag set to true right after an update.
   * @return isNew
  **/
  @ApiModelProperty(example = "null", required = true, value = "Indicating whether this account is 'new' or not. Any newly imported account will have this flag initially set to true, and remain so until you set it to false (see PATCH /accounts/<id>). How you use this field is up to your interpretation, however it is recommended to set the flag to false for all accounts right after the initial import of the bank connection. This way, you will be able recognize accounts that get newly imported during a later update of the bank connection, by checking for any accounts with the flag set to true right after an update.")
  public Boolean getIsNew() {
    return isNew;
  }

  public void setIsNew(Boolean isNew) {
    this.isNew = isNew;
  }

  public InlineResponse200Accounts status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * The current status of the account. Possible values are:<br>&bull; <code>UPDATED</code> means that the account is up to date from finAPI's point of view. This means that no current import/update is running, and the previous import/update could successfully update the account's data (e.g. transactions and securities), and the bank given balance matched the transaction's calculated sum, meaning that no 'Zwischensaldo' was inserted.<br>&bull; <code>UPDATED_FIXED</code> means that the account is up to date from finAPI's point of view (no current import/update is running, and the previous import/update could successfully update the account's data), BUT there was a deviation in the bank given balance which was fixed by a 'Zwischensaldo' transaction.<br>&bull; <code>DOWNLOAD_IN_PROGRESS</code> means that the account's data is currently being imported/updated.<br>&bull; <code>DOWNLOAD_FAILED</code> means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account's balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.<br>&bull; <code>DEPRECATED</code> means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account's data (name, type, iban, account number, etc.) has been changed by the bank.
   * @return status
  **/
  @ApiModelProperty(example = "null", required = true, value = "The current status of the account. Possible values are:<br>&bull; <code>UPDATED</code> means that the account is up to date from finAPI's point of view. This means that no current import/update is running, and the previous import/update could successfully update the account's data (e.g. transactions and securities), and the bank given balance matched the transaction's calculated sum, meaning that no 'Zwischensaldo' was inserted.<br>&bull; <code>UPDATED_FIXED</code> means that the account is up to date from finAPI's point of view (no current import/update is running, and the previous import/update could successfully update the account's data), BUT there was a deviation in the bank given balance which was fixed by a 'Zwischensaldo' transaction.<br>&bull; <code>DOWNLOAD_IN_PROGRESS</code> means that the account's data is currently being imported/updated.<br>&bull; <code>DOWNLOAD_FAILED</code> means that the account data could not get successfully imported or updated. Possible reasons: finAPI could not get the account's balance, or it could not parse all transactions/securities, or some internal error has occurred. Also, it could mean that finAPI could not even get to the point of receiving the account data from the bank server, for example because of incorrect login credentials or a network problem. Note however that when we get a balance and just an empty list of transactions or securities, then this is regarded as valid and successful download. The reason for this is that for some accounts that have little activity, we may actually get no recent transactions but only a balance.<br>&bull; <code>DEPRECATED</code> means that the account could no longer get matched with any account from the bank server. This can mean either that the account was terminated by the user and is no longer sent by the bank server, or that finAPI could no longer match it because the account's data (name, type, iban, account number, etc.) has been changed by the bank.")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse200Accounts inlineResponse200Accounts = (InlineResponse200Accounts) o;
    return Objects.equals(this.id, inlineResponse200Accounts.id) &&
        Objects.equals(this.bankConnectionId, inlineResponse200Accounts.bankConnectionId) &&
        Objects.equals(this.accountName, inlineResponse200Accounts.accountName) &&
        Objects.equals(this.accountNumber, inlineResponse200Accounts.accountNumber) &&
        Objects.equals(this.subAccountNumber, inlineResponse200Accounts.subAccountNumber) &&
        Objects.equals(this.iban, inlineResponse200Accounts.iban) &&
        Objects.equals(this.accountHolderName, inlineResponse200Accounts.accountHolderName) &&
        Objects.equals(this.accountHolderId, inlineResponse200Accounts.accountHolderId) &&
        Objects.equals(this.accountCurrency, inlineResponse200Accounts.accountCurrency) &&
        Objects.equals(this.accountTypeId, inlineResponse200Accounts.accountTypeId) &&
        Objects.equals(this.accountTypeName, inlineResponse200Accounts.accountTypeName) &&
        Objects.equals(this.balance, inlineResponse200Accounts.balance) &&
        Objects.equals(this.overdraft, inlineResponse200Accounts.overdraft) &&
        Objects.equals(this.overdraftLimit, inlineResponse200Accounts.overdraftLimit) &&
        Objects.equals(this.availableFunds, inlineResponse200Accounts.availableFunds) &&
        Objects.equals(this.lastSuccessfulUpdate, inlineResponse200Accounts.lastSuccessfulUpdate) &&
        Objects.equals(this.lastUpdateAttempt, inlineResponse200Accounts.lastUpdateAttempt) &&
        Objects.equals(this.isNew, inlineResponse200Accounts.isNew) &&
        Objects.equals(this.status, inlineResponse200Accounts.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, bankConnectionId, accountName, accountNumber, subAccountNumber, iban, accountHolderName, accountHolderId, accountCurrency, accountTypeId, accountTypeName, balance, overdraft, overdraftLimit, availableFunds, lastSuccessfulUpdate, lastUpdateAttempt, isNew, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse200Accounts {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    bankConnectionId: ").append(toIndentedString(bankConnectionId)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    subAccountNumber: ").append(toIndentedString(subAccountNumber)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    accountHolderName: ").append(toIndentedString(accountHolderName)).append("\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    accountCurrency: ").append(toIndentedString(accountCurrency)).append("\n");
    sb.append("    accountTypeId: ").append(toIndentedString(accountTypeId)).append("\n");
    sb.append("    accountTypeName: ").append(toIndentedString(accountTypeName)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    overdraft: ").append(toIndentedString(overdraft)).append("\n");
    sb.append("    overdraftLimit: ").append(toIndentedString(overdraftLimit)).append("\n");
    sb.append("    availableFunds: ").append(toIndentedString(availableFunds)).append("\n");
    sb.append("    lastSuccessfulUpdate: ").append(toIndentedString(lastSuccessfulUpdate)).append("\n");
    sb.append("    lastUpdateAttempt: ").append(toIndentedString(lastUpdateAttempt)).append("\n");
    sb.append("    isNew: ").append(toIndentedString(isNew)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

