/*
 * finAPI RESTful Services
 * finAPI RESTful Services
 *
 * OpenAPI spec version: v1.20.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.InlineResponse20024;
import io.swagger.client.model.InlineResponse401;
import io.swagger.client.model.InlineResponse403;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthorizationApi {
    private ApiClient apiClient;

    public AuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /* Build call for getToken */
    private com.squareup.okhttp.Call getTokenCall(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/oauth/token".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (grantType != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "grant_type", grantType));
        if (clientId != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "client_id", clientId));
        if (clientSecret != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "client_secret", clientSecret));
        if (refreshToken != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "refresh_token", refreshToken));
        if (username != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "username", username));
        if (password != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "password", password));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTokenValidateBeforeCall(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'grantType' is set
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling getToken(Async)");
        }
        
        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling getToken(Async)");
        }
        
        // verify the required parameter 'clientSecret' is set
        if (clientSecret == null) {
            throw new ApiException("Missing the required parameter 'clientSecret' when calling getToken(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getTokenCall(grantType, clientId, clientSecret, refreshToken, username, password, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get tokens
     * finAPI implements the OAuth 2.0 Standard for authorizing applications and users within applications. OAuth uses the terminology of clients and users. A client represents an application that calls finAPI services. A service call might be in the context of a user of the client (e.g.: getting a user&#39;s bank connections), or outside any user context (e.g.: editing your client&#39;s configuration, or creating a new user for your client). In any case, every service call must be authorized by an access_token. This service can be used to get such an access_token, for either one of the client&#39;s users, or for the client itself. Also, this service can be used to refresh the access_token of a user that has previously requested an access_token.&lt;br/&gt;&lt;br/&gt;To get a token, you must always pass a valid client identifier and client secret (&#x3D;client credentials). You can get free client credentials for the sandbox &lt;a href&#x3D;&#39;http://www.finapi.io/jetzt-testen/&#39;&gt;here&lt;/a&gt;. Alternatively, you can also contact us at &lt;a href&#x3D;&#39;mailto:support@finapi.io&#39;&gt;support@finapi.io&lt;/a&gt;.&lt;br/&gt;&lt;br/&gt;The authorization process is similar for both a user within a client, and for the client itself: &lt;br/&gt;&amp;bull; To authorize a client (i.e. application), use &lt;code&gt;grant_type&#x3D;client_credentials&lt;/code&gt;&lt;br/&gt;&amp;bull; To authorize a user, use &lt;code&gt;grant_type&#x3D;password&lt;/code&gt;&lt;br/&gt;&lt;br/&gt;If the given parameters are valid, the service will respond with the authorization data. &lt;br/&gt;Here is an example of a response when authorizing a user: &lt;br/&gt;&lt;pre&gt;{    \&quot;access_token\&quot;: \&quot;1471e085-2961-4c48-8d98-1b108184a730\&quot;,    \&quot;token_type\&quot;: \&quot;bearer\&quot;,    \&quot;refresh_token\&quot;: \&quot;a78f52d6-0d5a-40b5-be72-46e7fdbbd464\&quot;,    \&quot;expires_in\&quot;: 3600,    \&quot;scope\&quot;: \&quot;all\&quot; }&lt;/pre&gt;&lt;br/&gt;Use the returned access_token for other service calls by sending it in the header: &lt;br/&gt;&lt;br/&gt;&lt;pre&gt;Authorization: Bearer 1471e085-2961-4c48-8d98-1b108184a730&lt;/pre&gt;&lt;p&gt;&lt;b&gt;WARNING&lt;/b&gt;: Sending the access_token as a request parameter is deprecated and will probably be no longer supported in the next release of finAPI. Please always send the access_token in the request header, as shown above.&lt;/p&gt;&lt;p&gt;By default, the access tokens have an expiration time of one hour (however, you can change this via the service PATCH /clientConfiguration). If a token has expired, then using the token for a service call will result in a HTTP code 401. To restore access you can simply get a new token (as it is described above) or use &lt;code&gt;grant_type&#x3D;refresh_token&lt;/code&gt; (which works for user-related tokens only). In the latter case you just have to pass the previously received &lt;code&gt;refresh_token&lt;/code&gt; for the user.&lt;/p&gt;&lt;p&gt;If the user that you want to authorize is not yet verified by the client (please see the &#39;isUserAutoVerificationEnabled&#39; flag in the Client Configuration), then the service will respond with HTTP code 403. If the user is locked (see &#39;maxUserLoginAttempts&#39; in the Client Configuration), the service will respond with HTTP code 423.&lt;/p&gt;&lt;p&gt;If the current role has no privileges to call a certain service (e.g. if a user tries to create a new user, or if a client tries to access user data outside of any user context), then the request will fail with the HTTP code 403.&lt;/p&gt;&lt;p&gt;&lt;b&gt;IMPORTANT NOTE:&lt;/b&gt; You should use this service only when you actually need a new token. As long as a token exists and has not expired, the service will always return the same token for the same credentials. Calling this service repeatedly with the same credentials contradicts the idea behind the tokens in OAuth, and will have a negative impact on the performance of your application. So instead of retrieving the same tokens over and over with this service, you should cache the tokens and re-use them as long as they have not expired - or at least as long as you&#39;re using the same tokens repeatedly, e.g. for the time of an active user session in your application.&lt;/p&gt;
     * @param grantType Determines the required type of authorization:password - authorize a user; client_credentials - authorize a client;refresh_token - refresh a user&#39;s access_token. (required)
     * @param clientId Client identifier (required)
     * @param clientSecret Client secret (required)
     * @param refreshToken Refresh token. Required for grant_type&#x3D;refresh_token only. (optional)
     * @param username User identifier. Required for grant_type&#x3D;password only. (optional)
     * @param password User password. Required for grant_type&#x3D;password only. (optional)
     * @return InlineResponse20024
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse20024 getToken(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password) throws ApiException {
        ApiResponse<InlineResponse20024> resp = getTokenWithHttpInfo(grantType, clientId, clientSecret, refreshToken, username, password);
        return resp.getData();
    }

    /**
     * Get tokens
     * finAPI implements the OAuth 2.0 Standard for authorizing applications and users within applications. OAuth uses the terminology of clients and users. A client represents an application that calls finAPI services. A service call might be in the context of a user of the client (e.g.: getting a user&#39;s bank connections), or outside any user context (e.g.: editing your client&#39;s configuration, or creating a new user for your client). In any case, every service call must be authorized by an access_token. This service can be used to get such an access_token, for either one of the client&#39;s users, or for the client itself. Also, this service can be used to refresh the access_token of a user that has previously requested an access_token.&lt;br/&gt;&lt;br/&gt;To get a token, you must always pass a valid client identifier and client secret (&#x3D;client credentials). You can get free client credentials for the sandbox &lt;a href&#x3D;&#39;http://www.finapi.io/jetzt-testen/&#39;&gt;here&lt;/a&gt;. Alternatively, you can also contact us at &lt;a href&#x3D;&#39;mailto:support@finapi.io&#39;&gt;support@finapi.io&lt;/a&gt;.&lt;br/&gt;&lt;br/&gt;The authorization process is similar for both a user within a client, and for the client itself: &lt;br/&gt;&amp;bull; To authorize a client (i.e. application), use &lt;code&gt;grant_type&#x3D;client_credentials&lt;/code&gt;&lt;br/&gt;&amp;bull; To authorize a user, use &lt;code&gt;grant_type&#x3D;password&lt;/code&gt;&lt;br/&gt;&lt;br/&gt;If the given parameters are valid, the service will respond with the authorization data. &lt;br/&gt;Here is an example of a response when authorizing a user: &lt;br/&gt;&lt;pre&gt;{    \&quot;access_token\&quot;: \&quot;1471e085-2961-4c48-8d98-1b108184a730\&quot;,    \&quot;token_type\&quot;: \&quot;bearer\&quot;,    \&quot;refresh_token\&quot;: \&quot;a78f52d6-0d5a-40b5-be72-46e7fdbbd464\&quot;,    \&quot;expires_in\&quot;: 3600,    \&quot;scope\&quot;: \&quot;all\&quot; }&lt;/pre&gt;&lt;br/&gt;Use the returned access_token for other service calls by sending it in the header: &lt;br/&gt;&lt;br/&gt;&lt;pre&gt;Authorization: Bearer 1471e085-2961-4c48-8d98-1b108184a730&lt;/pre&gt;&lt;p&gt;&lt;b&gt;WARNING&lt;/b&gt;: Sending the access_token as a request parameter is deprecated and will probably be no longer supported in the next release of finAPI. Please always send the access_token in the request header, as shown above.&lt;/p&gt;&lt;p&gt;By default, the access tokens have an expiration time of one hour (however, you can change this via the service PATCH /clientConfiguration). If a token has expired, then using the token for a service call will result in a HTTP code 401. To restore access you can simply get a new token (as it is described above) or use &lt;code&gt;grant_type&#x3D;refresh_token&lt;/code&gt; (which works for user-related tokens only). In the latter case you just have to pass the previously received &lt;code&gt;refresh_token&lt;/code&gt; for the user.&lt;/p&gt;&lt;p&gt;If the user that you want to authorize is not yet verified by the client (please see the &#39;isUserAutoVerificationEnabled&#39; flag in the Client Configuration), then the service will respond with HTTP code 403. If the user is locked (see &#39;maxUserLoginAttempts&#39; in the Client Configuration), the service will respond with HTTP code 423.&lt;/p&gt;&lt;p&gt;If the current role has no privileges to call a certain service (e.g. if a user tries to create a new user, or if a client tries to access user data outside of any user context), then the request will fail with the HTTP code 403.&lt;/p&gt;&lt;p&gt;&lt;b&gt;IMPORTANT NOTE:&lt;/b&gt; You should use this service only when you actually need a new token. As long as a token exists and has not expired, the service will always return the same token for the same credentials. Calling this service repeatedly with the same credentials contradicts the idea behind the tokens in OAuth, and will have a negative impact on the performance of your application. So instead of retrieving the same tokens over and over with this service, you should cache the tokens and re-use them as long as they have not expired - or at least as long as you&#39;re using the same tokens repeatedly, e.g. for the time of an active user session in your application.&lt;/p&gt;
     * @param grantType Determines the required type of authorization:password - authorize a user; client_credentials - authorize a client;refresh_token - refresh a user&#39;s access_token. (required)
     * @param clientId Client identifier (required)
     * @param clientSecret Client secret (required)
     * @param refreshToken Refresh token. Required for grant_type&#x3D;refresh_token only. (optional)
     * @param username User identifier. Required for grant_type&#x3D;password only. (optional)
     * @param password User password. Required for grant_type&#x3D;password only. (optional)
     * @return ApiResponse&lt;InlineResponse20024&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse20024> getTokenWithHttpInfo(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password) throws ApiException {
        com.squareup.okhttp.Call call = getTokenValidateBeforeCall(grantType, clientId, clientSecret, refreshToken, username, password, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse20024>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get tokens (asynchronously)
     * finAPI implements the OAuth 2.0 Standard for authorizing applications and users within applications. OAuth uses the terminology of clients and users. A client represents an application that calls finAPI services. A service call might be in the context of a user of the client (e.g.: getting a user&#39;s bank connections), or outside any user context (e.g.: editing your client&#39;s configuration, or creating a new user for your client). In any case, every service call must be authorized by an access_token. This service can be used to get such an access_token, for either one of the client&#39;s users, or for the client itself. Also, this service can be used to refresh the access_token of a user that has previously requested an access_token.&lt;br/&gt;&lt;br/&gt;To get a token, you must always pass a valid client identifier and client secret (&#x3D;client credentials). You can get free client credentials for the sandbox &lt;a href&#x3D;&#39;http://www.finapi.io/jetzt-testen/&#39;&gt;here&lt;/a&gt;. Alternatively, you can also contact us at &lt;a href&#x3D;&#39;mailto:support@finapi.io&#39;&gt;support@finapi.io&lt;/a&gt;.&lt;br/&gt;&lt;br/&gt;The authorization process is similar for both a user within a client, and for the client itself: &lt;br/&gt;&amp;bull; To authorize a client (i.e. application), use &lt;code&gt;grant_type&#x3D;client_credentials&lt;/code&gt;&lt;br/&gt;&amp;bull; To authorize a user, use &lt;code&gt;grant_type&#x3D;password&lt;/code&gt;&lt;br/&gt;&lt;br/&gt;If the given parameters are valid, the service will respond with the authorization data. &lt;br/&gt;Here is an example of a response when authorizing a user: &lt;br/&gt;&lt;pre&gt;{    \&quot;access_token\&quot;: \&quot;1471e085-2961-4c48-8d98-1b108184a730\&quot;,    \&quot;token_type\&quot;: \&quot;bearer\&quot;,    \&quot;refresh_token\&quot;: \&quot;a78f52d6-0d5a-40b5-be72-46e7fdbbd464\&quot;,    \&quot;expires_in\&quot;: 3600,    \&quot;scope\&quot;: \&quot;all\&quot; }&lt;/pre&gt;&lt;br/&gt;Use the returned access_token for other service calls by sending it in the header: &lt;br/&gt;&lt;br/&gt;&lt;pre&gt;Authorization: Bearer 1471e085-2961-4c48-8d98-1b108184a730&lt;/pre&gt;&lt;p&gt;&lt;b&gt;WARNING&lt;/b&gt;: Sending the access_token as a request parameter is deprecated and will probably be no longer supported in the next release of finAPI. Please always send the access_token in the request header, as shown above.&lt;/p&gt;&lt;p&gt;By default, the access tokens have an expiration time of one hour (however, you can change this via the service PATCH /clientConfiguration). If a token has expired, then using the token for a service call will result in a HTTP code 401. To restore access you can simply get a new token (as it is described above) or use &lt;code&gt;grant_type&#x3D;refresh_token&lt;/code&gt; (which works for user-related tokens only). In the latter case you just have to pass the previously received &lt;code&gt;refresh_token&lt;/code&gt; for the user.&lt;/p&gt;&lt;p&gt;If the user that you want to authorize is not yet verified by the client (please see the &#39;isUserAutoVerificationEnabled&#39; flag in the Client Configuration), then the service will respond with HTTP code 403. If the user is locked (see &#39;maxUserLoginAttempts&#39; in the Client Configuration), the service will respond with HTTP code 423.&lt;/p&gt;&lt;p&gt;If the current role has no privileges to call a certain service (e.g. if a user tries to create a new user, or if a client tries to access user data outside of any user context), then the request will fail with the HTTP code 403.&lt;/p&gt;&lt;p&gt;&lt;b&gt;IMPORTANT NOTE:&lt;/b&gt; You should use this service only when you actually need a new token. As long as a token exists and has not expired, the service will always return the same token for the same credentials. Calling this service repeatedly with the same credentials contradicts the idea behind the tokens in OAuth, and will have a negative impact on the performance of your application. So instead of retrieving the same tokens over and over with this service, you should cache the tokens and re-use them as long as they have not expired - or at least as long as you&#39;re using the same tokens repeatedly, e.g. for the time of an active user session in your application.&lt;/p&gt;
     * @param grantType Determines the required type of authorization:password - authorize a user; client_credentials - authorize a client;refresh_token - refresh a user&#39;s access_token. (required)
     * @param clientId Client identifier (required)
     * @param clientSecret Client secret (required)
     * @param refreshToken Refresh token. Required for grant_type&#x3D;refresh_token only. (optional)
     * @param username User identifier. Required for grant_type&#x3D;password only. (optional)
     * @param password User password. Required for grant_type&#x3D;password only. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTokenAsync(String grantType, String clientId, String clientSecret, String refreshToken, String username, String password, final ApiCallback<InlineResponse20024> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTokenValidateBeforeCall(grantType, clientId, clientSecret, refreshToken, username, password, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse20024>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /* Build call for revokeToken */
    private com.squareup.okhttp.Call revokeTokenCall(String token, String tokenTypeHint, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/oauth/revoke".replaceAll("\\{format\\}","json");

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (token != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "token", token));
        if (tokenTypeHint != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "token_type_hint", tokenTypeHint));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "finapi_auth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call revokeTokenValidateBeforeCall(String token, String tokenTypeHint, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'token' is set
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling revokeToken(Async)");
        }
        
        
        com.squareup.okhttp.Call call = revokeTokenCall(token, tokenTypeHint, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Revoke a token
     * An additional endpoint for the OAuth 2.0 Standard, which allows clients to notify finAPI that a previously obtained refresh_token or access_token is no longer required. A successful request will invalidate the given token. The revocation of a particular token may also cause the revocation of related tokens and the underlying authorization grant. For token_type_hint&#x3D;access_token finAPI will invalidate only the given access_token. For token_type_hint&#x3D;refresh_token, finAPI will invalidate the refresh token and all access tokens based on the same authorization grant. If the token_type_hint is not defined, finAPI will revoke all access and refresh tokens (if applicable) that are based on the same authorization grant.&lt;br/&gt;&lt;br/&gt;Note that the service responds with HTTP status code 200 both if the token has been revoked successfully, and if the client submitted an invalid token.&lt;br/&gt;&lt;br/&gt;Note also that the client&#39;s access_token is required to authenticate the revocation.&lt;br/&gt;&lt;br/&gt;Here is an example of how to revoke a user&#39;s refresh_token (and therefore also his access tokens):&lt;pre&gt;Authorization: Bearer {client_access_token} POST /oauth/revoke?token&#x3D;{refresh_token}&amp;token_type_hint&#x3D;refresh_token&lt;/pre&gt;
     * @param token The token that the client wants to get revoked (required)
     * @param tokenTypeHint A hint about the type of the token submitted for revocation (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void revokeToken(String token, String tokenTypeHint) throws ApiException {
        revokeTokenWithHttpInfo(token, tokenTypeHint);
    }

    /**
     * Revoke a token
     * An additional endpoint for the OAuth 2.0 Standard, which allows clients to notify finAPI that a previously obtained refresh_token or access_token is no longer required. A successful request will invalidate the given token. The revocation of a particular token may also cause the revocation of related tokens and the underlying authorization grant. For token_type_hint&#x3D;access_token finAPI will invalidate only the given access_token. For token_type_hint&#x3D;refresh_token, finAPI will invalidate the refresh token and all access tokens based on the same authorization grant. If the token_type_hint is not defined, finAPI will revoke all access and refresh tokens (if applicable) that are based on the same authorization grant.&lt;br/&gt;&lt;br/&gt;Note that the service responds with HTTP status code 200 both if the token has been revoked successfully, and if the client submitted an invalid token.&lt;br/&gt;&lt;br/&gt;Note also that the client&#39;s access_token is required to authenticate the revocation.&lt;br/&gt;&lt;br/&gt;Here is an example of how to revoke a user&#39;s refresh_token (and therefore also his access tokens):&lt;pre&gt;Authorization: Bearer {client_access_token} POST /oauth/revoke?token&#x3D;{refresh_token}&amp;token_type_hint&#x3D;refresh_token&lt;/pre&gt;
     * @param token The token that the client wants to get revoked (required)
     * @param tokenTypeHint A hint about the type of the token submitted for revocation (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> revokeTokenWithHttpInfo(String token, String tokenTypeHint) throws ApiException {
        com.squareup.okhttp.Call call = revokeTokenValidateBeforeCall(token, tokenTypeHint, null, null);
        return apiClient.execute(call);
    }

    /**
     * Revoke a token (asynchronously)
     * An additional endpoint for the OAuth 2.0 Standard, which allows clients to notify finAPI that a previously obtained refresh_token or access_token is no longer required. A successful request will invalidate the given token. The revocation of a particular token may also cause the revocation of related tokens and the underlying authorization grant. For token_type_hint&#x3D;access_token finAPI will invalidate only the given access_token. For token_type_hint&#x3D;refresh_token, finAPI will invalidate the refresh token and all access tokens based on the same authorization grant. If the token_type_hint is not defined, finAPI will revoke all access and refresh tokens (if applicable) that are based on the same authorization grant.&lt;br/&gt;&lt;br/&gt;Note that the service responds with HTTP status code 200 both if the token has been revoked successfully, and if the client submitted an invalid token.&lt;br/&gt;&lt;br/&gt;Note also that the client&#39;s access_token is required to authenticate the revocation.&lt;br/&gt;&lt;br/&gt;Here is an example of how to revoke a user&#39;s refresh_token (and therefore also his access tokens):&lt;pre&gt;Authorization: Bearer {client_access_token} POST /oauth/revoke?token&#x3D;{refresh_token}&amp;token_type_hint&#x3D;refresh_token&lt;/pre&gt;
     * @param token The token that the client wants to get revoked (required)
     * @param tokenTypeHint A hint about the type of the token submitted for revocation (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call revokeTokenAsync(String token, String tokenTypeHint, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = revokeTokenValidateBeforeCall(token, tokenTypeHint, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
