/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.mbs.authserver.example;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import org.adorsys.cryptoutils.storeconnectionfactory.ExtendedStoreConnectionFactory;
import org.adorsys.cryptoutils.utils.ShowProperties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;

@SpringBootApplication(exclude={MongoAutoConfiguration.class})
@ComponentScan
public class AuthServerApplication {
    public static void main(String[] origargs) throws UnknownHostException {
        String[] args = ExtendedStoreConnectionFactory.readArguments((String[])origargs);
        Security.addProvider((Provider)new BouncyCastleProvider());
        SpringApplication app = new SpringApplication(new Class[]{AuthServerApplication.class});
        ConfigurableEnvironment env = app.run(args).getEnvironment();
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        ShowProperties.log();
        LoggerFactory.getLogger(AuthServerApplication.class).info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}\n\tExternal: \t{}://{}:{}\n\tProfile(s): \t{}\n----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), protocol, env.getProperty("server.port"), protocol, InetAddress.getLocalHost().getHostAddress(), env.getProperty("server.port"), env.getActiveProfiles()});
    }
}

