/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.mbs.authserver.example.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.lockpersistence.client.LockClient;
import de.adorsys.lockpersistence.client.NoopLockClient;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.persistence.FsKeyStoreRepository;
import de.adorsys.sts.persistence.FsResourceServerRepository;
import de.adorsys.sts.persistence.FsUserDataRepository;
import de.adorsys.sts.persistence.KeyEntryMapper;
import de.adorsys.sts.resourceserver.persistence.ResourceServerRepository;
import de.adorsys.sts.resourceserver.service.UserDataRepository;
import de.adorsys.sts.token.passwordgrant.EnablePasswordGrant;
import javax.annotation.PostConstruct;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.filesystem.FileSystemExtendedStorageConnection;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnablePasswordGrant
@EnableConfigurationProperties
public class AuthServerConfig {
    @Value(value="${docusafe.system.user.name}")
    String docusafeSystemUserName;
    @Value(value="${docusafe.system.user.password}")
    String docusafeSystemUserPassword;
    UserIDAuth systemId;
    private LockClient lockClient = new NoopLockClient();

    @PostConstruct
    void postConstruct() {
        this.systemId = new UserIDAuth(new UserID(this.docusafeSystemUserName), new ReadKeyPassword(this.docusafeSystemUserPassword));
    }

    @Bean
    DocumentSafeService documentSafeService() {
        FileSystemExtendedStorageConnection storageConnection = new FileSystemExtendedStorageConnection("target/authServer/" + RandomStringUtils.randomAlphanumeric((int)10).toUpperCase());
        DocumentSafeServiceImpl documentSafeService = new DocumentSafeServiceImpl((ExtendedStoreConnection)storageConnection);
        if (!documentSafeService.userExists(this.systemId.getUserID())) {
            documentSafeService.createUser(this.systemId);
        }
        return documentSafeService;
    }

    @Bean
    ResourceServerRepository resourceServerRepository(ObjectMapper objectMapper, DocumentSafeService documentSafeService) {
        return new FsResourceServerRepository(this.systemId, documentSafeService, objectMapper);
    }

    @Bean
    UserDataRepository userDataRepository(ObjectMapper objectMapper, DocumentSafeService documentSafeService) {
        return new FsUserDataRepository(documentSafeService, objectMapper);
    }

    @Bean
    KeyStoreRepository keyStoreRepository(ObjectMapper objectMapper, DocumentSafeService documentSafeService, KeyManagementProperties keyManagementProperties) {
        return new FsKeyStoreRepository(this.systemId, documentSafeService, keyManagementProperties, new KeyEntryMapper(objectMapper));
    }

    @Bean
    public LockClient getLockClient() {
        return this.lockClient;
    }
}

