/*
 * Decompiled with CFR 0.152.
 */
package de.adorysys.lockpersistence.mongo;

import de.adorsys.lockpersistence.model.Lock;
import de.adorsys.lockpersistence.service.LockPersistenceRepository;
import de.adorysys.lockpersistence.mongo.entity.LockEntity;
import de.adorysys.lockpersistence.mongo.mapper.LockEntityMapper;
import de.adorysys.lockpersistence.mongo.repository.MongoLockRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MongoLockPersistenceRepository
implements LockPersistenceRepository {
    private final MongoLockRepository repository;
    private final LockEntityMapper entityMapper;

    @Autowired
    public MongoLockPersistenceRepository(MongoLockRepository repository, LockEntityMapper entityMapper) {
        this.repository = repository;
        this.entityMapper = entityMapper;
    }

    public Iterable<Lock> getAll() {
        List allFound = this.repository.findAll();
        return this.entityMapper.mapFromEntities(allFound);
    }

    public Optional<Lock> get(String name) {
        LockEntity foundLock = this.repository.findByName(name);
        if (foundLock == null) {
            return Optional.empty();
        }
        return Optional.of(this.entityMapper.mapFromEntity(foundLock));
    }

    public void create(Lock lock) {
        this.repository.save(this.entityMapper.mapToEntity(lock));
    }

    public void delete(String name) {
        this.repository.deleteByName(name);
    }

    public void update(Lock lock) {
        LockEntity foundLock = this.repository.findByNameAndValue(lock.getName(), lock.getValue());
        foundLock.setExpires(lock.getExpires());
        this.repository.save(foundLock);
    }
}

