package de.adorsys.lockpersistence.model;

import java.util.Date;

public class Lock implements Comparable<Lock> {

	/**
	 * The name of the lock.
	 */
	private String name;
	/**
	 * The value of the lock (globally unique, or at least different for locks with the
	 * same name and different expiry).
	 */
	private String value;

	/**
	 * The expiry of the lock expressed as a point in time.
	 */
	private Date expires;

	public Lock() {
	}

	public Lock(String name, String value, Date expires) {
		this.name = name;
		this.value = value;
		this.expires = expires;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Date getExpires() {
		return expires;
	}

	public void setExpires(Date expires) {
		this.expires = expires;
	}

	public boolean isExpired() {
		return expires.before(new Date());
	}

	@Override
	public int compareTo(Lock other) {
		return expires.compareTo(other.expires);
	}

	@Override
	public String toString() {
		return "Lock [name=" + name + ", value=" + value + "]";
	}

}