/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PurposeCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.psd2.core.payment.model.AccountReference;
import de.adorsys.psd2.core.payment.model.Address;
import de.adorsys.psd2.core.payment.model.Amount;
import de.adorsys.psd2.core.payment.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.ExecutionRule;
import de.adorsys.psd2.core.payment.model.FrequencyCode;
import de.adorsys.psd2.core.payment.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.core.payment.model.PaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.core.payment.model.RemittanceInformationStructured;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Currency;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LedgersSpiPaymentToMapper {
    private static final Logger log = LoggerFactory.getLogger(LedgersSpiPaymentToMapper.class);
    @Autowired
    protected ObjectMapper objectMapper;

    public PaymentTO toPaymentTO_Single(SpiPaymentInfo spiPaymentInfo) {
        return Optional.ofNullable(spiPaymentInfo.getPaymentData()).filter(ArrayUtils::isNotEmpty).map(paymentData -> this.convert((byte[])paymentData, (Class)PaymentInitiationJson.class)).map(payment -> {
            PaymentTO paymentTO = new PaymentTO();
            paymentTO.setPaymentId(spiPaymentInfo.getPaymentId());
            paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)spiPaymentInfo.getPaymentType().name()));
            paymentTO.setPaymentProduct(spiPaymentInfo.getPaymentProduct());
            paymentTO.setDebtorAccount(this.mapToAccountReferenceTO(payment.getDebtorAccount()));
            paymentTO.setDebtorName(payment.getUltimateDebtor());
            paymentTO.setTargets(Collections.singletonList(this.mapToPaymentTargetTO((PaymentInitiationJson)payment, spiPaymentInfo)));
            return paymentTO;
        }).orElse(null);
    }

    public PaymentTO toPaymentTO_Bulk(SpiPaymentInfo spiPaymentInfo) {
        return Optional.ofNullable(spiPaymentInfo.getPaymentData()).filter(ArrayUtils::isNotEmpty).map(paymentData -> this.convert((byte[])paymentData, (Class)BulkPaymentInitiationJson.class)).map(payment -> {
            PaymentTO paymentTO = new PaymentTO();
            paymentTO.setPaymentId(spiPaymentInfo.getPaymentId());
            paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)spiPaymentInfo.getPaymentType().name()));
            paymentTO.setPaymentProduct(spiPaymentInfo.getPaymentProduct());
            paymentTO.setDebtorAccount(this.mapToAccountReferenceTO(payment.getDebtorAccount()));
            paymentTO.setBatchBookingPreferred(payment.getBatchBookingPreferred());
            paymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
            paymentTO.setRequestedExecutionTime((LocalTime)Optional.ofNullable(payment.getRequestedExecutionTime()).map(OffsetDateTime::toLocalTime).orElse(null));
            paymentTO.setTargets(payment.getPayments().stream().map(bulk -> this.mapToPaymentTargetTO((PaymentInitiationBulkElementJson)bulk, spiPaymentInfo)).collect(Collectors.toList()));
            return paymentTO;
        }).orElse(null);
    }

    public PaymentTO toPaymentTO_Periodic(SpiPaymentInfo spiPaymentInfo) {
        return Optional.ofNullable(spiPaymentInfo.getPaymentData()).filter(ArrayUtils::isNotEmpty).map(paymentData -> this.convert((byte[])paymentData, (Class)PeriodicPaymentInitiationJson.class)).map(payment -> {
            PaymentTO paymentTO = new PaymentTO();
            paymentTO.setPaymentId(spiPaymentInfo.getPaymentId());
            paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)spiPaymentInfo.getPaymentType().name()));
            paymentTO.setPaymentProduct(spiPaymentInfo.getPaymentProduct());
            paymentTO.setDebtorAccount(this.mapToAccountReferenceTO(payment.getDebtorAccount()));
            paymentTO.setStartDate(payment.getStartDate());
            paymentTO.setEndDate(payment.getEndDate());
            paymentTO.setExecutionRule((String)Optional.ofNullable(payment.getExecutionRule()).map(ExecutionRule::toString).orElse(null));
            paymentTO.setFrequency(this.mapToFrequencyCodeTO(payment.getFrequency()));
            paymentTO.setDayOfExecution((Integer)Optional.ofNullable(payment.getDayOfExecution()).map(d -> Integer.valueOf(d.toString())).orElse(null));
            paymentTO.setDebtorName(payment.getUltimateDebtor());
            paymentTO.setTargets(Collections.singletonList(this.mapToPaymentTargetTO((PeriodicPaymentInitiationJson)payment, spiPaymentInfo)));
            return paymentTO;
        }).orElse(null);
    }

    private FrequencyCodeTO mapToFrequencyCodeTO(FrequencyCode frequencyCode) {
        return Optional.ofNullable(frequencyCode).map(Enum::name).map(FrequencyCodeTO::valueOf).orElse(null);
    }

    private <T> T convert(byte[] paymentData, Class<T> tClass) {
        try {
            return (T)this.objectMapper.readValue(paymentData, tClass);
        }
        catch (IOException e) {
            log.warn("Can't convert byte[] to Object {}", (Object)e.getMessage());
            return null;
        }
    }

    private AccountReferenceTO mapToAccountReferenceTO(AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(accountReference.getIban());
        accountReferenceTO.setBban(accountReference.getBban());
        accountReferenceTO.setPan(accountReference.getPan());
        accountReferenceTO.setMaskedPan(accountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(accountReference.getMsisdn());
        accountReferenceTO.setCurrency(this.mapToCurrency(accountReference.getCurrency()));
        return accountReferenceTO;
    }

    private PaymentTargetTO mapToPaymentTargetTO(PeriodicPaymentInitiationJson payment, SpiPaymentInfo spiPaymentInfo) {
        if (payment == null) {
            return null;
        }
        PaymentTargetTO paymentTargetTO = new PaymentTargetTO();
        paymentTargetTO.setPaymentId(spiPaymentInfo.getPaymentId());
        paymentTargetTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        paymentTargetTO.setInstructedAmount(this.mapToAmountTO(payment.getInstructedAmount()));
        paymentTargetTO.setCreditorAccount(this.mapToAccountReferenceTO(payment.getCreditorAccount()));
        paymentTargetTO.setCreditorAgent(payment.getCreditorAgent());
        paymentTargetTO.setCreditorName(payment.getCreditorName());
        paymentTargetTO.setCreditorAddress(this.mapToAddressTO(payment.getCreditorAddress()));
        paymentTargetTO.setPurposeCode(this.mapToPurposeCodeTO(payment.getPurposeCode()));
        paymentTargetTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        paymentTargetTO.setRemittanceInformationStructured(this.mapToRemittanceInformationStructuredTO(payment.getRemittanceInformationStructured()));
        return paymentTargetTO;
    }

    private PaymentTargetTO mapToPaymentTargetTO(PaymentInitiationBulkElementJson payment, SpiPaymentInfo spiPaymentInfo) {
        if (payment == null) {
            return null;
        }
        PaymentTargetTO paymentTargetTO = new PaymentTargetTO();
        paymentTargetTO.setPaymentId(spiPaymentInfo.getPaymentId());
        paymentTargetTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        paymentTargetTO.setInstructedAmount(this.mapToAmountTO(payment.getInstructedAmount()));
        paymentTargetTO.setCreditorAccount(this.mapToAccountReferenceTO(payment.getCreditorAccount()));
        paymentTargetTO.setCreditorAgent(payment.getCreditorAgent());
        paymentTargetTO.setCreditorName(payment.getCreditorName());
        paymentTargetTO.setCreditorAddress(this.mapToAddressTO(payment.getCreditorAddress()));
        paymentTargetTO.setPurposeCode(this.mapToPurposeCodeTO(payment.getPurposeCode()));
        paymentTargetTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        paymentTargetTO.setRemittanceInformationStructured(this.mapToRemittanceInformationStructuredTO(payment.getRemittanceInformationStructured()));
        return paymentTargetTO;
    }

    private PaymentTargetTO mapToPaymentTargetTO(PaymentInitiationJson payment, SpiPaymentInfo spiPaymentInfo) {
        if (payment == null) {
            return null;
        }
        PaymentTargetTO paymentTargetTO = new PaymentTargetTO();
        paymentTargetTO.setPaymentId(spiPaymentInfo.getPaymentId());
        paymentTargetTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        paymentTargetTO.setInstructedAmount(this.mapToAmountTO(payment.getInstructedAmount()));
        paymentTargetTO.setCreditorAccount(this.mapToAccountReferenceTO(payment.getCreditorAccount()));
        paymentTargetTO.setCreditorAgent(payment.getCreditorAgent());
        paymentTargetTO.setCreditorName(payment.getCreditorName());
        paymentTargetTO.setCreditorAddress(this.mapToAddressTO(payment.getCreditorAddress()));
        paymentTargetTO.setPurposeCode(this.mapToPurposeCodeTO(payment.getPurposeCode()));
        paymentTargetTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        paymentTargetTO.setRemittanceInformationStructured(this.mapToRemittanceInformationStructuredTO(payment.getRemittanceInformationStructured()));
        return paymentTargetTO;
    }

    protected RemittanceInformationStructuredTO mapToRemittanceInformationStructuredTO(RemittanceInformationStructured remittanceInformationStructured) {
        if (remittanceInformationStructured == null) {
            return null;
        }
        RemittanceInformationStructuredTO remittanceInformationStructuredTO = new RemittanceInformationStructuredTO();
        remittanceInformationStructuredTO.setReference(remittanceInformationStructured.getReference());
        remittanceInformationStructuredTO.setReferenceType(remittanceInformationStructured.getReferenceType());
        remittanceInformationStructuredTO.setReferenceIssuer(remittanceInformationStructured.getReferenceIssuer());
        return remittanceInformationStructuredTO;
    }

    private PurposeCodeTO mapToPurposeCodeTO(PurposeCode purposeCode) {
        return Optional.ofNullable(purposeCode).map(Enum::name).map(PurposeCodeTO::valueOf).orElse(null);
    }

    private AmountTO mapToAmountTO(Amount amount) {
        if (amount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(this.mapToCurrency(amount.getCurrency()));
        amountTO.setAmount(BigDecimal.valueOf(Double.parseDouble(amount.getAmount())));
        return amountTO;
    }

    private AddressTO mapToAddressTO(Address address) {
        if (address == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(address.getStreetName());
        addressTO.setBuildingNumber(address.getBuildingNumber());
        addressTO.setCity(address.getTownName());
        addressTO.setPostalCode(address.getPostCode());
        addressTO.setCountry(address.getCountry());
        return addressTO;
    }

    private Currency mapToCurrency(String currency) {
        return Optional.ofNullable(currency).map(Currency::getInstance).orElse(null);
    }
}

