/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.AbstractAuthorisationSpi;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.GeneralPaymentService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentCancellationSpiImpl
extends AbstractAuthorisationSpi<SpiPayment>
implements PaymentCancellationSpi {
    private static final String ATTEMPT_FAILURE = "SCA_VALIDATION_ATTEMPT_FAILED";
    private static final Logger logger = LoggerFactory.getLogger(PaymentCancellationSpiImpl.class);
    private final PaymentRestClient paymentRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final RedirectScaRestClient redirectScaRestClient;
    private final ScaResponseMapper scaResponseMapper;
    private final GeneralPaymentService paymentService;

    public PaymentCancellationSpiImpl(PaymentRestClient ledgersRestClient, ScaMethodConverter scaMethodConverter, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, FeignExceptionReader feignExceptionReader, RedirectScaRestClient redirectScaRestClient, KeycloakTokenService keycloakTokenService, GeneralPaymentService paymentService, ScaResponseMapper scaResponseMapper) {
        super(authRequestInterceptor, consentDataService, authorisationService, scaMethodConverter, feignExceptionReader, keycloakTokenService, redirectScaRestClient);
        this.paymentRestClient = ledgersRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.redirectScaRestClient = redirectScaRestClient;
        this.paymentService = paymentService;
        this.scaResponseMapper = scaResponseMapper;
    }

    @NotNull
    public SpiResponse<SpiPaymentCancellationResponse> initiatePaymentCancellation(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SpiPaymentCancellationResponse response = new SpiPaymentCancellationResponse();
        boolean cancellationMandated = payment.getPaymentStatus() != TransactionStatus.RCVD;
        response.setCancellationAuthorisationMandated(cancellationMandated);
        response.setTransactionStatus(payment.getPaymentStatus());
        return SpiResponse.builder().payload((Object)response).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> cancelPaymentWithoutSca(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (payment.getPaymentStatus() == TransactionStatus.RCVD) {
            return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
        }
        GlobalScaResponseTO sca = this.getScaObjectResponse(aspspConsentDataProvider, true);
        if (sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            try {
                this.paymentRestClient.initiatePmtCancellation(payment.getPaymentId());
                return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                logger.error("Cancel payment without SCA failed: payment ID: {}, devMessage: {}", (Object)payment.getPaymentId(), (Object)devMessage);
                return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR_CANCELLATION, devMessage)).build();
            }
        }
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.CANCELLATION_INVALID, new Object[0])).build();
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndCancelPaymentWithResponse(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizeCancelPaymentResponse = this.redirectScaRestClient.validateScaCode(sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            if (authorizeCancelPaymentResponse.getStatusCode() == HttpStatus.OK) {
                String authCancellationBearerToken = ((GlobalScaResponseTO)authorizeCancelPaymentResponse.getBody()).getBearerToken().getAccess_token();
                this.authRequestInterceptor.setAccessToken(authCancellationBearerToken);
                this.paymentRestClient.executeCancelPayment(sca.getOperationObjectId());
                aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((GlobalScaResponseTO)authorizeCancelPaymentResponse.getBody()));
                this.authRequestInterceptor.setAccessToken(authCancellationBearerToken);
                return SpiResponse.builder().payload((Object)new SpiPaymentExecutionResponse(SpiAuthorisationStatus.SUCCESS)).build();
            }
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED_CANCELLATION, new Object[0])).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Verify SCA authorisation and cancel payment failed: payment ID: {}, devMessage: {}", (Object)payment.getPaymentId(), (Object)devMessage);
            String errorCode = this.feignExceptionReader.getErrorCode(feignException);
            if (errorCode.equals(ATTEMPT_FAILURE)) {
                return SpiResponse.builder().payload((Object)new SpiPaymentExecutionResponse(SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            }
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, new Object[0])).build();
        }
    }

    @Override
    protected String getBusinessObjectId(SpiPayment businessObject) {
        return businessObject.getPaymentId();
    }

    @Override
    protected OpTypeTO getOpType() {
        return OpTypeTO.CANCEL_PAYMENT;
    }

    @Override
    protected TppMessage getAuthorisePsuFailureMessage(SpiPayment businessObject) {
        logger.error("Authorising payment cancellation failed, payment ID: {}", (Object)businessObject.getPaymentId());
        return new TppMessage(MessageErrorCode.PAYMENT_FAILED, new Object[0]);
    }

    @Override
    protected GlobalScaResponseTO initiateBusinessObject(SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, String authorisationId) {
        return this.paymentService.initiatePaymentCancellationInLedgers(businessObject.getPaymentId());
    }

    @Override
    protected boolean validateStatuses(SpiPayment businessObject, GlobalScaResponseTO sca) {
        return businessObject.getPaymentStatus() == TransactionStatus.RCVD || sca.getScaStatus() == ScaStatusTO.EXEMPTED;
    }

    @Override
    protected boolean isFirstInitiationOfMultilevelSca(SpiPayment businessObject, GlobalScaResponseTO scaPaymentResponseTO) {
        return true;
    }

    @Override
    protected GlobalScaResponseTO executeBusinessObject(SpiPayment businessObject) {
        return this.scaResponseMapper.toGlobalScaResponse((SCAPaymentResponseTO)this.paymentRestClient.executeCancelPayment(businessObject.getPaymentId()).getBody());
    }

    @Override
    protected Optional<List<ScaUserDataTO>> getScaMethods(GlobalScaResponseTO sca) {
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        ResponseEntity cancelScaResponse = this.redirectScaRestClient.getSCA(sca.getAuthorisationId());
        return Optional.ofNullable(((GlobalScaResponseTO)cancelScaResponse.getBody()).getScaMethods());
    }

    @NotNull
    public SpiResponse<Boolean> requestTrustedBeneficiaryFlag(@NotNull SpiContextData spiContextData, @NotNull SpiPayment payment, @NotNull String authorisationId, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        logger.info("Retrieving mock trusted beneficiaries flag for payment cancellation: {}", (Object)payment);
        return SpiResponse.builder().payload((Object)true).build();
    }
}

