/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ChallengeDataMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import feign.FeignException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class GeneralAuthorisationService {
    private static final String ATTEMPT_FAILURE = "PSU_AUTH_ATTEMPT_INVALID";
    private static final Logger logger = LoggerFactory.getLogger(GeneralAuthorisationService.class);
    private final AuthRequestInterceptor authRequestInterceptor;
    private final ChallengeDataMapper challengeDataMapper;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final RedirectScaRestClient redirectScaRestClient;
    private final ScaMethodConverter scaMethodConverter;

    public SpiResponse<SpiPsuAuthorisationResponse> authorisePsuInternal(String businessObjectId, String authorisationId, OpTypeTO operationType, GlobalScaResponseTO scaResponse, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(scaResponse));
        this.authRequestInterceptor.setAccessToken(scaResponse.getBearerToken().getAccess_token());
        StartScaOprTO startScaOprTO = new StartScaOprTO(businessObjectId, operationType);
        startScaOprTO.setAuthorisationId(authorisationId);
        ResponseEntity startScaResponse = this.redirectScaRestClient.startSca(startScaOprTO);
        GlobalScaResponseTO startScaResponseBody = (GlobalScaResponseTO)startScaResponse.getBody();
        startScaResponseBody.setBearerToken(scaResponse.getBearerToken());
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(startScaResponseBody));
        try {
            SpiAuthorisationStatus status = ((GlobalScaResponseTO)startScaResponse.getBody()).getBearerToken().getAccess_token() != null ? SpiAuthorisationStatus.SUCCESS : SpiAuthorisationStatus.FAILURE;
            logger.info("Authorisation status is: {}", (Object)status);
            SpiResponse response = SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, status)).build();
            if (!response.isSuccessful()) {
                SpiPsuAuthorisationResponse spiResponse = (SpiPsuAuthorisationResponse)response.getPayload();
                if (spiResponse != null && spiResponse.getSpiAuthorisationStatus() == SpiAuthorisationStatus.ATTEMPT_FAILURE) {
                    return response;
                }
                return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(((SpiPsuAuthorisationResponse)response.getPayload()).isScaExempted(), SpiAuthorisationStatus.FAILURE)).build();
            }
            return response;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Authorise PSU internal failed: authorisation ID {}, business object ID: {}, devMessage: {}", new Object[]{authorisationId, businessObjectId, devMessage});
            String errorCode = this.feignExceptionReader.getErrorCode(feignException);
            if (errorCode.equals(ATTEMPT_FAILURE)) {
                return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            }
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
        }
    }

    public SpiResponse<SpiAuthorizationCodeResult> getResponseIfScaSelected(SpiAspspConsentDataProvider aspspConsentDataProvider, GlobalScaResponseTO sca, String authenticationMethodId) {
        if (ScaStatusTO.SCAMETHODSELECTED.equals((Object)sca.getScaStatus())) {
            return this.returnScaMethodSelection(aspspConsentDataProvider, sca, authenticationMethodId);
        }
        Object[] messageTextArgs = new Object[]{ScaStatusTO.SCAMETHODSELECTED.toString(), ScaStatusTO.PSUIDENTIFIED.toString(), sca.getScaStatus().toString()};
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_INVALID, messageTextArgs)).build();
    }

    public SpiResponse<SpiAuthorizationCodeResult> returnScaMethodSelection(SpiAspspConsentDataProvider aspspConsentDataProvider, GlobalScaResponseTO sca, String authenticationMethodId) {
        SpiAuthorizationCodeResult spiAuthorizationCodeResult = new SpiAuthorizationCodeResult();
        ChallengeData challengeData = Optional.ofNullable(this.challengeDataMapper.toChallengeData(sca.getChallengeData())).orElse(new ChallengeData());
        spiAuthorizationCodeResult.setChallengeData(challengeData);
        Optional<ScaUserDataTO> scaUserDataOptional = sca.getScaMethods().stream().filter(method -> method.getId().equals(authenticationMethodId)).findFirst();
        if (scaUserDataOptional.isPresent()) {
            spiAuthorizationCodeResult.setSelectedScaMethod(this.scaMethodConverter.toAuthenticationObject(scaUserDataOptional.get()));
        }
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(sca));
        return SpiResponse.builder().payload((Object)spiAuthorizationCodeResult).build();
    }

    public GeneralAuthorisationService(AuthRequestInterceptor authRequestInterceptor, ChallengeDataMapper challengeDataMapper, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, RedirectScaRestClient redirectScaRestClient, ScaMethodConverter scaMethodConverter) {
        this.authRequestInterceptor = authRequestInterceptor;
        this.challengeDataMapper = challengeDataMapper;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.redirectScaRestClient = redirectScaRestClient;
        this.scaMethodConverter = scaMethodConverter;
    }
}

