/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.account.IbanAccountReference;
import de.adorsys.aspsp.xs2a.connector.account.OwnerNameService;
import de.adorsys.aspsp.xs2a.connector.mock.IbanResolverMockService;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.FrequencyCode;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiStandingOrderDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionLinks;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReportParameters;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import feign.FeignException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:mock-data.properties"})
public class AccountSpiImpl
implements AccountSpi {
    private static final Logger log = LoggerFactory.getLogger(AccountSpiImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(AccountSpiImpl.class);
    private static final String RESPONSE_STATUS_200_WITH_EMPTY_BODY = "Response status was 200, but the body was empty!";
    private static final String DEFAULT_ACCEPT_MEDIA_TYPE = "application/json";
    private static final String WILDCARD_ACCEPT_HEADER = "*/*";
    private final AccountRestClient accountRestClient;
    private final LedgersSpiAccountMapper accountMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final IbanResolverMockService ibanResolverMockService;
    private final OwnerNameService ownerNameService;
    @Value(value="${test-download-transaction-list}")
    private String transactionList;

    public AccountSpiImpl(AccountRestClient restClient, LedgersSpiAccountMapper accountMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, IbanResolverMockService ibanResolverMockService, OwnerNameService ownerNameService) {
        this.accountRestClient = restClient;
        this.accountMapper = accountMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.ibanResolverMockService = ibanResolverMockService;
        this.ownerNameService = ownerNameService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<List<SpiAccountDetails>> requestAccountList(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            GlobalScaResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested account list for consent with ID: {} and withBalance: {}", (Object)accountConsent.getId(), (Object)withBalance);
            List<SpiAccountDetails> accountDetailsList = this.getSpiAccountDetails(withBalance, accountConsent);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response));
            List<SpiAccountDetails> accountDetailsListWithOwnerName = accountDetailsList.stream().map(accountDetail -> this.enrichWithOwnerName((SpiAccountDetails)accountDetail, accountConsent.getAccess())).collect(Collectors.toList());
            List<SpiAccountDetails> payload = this.filterAccountDetailsByWithBalance(withBalance, accountDetailsListWithOwnerName, accountConsent.getAccess());
            SpiResponse spiResponse = SpiResponse.builder().payload(payload).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request account list failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public SpiResponse<List<SpiTrustedBeneficiaries>> requestTrustedBeneficiariesList(@NotNull SpiContextData spiContextData, SpiAccountReference accountReference, @NotNull SpiAccountConsent spiAccountConsent, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        logger.info("Retrieving mock trusted beneficiaries list for consent: {}", (Object)spiAccountConsent);
        SpiTrustedBeneficiaries trustedBeneficiaries = new SpiTrustedBeneficiaries("mocked trusted beneficiaries id", new SpiAccountReference(null, "mocked debtor iban", null, null, null, null, null), new SpiAccountReference(null, "mocked creditor iban", null, null, null, null, null), "mocked creditor agent", "mocked creditor name", "mocked creditor alias", "mocked creditor id", new SpiAddress("mocked street name", "mocked building number", "mocked town name", "mocked post code", "mocked country"));
        return SpiResponse.builder().payload(Collections.singletonList(trustedBeneficiaries)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiAccountDetails> requestAccountDetailForAccount(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            GlobalScaResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested details for account, ACCOUNT-ID: {}, withBalance: {}", (Object)accountReference.getResourceId(), (Object)withBalance);
            SpiAccountDetails accountDetails = Optional.ofNullable((AccountDetailsTO)this.accountRestClient.getAccountDetailsById(accountReference.getResourceId()).getBody()).map(this.accountMapper::toSpiAccountDetails).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            SpiAccountDetails accountDetailsWithOwnerName = this.enrichWithOwnerName(accountDetails, accountConsent.getAccess());
            if (!withBalance) {
                accountDetailsWithOwnerName.emptyBalances();
            }
            logger.info("The responded account RESOURCE-ID: {}", (Object)accountDetailsWithOwnerName.getResourceId());
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)accountDetailsWithOwnerName).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request account details for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiTransactionReport> requestTransactionsForAccount(@NotNull SpiContextData contextData, @NotNull SpiTransactionReportParameters spiTransactionReportParameters, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (BookingStatus.INFORMATION == spiTransactionReportParameters.getBookingStatus()) {
            logger.info("Retrieving mock standing order report for account: {}", (Object)accountReference.getResourceId());
            SpiTransactionLinks spiTransactionLinks = this.buildSpiTransactionLinks();
            SpiTransactionReport transactionReport = new SpiTransactionReport(null, this.createStandingOrderReportMock(), null, this.processAcceptMediaType(spiTransactionReportParameters.getAcceptMediaType()), null, spiTransactionLinks);
            return SpiResponse.builder().payload((Object)transactionReport).build();
        }
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        LocalDate dateFrom = Optional.ofNullable(spiTransactionReportParameters.getDateFrom()).orElse(LocalDate.now().minusMonths(6L));
        LocalDate dateTo = Optional.ofNullable(spiTransactionReportParameters.getDateTo()).orElse(LocalDate.now());
        boolean withBalance = spiTransactionReportParameters.isWithBalance();
        String acceptMediaType = spiTransactionReportParameters.getAcceptMediaType();
        String entryReferenceFrom = spiTransactionReportParameters.getEntryReferenceFrom();
        Boolean deltaList = spiTransactionReportParameters.getDeltaList();
        try {
            GlobalScaResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested transactions for account: {}, dates from: {}, to: {}, withBalance: {}, entryReferenceFrom: {}, deltaList: {}", new Object[]{accountReference.getResourceId(), dateFrom, dateTo, withBalance, entryReferenceFrom, deltaList});
            List transactions = Optional.ofNullable((List)this.accountRestClient.getTransactionByDates(accountReference.getResourceId(), dateFrom, dateTo).getBody()).map(this.accountMapper::toSpiTransactions).orElseGet(ArrayList::new);
            List<SpiAccountBalance> balances = this.getSpiAccountBalances(contextData, withBalance, accountReference, accountConsent, aspspConsentDataProvider);
            SpiTransactionLinks spiTransactionLinks = this.buildSpiTransactionLinks();
            SpiTransactionReport transactionReport = new SpiTransactionReport("downloadId", transactions, balances, this.processAcceptMediaType(acceptMediaType), null, spiTransactionLinks);
            logger.info("Finally found {} transactions.", (Object)transactionReport.getTransactions().size());
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transactionReport).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    String processAcceptMediaType(String acceptMediaType) {
        return StringUtils.isBlank((CharSequence)acceptMediaType) || WILDCARD_ACCEPT_HEADER.equals(acceptMediaType) || acceptMediaType.contains(",") ? DEFAULT_ACCEPT_MEDIA_TYPE : acceptMediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiTransaction> requestTransactionForAccountByTransactionId(@NotNull SpiContextData contextData, @NotNull String transactionId, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            GlobalScaResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested transaction with TRANSACTION-ID: {} for ACCOUNT-ID: {}", (Object)transactionId, (Object)accountReference.getResourceId());
            SpiTransaction transaction = Optional.ofNullable((TransactionTO)this.accountRestClient.getTransactionById(accountReference.getResourceId(), transactionId).getBody()).map(this.accountMapper::toSpiTransaction).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            logger.info("Found transaction with TRANSACTION-ID: {}", (Object)transaction.getTransactionId());
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transaction).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions for account by transaction id failed: consent ID {}, resource ID {}, transaction ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), transactionId, devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<List<SpiAccountBalance>> requestBalancesForAccount(@NotNull SpiContextData contextData, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            GlobalScaResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested Balances for ACCOUNT-ID: {}", (Object)accountReference.getResourceId());
            List accountBalances = Optional.ofNullable((List)this.accountRestClient.getBalances(accountReference.getResourceId()).getBody()).map(this.accountMapper::toSpiAccountBalancesList).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            logger.info("Found Balances: {}", (Object)accountBalances.size());
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)accountBalances).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request balances for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiTransactionsDownloadResponse> requestTransactionsByDownloadLink(@NotNull SpiContextData spiContextData, @NotNull SpiAccountConsent spiAccountConsent, @NotNull String downloadId, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            GlobalScaResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested downloading list of transactions by download ID: {}", (Object)downloadId);
            ByteArrayInputStream stream = new ByteArrayInputStream(this.transactionList.getBytes());
            SpiTransactionsDownloadResponse transactionsDownloadResponse = new SpiTransactionsDownloadResponse((InputStream)stream, "transactions.json", Integer.valueOf(this.transactionList.getBytes().length));
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transactionsDownloadResponse).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions by download link failed: consent ID {}, download link {}, devMessage {}", new Object[]{spiAccountConsent.getId(), downloadId, devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiAccountDetails> getSpiAccountDetails(boolean withBalance, @NotNull SpiAccountConsent accountConsent) {
        List<SpiAccountDetails> accountDetailsList;
        if (this.isGlobalConsent(accountConsent.getAccess()) || this.isAllAvailableAccountsConsent(accountConsent)) {
            logger.info("Consent with ID: {} is a global or available account Consent", (Object)accountConsent.getId());
            accountDetailsList = this.getAccountDetailsByConsentId();
        } else {
            logger.info("Consent with ID: {} is a regular consent", (Object)accountConsent.getId());
            accountDetailsList = this.getAccountDetailsFromReferences(withBalance, accountConsent);
        }
        return accountDetailsList;
    }

    private List<SpiAccountBalance> getSpiAccountBalances(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (withBalance) {
            SpiResponse<List<SpiAccountBalance>> response = this.requestBalancesForAccount(contextData, accountReference, accountConsent, aspspConsentDataProvider);
            if (response.isSuccessful()) {
                return (List)response.getPayload();
            }
            throw FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, "Requested transaction can`t be found");
        }
        return null;
    }

    private boolean isGlobalConsent(SpiAccountAccess accountAccess) {
        return accountAccess.getAllPsd2() != null;
    }

    private boolean isAllAvailableAccountsConsent(SpiAccountConsent accountConsent) {
        return accountConsent.getAisConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
    }

    private List<SpiAccountDetails> getAccountDetailsByConsentId() {
        return Optional.ofNullable((List)this.accountRestClient.getListOfAccounts().getBody()).map(l -> l.stream().map(this.accountMapper::toSpiAccountDetails).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(boolean withBalance, SpiAccountConsent accountConsent) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        List references = withBalance ? accountAccess.getBalances() : accountAccess.getAccounts();
        return this.getAccountDetailsFromReferences(references);
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(List<SpiAccountReference> references) {
        List accountDetails = (List)this.accountRestClient.getListOfAccounts().getBody();
        if (accountDetails == null) {
            return Collections.emptyList();
        }
        return accountDetails.stream().filter(account -> this.containsAccountReferenceWithIban(references, account.getIban(), account.getCurrency())).map(this.accountMapper::toSpiAccountDetails).collect(Collectors.toList());
    }

    private boolean containsAccountReferenceWithIban(List<SpiAccountReference> references, String iban, Currency currency) {
        return references.stream().filter(reference -> Optional.ofNullable(reference.getIban()).orElseGet(() -> this.ibanResolverMockService.handleIbanByAccountReference((SpiAccountReference)reference)).equals(iban)).anyMatch(reference -> reference.getCurrency() == null || reference.getCurrency().equals(currency));
    }

    private List<SpiAccountDetails> filterAccountDetailsByWithBalance(boolean withBalance, List<SpiAccountDetails> details, SpiAccountAccess spiAccountAccess) {
        if (withBalance && this.isConsentSupportedBalances(spiAccountAccess)) {
            return details;
        }
        for (SpiAccountDetails spiAccountDetails : details) {
            if (withBalance && this.isValidAccountByAccess(spiAccountDetails.getIban(), spiAccountAccess.getBalances())) continue;
            spiAccountDetails.emptyBalances();
        }
        return details;
    }

    private boolean isConsentSupportedBalances(SpiAccountAccess spiAccountAccess) {
        boolean isConsentGlobal = spiAccountAccess.getAllPsd2() != null;
        boolean isConsentForAvailableAccountsWithBalances = spiAccountAccess.getAvailableAccountsWithBalance() != null;
        return isConsentGlobal || isConsentForAvailableAccountsWithBalances;
    }

    private GlobalScaResponseTO applyAuthorisation(byte[] aspspConsentData) {
        GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentData);
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        return sca;
    }

    private boolean isValidAccountByAccess(String iban, List<SpiAccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> iban.equals(a.getIban()));
    }

    private TppMessage buildTppMessage(FeignException exception) {
        return FeignExceptionHandler.getFailureMessage(exception, MessageErrorCode.CONSENT_UNKNOWN_400, this.feignExceptionReader.getErrorMessage(exception));
    }

    private List<SpiTransaction> createStandingOrderReportMock() {
        SpiStandingOrderDetails standingOrderDetails = new SpiStandingOrderDetails(LocalDate.of(2021, Month.JANUARY, 4), LocalDate.of(2021, Month.MARCH, 12), PisExecutionRule.PRECEDING, null, FrequencyCode.MONTHLYVARIABLE, null, null, PisDayOfExecution._24, null);
        SpiAccountReference spiAccountReference = new SpiAccountReference("11111-11118", "10023-999999999", "DE52500105173911841934", "52500105173911841934", "AEYPM5403H", "PM5403H****", null, Currency.getInstance("EUR"));
        SpiAdditionalInformationStructured additionalInformationStructured = new SpiAdditionalInformationStructured(standingOrderDetails);
        return Collections.singletonList(new SpiTransaction(null, null, null, null, null, null, null, null, null, null, "John Miles", spiAccountReference, null, null, null, null, null, null, null, null, null, null, null, "PMNT-ICDT-STDO", null, null, additionalInformationStructured, this.buildSpiAccountBalance()));
    }

    private SpiAccountBalance buildSpiAccountBalance() {
        SpiAccountBalance accountBalance = new SpiAccountBalance();
        accountBalance.setSpiBalanceAmount(new SpiAmount(Currency.getInstance("EUR"), new BigDecimal(1000)));
        accountBalance.setSpiBalanceType(SpiBalanceType.INTERIM_AVAILABLE);
        accountBalance.setLastCommittedTransaction("abcd");
        accountBalance.setReferenceDate(LocalDate.of(2020, Month.JANUARY, 1));
        accountBalance.setLastChangeDateTime(LocalDateTime.of(2019, Month.FEBRUARY, 15, 10, 0, 0, 0));
        return accountBalance;
    }

    private SpiAccountDetails enrichWithOwnerName(SpiAccountDetails spiAccountDetails, SpiAccountAccess accountAccess) {
        IbanAccountReference ibanAccountReference = new IbanAccountReference(spiAccountDetails.getIban(), spiAccountDetails.getCurrency());
        if (this.ownerNameService.shouldContainOwnerName(ibanAccountReference, accountAccess)) {
            return this.ownerNameService.enrichAccountDetailsWithOwnerName(spiAccountDetails);
        }
        return spiAccountDetails;
    }

    private SpiTransactionLinks buildSpiTransactionLinks() {
        return new SpiTransactionLinks("http://localhost:8089/v1/accounts/account-id/transactions?pageIndex=0&itemsPerPage=20", "http://localhost:8089/v1/accounts/account-id/transactions?pageIndex=3&itemsPerPage=20", "http://localhost:8089/v1/accounts/account-id/transactions?pageIndex=1&itemsPerPage=20", "http://localhost:8089/v1/accounts/account-id/transactions?pageIndex=7&itemsPerPage=20");
    }
}

