/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentToMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.StandardPaymentProductsResolverConnector;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.client.mappers.PaymentMapperTO;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LedgersSpiCommonPaymentTOMapper {
    private static final Logger log = LoggerFactory.getLogger(LedgersSpiCommonPaymentTOMapper.class);
    private final StandardPaymentProductsResolverConnector standardPaymentProductsResolverConnector;
    private final LedgersSpiPaymentToMapper ledgersSpiPaymentToMapper;
    private final PaymentMapperTO paymentMapperTO;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public PaymentTO mapToPaymentTO(PaymentType paymentType, SpiPaymentInfo spiPaymentInfo) {
        if (this.standardPaymentProductsResolverConnector.isRawPaymentProduct(spiPaymentInfo.getPaymentProduct())) {
            PaymentTO paymentTO = this.paymentMapperTO.toAbstractPayment(new String(spiPaymentInfo.getPaymentData()), paymentType.name(), spiPaymentInfo.getPaymentProduct());
            paymentTO.setPaymentId(spiPaymentInfo.getPaymentId());
            if (PaymentType.PERIODIC == paymentType) {
                this.enrichPeriodicPaymentFields(paymentTO, spiPaymentInfo);
            }
            return paymentTO;
        }
        switch (paymentType) {
            case SINGLE: {
                return this.ledgersSpiPaymentToMapper.toPaymentTO_Single(spiPaymentInfo);
            }
            case BULK: {
                return this.ledgersSpiPaymentToMapper.toPaymentTO_Bulk(spiPaymentInfo);
            }
            case PERIODIC: {
                return this.ledgersSpiPaymentToMapper.toPaymentTO_Periodic(spiPaymentInfo);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown payment type: %s", paymentType.getValue()));
    }

    private PaymentTO enrichPeriodicPaymentFields(PaymentTO paymentTO, SpiPaymentInfo spiPaymentInfo) {
        String paymentData = new String(spiPaymentInfo.getPaymentData());
        try {
            String json = paymentData.substring(paymentData.indexOf("{"), paymentData.lastIndexOf("}") + 1);
            PeriodicPaymentInitiationXmlPart2StandingorderTypeJson periodicTypeJson = (PeriodicPaymentInitiationXmlPart2StandingorderTypeJson)this.xs2aObjectMapper.readValue(json, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson.class);
            paymentTO.setStartDate(periodicTypeJson.getStartDate());
            paymentTO.setEndDate(periodicTypeJson.getEndDate());
            paymentTO.setDayOfExecution((Integer)Optional.ofNullable(periodicTypeJson.getDayOfExecution()).map(d -> Integer.parseInt(d.toString())).orElse(null));
            paymentTO.setExecutionRule((String)Optional.ofNullable(periodicTypeJson.getExecutionRule()).map(ExecutionRule::toString).orElse(null));
            paymentTO.setFrequency((FrequencyCodeTO)Optional.ofNullable(periodicTypeJson.getFrequency()).map(f -> FrequencyCodeTO.valueOf((String)f.name())).orElse(null));
        }
        catch (Exception e) {
            log.debug("Wrong multipart/form-data content for raw periodic payment: {}", (Object)paymentData);
            throw new IllegalArgumentException("Wrong multipart/form-data content for raw periodic payment");
        }
        return paymentTO;
    }

    public LedgersSpiCommonPaymentTOMapper(StandardPaymentProductsResolverConnector standardPaymentProductsResolverConnector, LedgersSpiPaymentToMapper ledgersSpiPaymentToMapper, PaymentMapperTO paymentMapperTO, Xs2aObjectMapper xs2aObjectMapper) {
        this.standardPaymentProductsResolverConnector = standardPaymentProductsResolverConnector;
        this.ledgersSpiPaymentToMapper = ledgersSpiPaymentToMapper;
        this.paymentMapperTO = paymentMapperTO;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

