/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.mock.MockAccountData;
import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.BalanceTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountStatus;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiExchangeRate;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiUsageType;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.util.List;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public abstract class LedgersSpiAccountMapper {
    public SpiAccountDetails toSpiAccountDetails(AccountDetailsTO accountDetails) {
        return Optional.ofNullable(accountDetails).map(d -> new SpiAccountDetails(d.getIban(), d.getId(), d.getIban(), d.getBban(), d.getPan(), d.getMaskedPan(), d.getMsisdn(), d.getCurrency(), d.getName(), "mock display name", d.getProduct(), SpiAccountType.valueOf((String)d.getAccountType().name()), SpiAccountStatus.valueOf((String)d.getAccountStatus().name()), d.getBic(), d.getLinkedAccounts(), SpiUsageType.valueOf((String)d.getUsageType().name()), d.getDetails(), this.toSpiAccountBalancesList(d.getBalances()), null, null)).orElse(null);
    }

    public SpiCardAccountDetails toSpiCardAccountDetails(AccountDetailsTO accountDetails) {
        return Optional.ofNullable(accountDetails).map(d -> new SpiCardAccountDetails(d.getIban(), d.getId(), d.getMaskedPan(), d.getCurrency(), d.getName(), "mock display name", d.getProduct(), SpiAccountStatus.valueOf((String)d.getAccountStatus().name()), SpiAccountType.valueOf((String)d.getAccountType().name()), SpiUsageType.valueOf((String)d.getUsageType().name()), d.getDetails(), MockAccountData.CREDIT_LIMIT, this.toSpiAccountBalancesList(d.getBalances()), null)).orElse(null);
    }

    public abstract List<SpiTransaction> toSpiTransactions(List<TransactionTO> var1);

    public abstract List<SpiCardTransaction> toSpiCardTransactions(List<TransactionTO> var1);

    public SpiTransaction toSpiTransaction(TransactionTO transaction) {
        return Optional.ofNullable(transaction).map(t -> new SpiTransaction(t.getTransactionId(), t.getEntryReference(), t.getEndToEndId(), t.getMandateId(), t.getCheckId(), t.getCreditorId(), t.getBookingDate(), t.getValueDate(), this.toSpiAmount(t.getAmount()), this.toSpiExchangeRateList(t.getExchangeRate()), t.getCreditorName(), this.toSpiAccountReference(t.getCreditorAccount()), t.getCreditorAgent(), t.getUltimateCreditor(), t.getDebtorName(), this.toSpiAccountReference(t.getDebtorAccount()), t.getDebtorAgent(), t.getUltimateDebtor(), t.getRemittanceInformationUnstructured(), MockAccountData.REMITTANCE_UNSTRUCTURED_ARRAY, this.mapToRemittanceString(t.getRemittanceInformationStructured()), MockAccountData.REMITTANCE_STRUCTURED_ARRAY, t.getPurposeCode(), t.getBankTransactionCode(), t.getProprietaryBankTransactionCode(), "mock additional information", null, this.accountBalanceTOToSpiAccountBalance(t.getBalanceAfterTransaction()))).orElse(null);
    }

    public SpiCardTransaction toSpiCardTransaction(TransactionTO transaction) {
        return Optional.ofNullable(transaction).map(t -> new SpiCardTransaction(t.getTransactionId(), "terminalId", t.getValueDate(), MockAccountData.ACCEPTOR_TRANSACTION_DATE_TIME, t.getBookingDate(), this.toSpiAmount(t.getAmount()), this.toSpiExchangeRateList(t.getExchangeRate()), this.toSpiAmount(t.getAmount()), this.toSpiAmount(t.getAmount()), "markupFeePercentage", t.getCreditorId(), MockAccountData.CARD_ACCEPTOR_ADDRESS, "+61-(02)9999999999-9999", "merchantCategoryCode", "493702******0836", "transactionDetails", Boolean.valueOf(false), t.getProprietaryBankTransactionCode())).orElse(null);
    }

    public SpiAccountReference toSpiAccountReference(AccountReferenceTO reference) {
        return Optional.ofNullable(reference).map(r -> new SpiAccountReference(r.getIban(), r.getIban(), r.getIban(), r.getBban(), r.getPan(), r.getMaskedPan(), r.getMsisdn(), r.getCurrency(), null)).orElse(null);
    }

    public abstract List<SpiAccountBalance> toSpiAccountBalancesList(List<AccountBalanceTO> var1);

    @Mappings(value={@Mapping(target="spiBalanceType", expression="java(mapToSpiBalanceType(accountBalanceTO.getBalanceType()))"), @Mapping(source="amount", target="spiBalanceAmount")})
    public abstract SpiAccountBalance accountBalanceTOToSpiAccountBalance(AccountBalanceTO var1);

    public abstract List<SpiExchangeRate> toSpiExchangeRateList(List<ExchangeRateTO> var1);

    protected SpiBalanceType mapToSpiBalanceType(BalanceTypeTO balanceTypeTO) {
        return SpiBalanceType.valueOf((String)balanceTypeTO.name());
    }

    public SpiExchangeRate toSpiExchangeRate(ExchangeRateTO exchangeRate) {
        return Optional.ofNullable(exchangeRate).map(e -> new SpiExchangeRate(e.getCurrencyFrom().getCurrencyCode(), e.getRateFrom(), e.getCurrency().getCurrencyCode(), e.getRateTo(), e.getRateDate(), e.getRateContract())).orElse(null);
    }

    public SpiAmount toSpiAmount(AmountTO amount) {
        return Optional.ofNullable(amount).map(a -> new SpiAmount(a.getCurrency(), a.getAmount())).orElse(null);
    }

    public abstract FundsConfirmationRequestTO toFundsConfirmationTO(SpiPsuData var1, SpiFundsConfirmationRequest var2);

    public abstract AccountReferenceTO mapToAccountReferenceTO(SpiAccountReference var1);

    public String mapToRemittanceString(RemittanceInformationStructuredTO remittanceInformationStructuredTO) {
        return Optional.ofNullable(remittanceInformationStructuredTO).map(RemittanceInformationStructuredTO::getReference).orElse(null);
    }
}

