/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.payment;

import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LedgersErrorCode;
import de.adorsys.aspsp.xs2a.connector.spi.impl.MultilevelScaService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiGetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import feign.Response;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:mock-data.properties"})
public class GeneralPaymentService {
    private static final Logger logger = LoggerFactory.getLogger(GeneralPaymentService.class);
    private static final String XML_MEDIA_TYPE = "application/xml";
    private static final String PSU_MESSAGE = "Mocked PSU message from SPI for this payment";
    private static final String DEBTOR_NAME = "Mocked debtor name from ASPSP";
    private final PaymentRestClient paymentRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final String transactionStatusXmlBody;
    private final MultilevelScaService multilevelScaService;

    public GeneralPaymentService(PaymentRestClient ledgersRestClient, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, @Value(value="${test-transaction-status-xml-body}") String transactionStatusXmlBody, MultilevelScaService multilevelScaService) {
        this.paymentRestClient = ledgersRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.transactionStatusXmlBody = transactionStatusXmlBody;
        this.multilevelScaService = multilevelScaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiGetPaymentStatusResponse> getPaymentStatusById(@NotNull PaymentTypeTO paymentType, @NotNull String acceptMediaType, @NotNull String paymentId, @NotNull TransactionStatus spiTransactionStatus, @NotNull byte[] aspspConsentData) {
        if (acceptMediaType.equals(XML_MEDIA_TYPE)) {
            return SpiResponse.builder().payload((Object)new SpiGetPaymentStatusResponse(spiTransactionStatus, null, XML_MEDIA_TYPE, this.transactionStatusXmlBody.getBytes(), PSU_MESSAGE)).build();
        }
        if (!TransactionStatus.ACSP.equals((Object)spiTransactionStatus)) {
            return SpiResponse.builder().payload((Object)new SpiGetPaymentStatusResponse(spiTransactionStatus, null, "application/json", null, PSU_MESSAGE)).build();
        }
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Get payment status by ID with type: {} and ID: {}", (Object)paymentType, (Object)paymentId);
            TransactionStatusTO response = (TransactionStatusTO)this.paymentRestClient.getPaymentStatusById(sca.getPaymentId()).getBody();
            TransactionStatus status = Optional.ofNullable(response).map(r -> TransactionStatus.valueOf((String)r.name())).orElseThrow(() -> FeignException.errorStatus((String)"Request failed, response was 200, but body was empty!", (Response)Response.builder().status(HttpStatus.BAD_REQUEST.value()).build()));
            logger.info("Transaction status: {}", (Object)status);
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiGetPaymentStatusResponse(status, null, "application/json", null, PSU_MESSAGE)).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Get payment status by id failed: payment ID {}, devMessage {}", (Object)paymentId, (Object)devMessage);
            SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, devMessage, new Object[0])).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndExecutePaymentWithPaymentResponse(@NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizePaymentResponse = this.paymentRestClient.authorizePayment(sca.getPaymentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            SCAPaymentResponseTO consentResponse = (SCAPaymentResponseTO)authorizePaymentResponse.getBody();
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)consentResponse));
            String scaStatus = Optional.ofNullable(consentResponse).map(SCAResponseTO::getScaStatus).map(Enum::name).orElse(null);
            logger.info("SCA status is: {}", (Object)scaStatus);
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)this.spiPaymentExecutionResponse(consentResponse.getTransactionStatus())).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.info("Verify SCA authorisation and execute payment failed: payment ID {}, devMessage {}", (Object)spiScaConfirmation.getPaymentId(), (Object)devMessage);
            LedgersErrorCode errorCode = this.feignExceptionReader.getLedgersErrorCode(feignException);
            if (LedgersErrorCode.SCA_VALIDATION_ATTEMPT_FAILED.equals((Object)errorCode)) {
                SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiPaymentExecutionResponse(SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
                return spiResponse;
            }
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            return spiResponse;
        }
        catch (Exception exception) {
            SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_EXECUTED, new Object[0])).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public <T extends SpiPaymentInitiationResponse> SpiResponse<T> firstCallInstantiatingPayment(@NotNull PaymentTypeTO paymentType, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, T responsePayload, @NotNull SpiPsuData spiPsuData, Set<SpiAccountReference> spiAccountReferences) {
        boolean isMultilevelScaRequired;
        String paymentId = StringUtils.isNotBlank((CharSequence)payment.getPaymentId()) ? payment.getPaymentId() : Ids.id();
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setPaymentId(paymentId);
        response.setTransactionStatus(TransactionStatusTO.RCVD);
        response.setPaymentProduct(payment.getPaymentProduct());
        response.setPaymentType(paymentType);
        responsePayload.setPaymentId(paymentId);
        responsePayload.setTransactionStatus(TransactionStatus.valueOf((String)response.getTransactionStatus().name()));
        try {
            isMultilevelScaRequired = this.multilevelScaService.isMultilevelScaRequired(spiPsuData, spiAccountReferences);
        }
        catch (FeignException e) {
            logger.error("Error during REST call for payment initiation to ledgers for account multilevel checking, PSU ID: {}", (Object)spiPsuData.getPsuId());
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT, new Object[0])).build();
        }
        response.setMultilevelScaRequired(isMultilevelScaRequired);
        responsePayload.setMultilevelScaRequired(isMultilevelScaRequired);
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response, false));
        return SpiResponse.builder().payload(responsePayload).build();
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> executePaymentWithoutSca(@NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAPaymentResponseTO response = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAPaymentResponseTO.class);
            ScaStatusTO scaStatus = response.getScaStatus();
            String scaStatusName = scaStatus.name();
            if (ScaStatusTO.EXEMPTED.equals((Object)scaStatus) || ScaStatusTO.FINALISED.equals((Object)scaStatus)) {
                logger.info("SCA status is: {}", (Object)scaStatusName);
                logger.info("Payment scheduled for execution. Transaction status is: {}. Also see SCA status", (Object)response.getTransactionStatus());
                return SpiResponse.builder().payload((Object)this.spiPaymentExecutionResponse(response.getTransactionStatus())).build();
            }
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response));
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_EXECUTED, new Object[]{response.getTransactionStatus(), scaStatusName})).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Execute payment without SCA failed: devMessage {}", (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR, devMessage)).build();
        }
    }

    public <P extends SpiPayment> SpiResponse<P> getPaymentById(P payment, SpiAspspConsentDataProvider aspspConsentDataProvider, Function<PaymentTO, P> mapperToSpiPayment) {
        Function<SpiPayment, SpiResponse> buildSuccessResponse = p -> SpiResponse.builder().payload(p).build();
        if (!TransactionStatus.ACSP.equals((Object)payment.getPaymentStatus())) {
            return buildSuccessResponse.apply(payment);
        }
        Supplier<SpiResponse> buildFailedResponse = () -> SpiResponse.builder().error(new TppMessage(MessageErrorCode.PAYMENT_FAILED_INCORRECT_ID, new Object[0])).build();
        return this.getPaymentFromLedgers(payment, aspspConsentDataProvider.loadAspspConsentData()).map(p -> {
            p.setDebtorName(DEBTOR_NAME);
            return p;
        }).map(mapperToSpiPayment).map(buildSuccessResponse).orElseGet(buildFailedResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PaymentTO> getPaymentFromLedgers(SpiPayment payment, byte[] aspspConsentData) {
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Get payment by ID with type: {} and ID: {}", (Object)payment.getPaymentType(), (Object)payment.getPaymentId());
            logger.debug("Payment body: {}", (Object)payment);
            Optional<PaymentTO> optional = Optional.ofNullable((PaymentTO)this.paymentRestClient.getPaymentById(sca.getPaymentId()).getBody());
            return optional;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Get payment by id failed: payment ID {}, devMessage {}", (Object)payment.getPaymentId(), (Object)devMessage);
            Optional<PaymentTO> optional = Optional.empty();
            return optional;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> SCAPaymentResponseTO initiatePaymentInternal(P payment, byte[] initialAspspConsentData, PaymentTypeTO paymentTypeTO, PaymentTO request) {
        try {
            SCAPaymentResponseTO sca = this.getSCAPaymentResponseTO(initialAspspConsentData);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.debug("{} payment body: {}", (Object)paymentTypeTO, payment);
            SCAPaymentResponseTO sCAPaymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.initiatePayment(paymentTypeTO, request).getBody();
            return sCAPaymentResponseTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public SCAPaymentResponseTO getSCAPaymentResponseTO(byte[] initialAspspConsentData) {
        return this.consentDataService.response(initialAspspConsentData, SCAPaymentResponseTO.class);
    }

    private SpiPaymentExecutionResponse spiPaymentExecutionResponse(TransactionStatusTO transactionStatus) {
        return new SpiPaymentExecutionResponse(TransactionStatus.valueOf((String)transactionStatus.name()));
    }
}

