/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.mock.IbanResolverMockService;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAdditionalInformationAccess;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReportParameters;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CardAccountSpi;
import feign.FeignException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:mock-data.properties"})
public class CardAccountSpiImpl
implements CardAccountSpi {
    private static final String RESPONSE_STATUS_200_WITH_EMPTY_BODY = "Response status was 200, but the body was empty!";
    private static final Logger logger = LoggerFactory.getLogger(CardAccountSpiImpl.class);
    private static final String DEFAULT_ACCEPT_MEDIA_TYPE = "application/json";
    private static final String WILDCARD_ACCEPT_HEADER = "*/*";
    private static final String ADDITIONAL_INFORMATION_MOCK = "additional information";
    private final AccountRestClient accountRestClient;
    private final LedgersSpiAccountMapper accountMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService tokenService;
    private final FeignExceptionReader feignExceptionReader;
    private final IbanResolverMockService ibanResolverMockService;

    public CardAccountSpiImpl(AccountRestClient restClient, LedgersSpiAccountMapper accountMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService tokenService, FeignExceptionReader feignExceptionReader, IbanResolverMockService ibanResolverMockService) {
        this.accountRestClient = restClient;
        this.accountMapper = accountMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.tokenService = tokenService;
        this.feignExceptionReader = feignExceptionReader;
        this.ibanResolverMockService = ibanResolverMockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<List<SpiCardAccountDetails>> requestCardAccountList(@NotNull SpiContextData contextData, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested card account list for consent with ID: {}", (Object)accountConsent.getId());
            List<SpiCardAccountDetails> cardAccountDetailsList = this.getSpiCardAccountDetails(accountConsent, aspspConsentData);
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            cardAccountDetailsList.forEach(sad -> this.enrichSpiCardAccountDetailsWithOwnerName((SpiCardAccountDetails)sad, accountConsent.getAccess()));
            List<SpiCardAccountDetails> payload = this.mapToCardAccountList(cardAccountDetailsList);
            SpiResponse spiResponse = SpiResponse.builder().payload(payload).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request card account list failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiCardAccountDetails> requestCardAccountDetailsForAccount(@NotNull SpiContextData contextData, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested details for account, ACCOUNT-ID: {}", (Object)accountReference.getResourceId());
            SpiCardAccountDetails cardAccountDetails = Optional.ofNullable((AccountDetailsTO)this.accountRestClient.getAccountDetailsById(accountReference.getResourceId()).getBody()).map(this.accountMapper::toSpiCardAccountDetails).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            cardAccountDetails.setMaskedPan(this.ibanResolverMockService.getMaskedPanByIban(cardAccountDetails.getAspspAccountId()));
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            this.enrichSpiCardAccountDetailsWithOwnerName(cardAccountDetails, accountConsent.getAccess());
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)cardAccountDetails).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request card account details for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiCardTransactionReport> requestCardTransactionsForAccount(@NotNull SpiContextData contextData, @NotNull SpiTransactionReportParameters spiTransactionReportParameters, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (BookingStatus.INFORMATION == spiTransactionReportParameters.getBookingStatus()) {
            logger.info("Retrieving mock standing order report for account: {}", (Object)accountReference.getResourceId());
            SpiCardTransactionReport transactionReport = new SpiCardTransactionReport("dGVzdA==", this.buildSpiTransactionList(), Collections.singletonList(this.buildSpiAccountBalance()), DEFAULT_ACCEPT_MEDIA_TYPE, null);
            return SpiResponse.builder().payload((Object)transactionReport).build();
        }
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        LocalDate dateFrom = Optional.ofNullable(spiTransactionReportParameters.getDateFrom()).orElse(LocalDate.now().minusMonths(6L));
        LocalDate dateTo = Optional.ofNullable(spiTransactionReportParameters.getDateTo()).orElse(LocalDate.now());
        boolean withBalance = spiTransactionReportParameters.isWithBalance();
        String acceptMediaType = spiTransactionReportParameters.getAcceptMediaType();
        String entryReferenceFrom = spiTransactionReportParameters.getEntryReferenceFrom();
        Boolean deltaList = spiTransactionReportParameters.getDeltaList();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested transactions for account: {}, dates from: {}, to: {}, withBalance: {}, entryReferenceFrom: {}, deltaList: {}", new Object[]{accountReference.getResourceId(), dateFrom, dateTo, withBalance, entryReferenceFrom, deltaList});
            List transactions = Optional.ofNullable((List)this.accountRestClient.getTransactionByDates(accountReference.getResourceId(), dateFrom, dateTo).getBody()).map(this.accountMapper::toSpiCardTransactions).orElseGet(ArrayList::new);
            List<SpiAccountBalance> balances = this.getSpiAccountBalances(contextData, withBalance, accountReference, accountConsent, aspspConsentDataProvider);
            SpiCardTransactionReport transactionReport = new SpiCardTransactionReport("dGVzdA==", transactions, balances, this.processAcceptMediaType(acceptMediaType), null);
            logger.info("Finally found {} transactions.", (Object)transactionReport.getCardTransactions().size());
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transactionReport).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private String processAcceptMediaType(String acceptMediaType) {
        return StringUtils.isBlank((CharSequence)acceptMediaType) || WILDCARD_ACCEPT_HEADER.equals(acceptMediaType) ? DEFAULT_ACCEPT_MEDIA_TYPE : acceptMediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<List<SpiAccountBalance>> requestCardBalancesForAccount(@NotNull SpiContextData contextData, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested Balances for ACCOUNT-ID: {}", (Object)accountReference.getResourceId());
            List accountBalances = Optional.ofNullable((List)this.accountRestClient.getBalances(accountReference.getResourceId()).getBody()).map(this.accountMapper::toSpiAccountBalancesList).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            logger.info("Found Balances: {}", (Object)accountBalances.size());
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)accountBalances).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request balances for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiCardAccountDetails> getSpiCardAccountDetails(@NotNull SpiAccountConsent accountConsent, byte[] aspspConsentData) {
        List<SpiCardAccountDetails> accountDetailsList;
        if (this.isGlobalConsent(accountConsent.getAccess()) || this.isAllAvailableAccountsConsent(accountConsent)) {
            logger.info("Consent with ID: {} is a global or available account Consent", (Object)accountConsent.getId());
            accountDetailsList = this.getAccountDetailsByConsentId(aspspConsentData);
        } else {
            logger.info("Consent with ID: {} is a regular consent", (Object)accountConsent.getId());
            accountDetailsList = this.getAccountDetailsFromReferences(accountConsent, aspspConsentData);
        }
        return accountDetailsList;
    }

    private List<SpiAccountBalance> getSpiAccountBalances(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (withBalance) {
            SpiResponse<List<SpiAccountBalance>> response = this.requestCardBalancesForAccount(contextData, accountReference, accountConsent, aspspConsentDataProvider);
            if (response.isSuccessful()) {
                return (List)response.getPayload();
            }
            throw FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, "Requested transaction can`t be found");
        }
        return null;
    }

    private boolean isGlobalConsent(SpiAccountAccess accountAccess) {
        return accountAccess.getAllPsd2() != null;
    }

    private boolean isAllAvailableAccountsConsent(SpiAccountConsent accountConsent) {
        return accountConsent.getAisConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
    }

    private List<SpiCardAccountDetails> getAccountDetailsByConsentId(byte[] aspspConsentData) {
        try {
            this.applyAuthorisation(aspspConsentData);
            List list = Optional.ofNullable((List)this.accountRestClient.getListOfAccounts().getBody()).map(l -> l.stream().map(this.accountMapper::toSpiCardAccountDetails).collect(Collectors.toList())).orElseGet(Collections::emptyList);
            return list;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiCardAccountDetails> getAccountDetailsFromReferences(SpiAccountConsent accountConsent, byte[] aspspConsentData) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        List references = accountAccess.getAccounts();
        return this.getAccountDetailsFromReferences(references, aspspConsentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SpiCardAccountDetails> getAccountDetailsFromReferences(List<SpiAccountReference> references, byte[] aspspConsentData) {
        try {
            this.applyAuthorisation(aspspConsentData);
            List accountDetails = (List)this.accountRestClient.getListOfAccounts().getBody();
            if (accountDetails == null) {
                List<SpiCardAccountDetails> list = Collections.emptyList();
                return list;
            }
            List<SpiCardAccountDetails> list = accountDetails.stream().filter(account -> this.filterAccountDetailsByIbanAndCurrency(references, (AccountDetailsTO)account)).map(this.accountMapper::toSpiCardAccountDetails).collect(Collectors.toList());
            return list;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private boolean filterAccountDetailsByIbanAndCurrency(List<SpiAccountReference> references, AccountDetailsTO account) {
        return references.stream().filter(reference -> Optional.ofNullable(reference.getIban()).orElseGet(() -> this.ibanResolverMockService.handleIbanByAccountReference((SpiAccountReference)reference)).equals(account.getIban())).anyMatch(reference -> reference.getCurrency() == null || reference.getCurrency().equals(account.getCurrency()));
    }

    private SCAResponseTO applyAuthorisation(byte[] aspspConsentData) {
        SCAResponseTO sca = this.tokenService.response(aspspConsentData);
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        return sca;
    }

    private TppMessage buildTppMessage(FeignException exception) {
        return FeignExceptionHandler.getFailureMessage(exception, MessageErrorCode.CONSENT_UNKNOWN_400, this.feignExceptionReader.getErrorMessage(exception));
    }

    private List<SpiCardTransaction> buildSpiTransactionList() {
        ArrayList<SpiCardTransaction> transactions = new ArrayList<SpiCardTransaction>();
        transactions.add(this.buildSpiCardTransactionById("0001"));
        transactions.add(this.buildSpiCardTransactionById("0002"));
        transactions.add(this.buildSpiCardTransactionById("0003"));
        return transactions;
    }

    private SpiCardTransaction buildSpiCardTransactionById(String cardTransactionId) {
        return new SpiCardTransaction(cardTransactionId, "999999999", LocalDate.of(2019, Month.JANUARY, 4), OffsetDateTime.of(2019, 1, 4, 10, 0, 0, 0, ZoneOffset.UTC), LocalDate.of(2019, Month.JANUARY, 4), new SpiAmount(Currency.getInstance("EUR"), new BigDecimal(200)), new ArrayList(), new SpiAmount(Currency.getInstance("EUR"), new BigDecimal(200)), new SpiAmount(Currency.getInstance("EUR"), new BigDecimal(200)), "2", "M\u00fcller", null, null, "M\u00fcller", "M\u00fcller", "M\u00fcller", Boolean.valueOf(true), "");
    }

    private SpiAccountBalance buildSpiAccountBalance() {
        SpiAccountBalance accountBalance = new SpiAccountBalance();
        accountBalance.setSpiBalanceAmount(new SpiAmount(Currency.getInstance("EUR"), new BigDecimal(1000)));
        accountBalance.setSpiBalanceType(SpiBalanceType.INTERIM_AVAILABLE);
        accountBalance.setLastCommittedTransaction("abcd");
        accountBalance.setReferenceDate(LocalDate.of(2020, Month.JANUARY, 1));
        accountBalance.setLastChangeDateTime(LocalDateTime.of(2019, Month.FEBRUARY, 15, 10, 0, 0, 0));
        return accountBalance;
    }

    private List<SpiCardAccountDetails> mapToCardAccountList(List<SpiCardAccountDetails> details) {
        details.forEach(det -> det.setMaskedPan(this.ibanResolverMockService.getMaskedPanByIban(det.getAspspAccountId())));
        return details;
    }

    private void enrichSpiCardAccountDetailsWithOwnerName(SpiCardAccountDetails cardAccountDetails, SpiAccountAccess access) {
        SpiAdditionalInformationAccess spiAdditionalInformationAccess = access.getSpiAdditionalInformationAccess();
        if (spiAdditionalInformationAccess != null && spiAdditionalInformationAccess.getOwnerName() != null) {
            cardAccountDetails.setOwnerName(ADDITIONAL_INFORMATION_MOCK);
        } else {
            AccountAccessType allAccountsWithOwnerName = AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME;
            List<AccountAccessType> accountAccessTypes = Arrays.asList(access.getAvailableAccounts(), access.getAvailableAccountsWithBalance(), access.getAllPsd2());
            if (accountAccessTypes.contains(allAccountsWithOwnerName)) {
                cardAccountDetails.setOwnerName(ADDITIONAL_INFORMATION_MOCK);
            }
        }
    }
}

