/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationResponse;
import de.adorsys.psd2.xs2a.spi.domain.piis.SpiPiisConsent;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import feign.FeignException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationSpiImpl
implements FundsConfirmationSpi {
    private static final Logger logger = LoggerFactory.getLogger(FundsConfirmationSpiImpl.class);
    private final AccountRestClient restClient;
    private final LedgersSpiAccountMapper accountMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService tokenService;
    private final UserMgmtRestClient userMgmtRestClient;
    @Value(value="${funds-confirmation-user-login:admin}")
    private String fundsConfirmationUserLogin;
    @Value(value="${funds-confirmation-user-password:admin123}")
    private String fundsConfirmationUserPassword;

    public FundsConfirmationSpiImpl(AccountRestClient restClient, LedgersSpiAccountMapper accountMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService tokenService, UserMgmtRestClient userMgmtRestClient) {
        this.restClient = restClient;
        this.accountMapper = accountMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.tokenService = tokenService;
        this.userMgmtRestClient = userMgmtRestClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiFundsConfirmationResponse> performFundsSufficientCheck(@NotNull SpiContextData contextData, @Nullable SpiPiisConsent piisConsent, @NotNull SpiFundsConfirmationRequest spiFundsConfirmationRequest, @Nullable SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = piisConsent == null || aspspConsentDataProvider == null ? null : aspspConsentDataProvider.loadAspspConsentData();
        try {
            String tokenForAuthorisation;
            if (aspspConsentData == null) {
                tokenForAuthorisation = this.getTokenForFundsConfirmationUser();
            } else {
                SCAResponseTO response = this.tokenService.response(aspspConsentData);
                tokenForAuthorisation = response.getBearerToken().getAccess_token();
            }
            this.authRequestInterceptor.setAccessToken(tokenForAuthorisation);
            logger.info("Funds confirmation request: {}", (Object)spiFundsConfirmationRequest);
            FundsConfirmationRequestTO request = this.accountMapper.toFundsConfirmationTO(contextData.getPsuData(), spiFundsConfirmationRequest);
            Boolean fundsAvailable = (Boolean)this.restClient.fundsConfirmation(request).getBody();
            logger.info("Funds confirmation response: {}", (Object)fundsAvailable);
            SpiFundsConfirmationResponse spiFundsConfirmationResponse = new SpiFundsConfirmationResponse();
            spiFundsConfirmationResponse.setFundsAvailable(Optional.ofNullable(fundsAvailable).orElse(false).booleanValue());
            if (aspspConsentDataProvider != null) {
                aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(this.tokenService.response(aspspConsentData)));
            }
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)spiFundsConfirmationResponse).build();
            return spiResponse;
        }
        catch (FeignException e) {
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(e, MessageErrorCode.FUNDS_CONFIRMATION_FAILED)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private String getTokenForFundsConfirmationUser() {
        ResponseEntity responseEntity = this.userMgmtRestClient.authorise(this.fundsConfirmationUserLogin, this.fundsConfirmationUserPassword, UserRoleTO.SYSTEM);
        SCALoginResponseTO scaLoginResponseTO = (SCALoginResponseTO)responseEntity.getBody();
        if (scaLoginResponseTO != null) {
            return scaLoginResponseTO.getBearerToken().getAccess_token();
        }
        return null;
    }
}

