/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.mock.IbanResolverMockService;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class AisConsentMapper {
    @Autowired
    private IbanResolverMockService ibanResolverMockService;

    @Mappings(value={@Mapping(target="tppId", source="tppInfo.authorisationNumber"), @Mapping(target="access.availableAccounts", source="access.availableAccounts", qualifiedByName={"mapToAccountAccessType"}), @Mapping(target="access.allPsd2", source="access.allPsd2", qualifiedByName={"mapToAccountAccessType"})})
    public abstract AisConsentTO mapToAisConsent(SpiAccountConsent var1);

    protected String mapSpiAccountReferenceToString(SpiAccountReference s) {
        return Optional.ofNullable(s.getIban()).orElseGet(() -> this.ibanResolverMockService.handleIbanByAccountReference(s));
    }

    public AisAccountAccessTypeTO mapToAccountAccessType(AccountAccessType accountAccessType) {
        if (accountAccessType == null) {
            return null;
        }
        switch (accountAccessType) {
            case ALL_ACCOUNTS: 
            case ALL_ACCOUNTS_WITH_OWNER_NAME: {
                return AisAccountAccessTypeTO.ALL_ACCOUNTS;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown account access type: %s", accountAccessType.getDescription()));
    }
}

