package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-07-17T11:29:52+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_252 (Private Build)"
)
@Component
public class AisConsentMapperImpl extends AisConsentMapper {

    @Override
    public AisConsentTO mapToAisConsent(SpiAccountConsent consent) {
        if ( consent == null ) {
            return null;
        }

        AisConsentTO aisConsentTO = new AisConsentTO();

        aisConsentTO.setAccess( spiAccountAccessToAisAccountAccessInfoTO( consent.getAccess() ) );
        aisConsentTO.setTppId( consentTppInfoAuthorisationNumber( consent ) );
        aisConsentTO.setId( consent.getId() );
        aisConsentTO.setFrequencyPerDay( consent.getFrequencyPerDay() );
        aisConsentTO.setValidUntil( consent.getValidUntil() );
        aisConsentTO.setRecurringIndicator( consent.isRecurringIndicator() );

        return aisConsentTO;
    }

    protected List<String> spiAccountReferenceListToStringList(List<SpiAccountReference> list) {
        if ( list == null ) {
            return null;
        }

        List<String> list1 = new ArrayList<String>( list.size() );
        for ( SpiAccountReference spiAccountReference : list ) {
            list1.add( mapSpiAccountReferenceToString( spiAccountReference ) );
        }

        return list1;
    }

    protected AisAccountAccessInfoTO spiAccountAccessToAisAccountAccessInfoTO(SpiAccountAccess spiAccountAccess) {
        if ( spiAccountAccess == null ) {
            return null;
        }

        AisAccountAccessInfoTO aisAccountAccessInfoTO = new AisAccountAccessInfoTO();

        aisAccountAccessInfoTO.setAvailableAccounts( mapToAccountAccessType( spiAccountAccess.getAvailableAccounts() ) );
        aisAccountAccessInfoTO.setAllPsd2( mapToAccountAccessType( spiAccountAccess.getAllPsd2() ) );
        aisAccountAccessInfoTO.setAccounts( spiAccountReferenceListToStringList( spiAccountAccess.getAccounts() ) );
        aisAccountAccessInfoTO.setBalances( spiAccountReferenceListToStringList( spiAccountAccess.getBalances() ) );
        aisAccountAccessInfoTO.setTransactions( spiAccountReferenceListToStringList( spiAccountAccess.getTransactions() ) );

        return aisAccountAccessInfoTO;
    }

    private String consentTppInfoAuthorisationNumber(SpiAccountConsent spiAccountConsent) {
        if ( spiAccountConsent == null ) {
            return null;
        }
        TppInfo tppInfo = spiAccountConsent.getTppInfo();
        if ( tppInfo == null ) {
            return null;
        }
        String authorisationNumber = tppInfo.getAuthorisationNumber();
        if ( authorisationNumber == null ) {
            return null;
        }
        return authorisationNumber;
    }
}
