/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ChallengeDataMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import feign.FeignException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class GeneralAuthorisationService {
    private static final String ATTEMPT_FAILURE = "PSU_AUTH_ATTEMPT_INVALID";
    private static final Logger logger = LoggerFactory.getLogger(GeneralAuthorisationService.class);
    private final UserMgmtRestClient userMgmtRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final ChallengeDataMapper challengeDataMapper;
    private final ScaMethodConverter scaMethodConverter;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;

    public GeneralAuthorisationService(UserMgmtRestClient userMgmtRestClient, AuthRequestInterceptor authRequestInterceptor, ChallengeDataMapper challengeDataMapper, ScaMethodConverter scaMethodConverter, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader) {
        this.userMgmtRestClient = userMgmtRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
        this.challengeDataMapper = challengeDataMapper;
        this.scaMethodConverter = scaMethodConverter;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
    }

    @Deprecated
    public <T extends SCAResponseTO> SpiResponse<SpiPsuAuthorisationResponse> authorisePsuForConsent(@NotNull SpiPsuData spiPsuData, String pin, String consentId, OpTypeTO opType, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        String authorisationId = Ids.id();
        try {
            String login = spiPsuData.getPsuId();
            logger.info("Authorise user with login: {}", (Object)login);
            ResponseEntity response = this.userMgmtRestClient.authoriseForConsent(login, pin, consentId, authorisationId, opType);
            SpiAuthorisationStatus status = response != null && response.getBody() != null && ((SCALoginResponseTO)response.getBody()).getBearerToken() != null ? SpiAuthorisationStatus.SUCCESS : SpiAuthorisationStatus.FAILURE;
            logger.info("Authorisation status is: {}", (Object)status);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)Optional.ofNullable(response).map(HttpEntity::getBody).orElseGet(SCALoginResponseTO::new)));
            return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, status)).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Authorise PSU for consent failed: authorisation ID {}, consent ID {}, devMessage {}", new Object[]{authorisationId, consentId, devMessage});
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
        }
    }

    public <T extends SCAResponseTO> SpiResponse<SpiPsuAuthorisationResponse> authorisePsuForConsent(@NotNull SpiPsuData spiPsuData, String pin, String consentId, String authorisationId, OpTypeTO opType, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            String login = spiPsuData.getPsuId();
            logger.info("Authorise user with login: {}", (Object)login);
            ResponseEntity response = this.userMgmtRestClient.authoriseForConsent(login, pin, consentId, authorisationId, opType);
            SpiAuthorisationStatus status = response != null && response.getBody() != null && ((SCALoginResponseTO)response.getBody()).getBearerToken() != null ? SpiAuthorisationStatus.SUCCESS : SpiAuthorisationStatus.FAILURE;
            logger.info("Authorisation status is: {}", (Object)status);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)Optional.ofNullable(response).map(HttpEntity::getBody).orElseGet(SCALoginResponseTO::new)));
            return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, status)).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Authorise PSU for consent failed: authorisation ID {}, consent ID {}, devMessage {}", new Object[]{authorisationId, consentId, devMessage});
            String errorCode = this.feignExceptionReader.getErrorCode(feignException);
            if (errorCode.equals(ATTEMPT_FAILURE)) {
                return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            }
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
        }
    }

    public BearerTokenTO validateToken(String accessToken) {
        try {
            this.authRequestInterceptor.setAccessToken(accessToken);
            BearerTokenTO bearerTokenTO = (BearerTokenTO)this.userMgmtRestClient.validate(accessToken).getBody();
            return bearerTokenTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public SpiResponse<SpiAuthorizationCodeResult> getResponseIfScaSelected(SpiAspspConsentDataProvider aspspConsentDataProvider, SCAResponseTO sca) {
        if (ScaStatusTO.SCAMETHODSELECTED.equals((Object)sca.getScaStatus())) {
            return this.returnScaMethodSelection(aspspConsentDataProvider, sca);
        }
        Object[] messageTextArgs = new Object[]{ScaStatusTO.SCAMETHODSELECTED.toString(), ScaStatusTO.PSUIDENTIFIED.toString(), sca.getScaStatus().toString()};
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_INVALID, messageTextArgs)).build();
    }

    public SpiResponse<SpiAuthorizationCodeResult> returnScaMethodSelection(SpiAspspConsentDataProvider aspspConsentDataProvider, SCAResponseTO sca) {
        SpiAuthorizationCodeResult spiAuthorizationCodeResult = new SpiAuthorizationCodeResult();
        ChallengeData challengeData = Optional.ofNullable(this.challengeDataMapper.toChallengeData(sca.getChallengeData())).orElse(new ChallengeData());
        spiAuthorizationCodeResult.setChallengeData(challengeData);
        spiAuthorizationCodeResult.setSelectedScaMethod(this.scaMethodConverter.toAuthenticationObject(sca.getChosenScaMethod()));
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(sca));
        return SpiResponse.builder().payload((Object)spiAuthorizationCodeResult).build();
    }
}

