package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.psd2.xs2a.core.pis.Remittance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiExchangeRate;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-05-08T20:46:33+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_242 (Private Build)"
)
@Component
public class LedgersSpiAccountMapperImpl extends LedgersSpiAccountMapper {

    @Override
    public List<SpiTransaction> toSpiTransactions(List<TransactionTO> transactions) {
        if ( transactions == null ) {
            return null;
        }

        List<SpiTransaction> list = new ArrayList<SpiTransaction>( transactions.size() );
        for ( TransactionTO transactionTO : transactions ) {
            list.add( toSpiTransaction( transactionTO ) );
        }

        return list;
    }

    @Override
    public List<SpiCardTransaction> toSpiCardTransactions(List<TransactionTO> transactions) {
        if ( transactions == null ) {
            return null;
        }

        List<SpiCardTransaction> list = new ArrayList<SpiCardTransaction>( transactions.size() );
        for ( TransactionTO transactionTO : transactions ) {
            list.add( toSpiCardTransaction( transactionTO ) );
        }

        return list;
    }

    @Override
    public List<SpiAccountBalance> toSpiAccountBalancesList(List<AccountBalanceTO> accountBalanceTOS) {
        if ( accountBalanceTOS == null ) {
            return null;
        }

        List<SpiAccountBalance> list = new ArrayList<SpiAccountBalance>( accountBalanceTOS.size() );
        for ( AccountBalanceTO accountBalanceTO : accountBalanceTOS ) {
            list.add( accountBalanceTOToSpiAccountBalance( accountBalanceTO ) );
        }

        return list;
    }

    @Override
    public SpiAccountBalance accountBalanceTOToSpiAccountBalance(AccountBalanceTO accountBalanceTO) {
        if ( accountBalanceTO == null ) {
            return null;
        }

        SpiAccountBalance spiAccountBalance = new SpiAccountBalance();

        spiAccountBalance.setSpiBalanceAmount( toSpiAmount( accountBalanceTO.getAmount() ) );
        spiAccountBalance.setLastChangeDateTime( accountBalanceTO.getLastChangeDateTime() );
        spiAccountBalance.setReferenceDate( accountBalanceTO.getReferenceDate() );
        spiAccountBalance.setLastCommittedTransaction( accountBalanceTO.getLastCommittedTransaction() );

        spiAccountBalance.setSpiBalanceType( mapToSpiBalanceType(accountBalanceTO.getBalanceType()) );

        return spiAccountBalance;
    }

    @Override
    public List<SpiExchangeRate> toSpiExchangeRateList(List<ExchangeRateTO> exchangeRates) {
        if ( exchangeRates == null ) {
            return null;
        }

        List<SpiExchangeRate> list = new ArrayList<SpiExchangeRate>( exchangeRates.size() );
        for ( ExchangeRateTO exchangeRateTO : exchangeRates ) {
            list.add( toSpiExchangeRate( exchangeRateTO ) );
        }

        return list;
    }

    @Override
    public FundsConfirmationRequestTO toFundsConfirmationTO(SpiPsuData psuData, SpiFundsConfirmationRequest spiFundsConfirmationRequest) {
        if ( psuData == null && spiFundsConfirmationRequest == null ) {
            return null;
        }

        FundsConfirmationRequestTO fundsConfirmationRequestTO = new FundsConfirmationRequestTO();

        if ( psuData != null ) {
            fundsConfirmationRequestTO.setPsuId( psuData.getPsuId() );
        }
        if ( spiFundsConfirmationRequest != null ) {
            fundsConfirmationRequestTO.setPsuAccount( mapToAccountReferenceTO( spiFundsConfirmationRequest.getPsuAccount() ) );
            fundsConfirmationRequestTO.setInstructedAmount( spiAmountToAmountTO( spiFundsConfirmationRequest.getInstructedAmount() ) );
            fundsConfirmationRequestTO.setCardNumber( spiFundsConfirmationRequest.getCardNumber() );
            fundsConfirmationRequestTO.setPayee( spiFundsConfirmationRequest.getPayee() );
        }

        return fundsConfirmationRequestTO;
    }

    @Override
    public AccountReferenceTO mapToAccountReferenceTO(SpiAccountReference spiAccountReference) {
        if ( spiAccountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( spiAccountReference.getIban() );
        accountReferenceTO.setBban( spiAccountReference.getBban() );
        accountReferenceTO.setPan( spiAccountReference.getPan() );
        accountReferenceTO.setMaskedPan( spiAccountReference.getMaskedPan() );
        accountReferenceTO.setMsisdn( spiAccountReference.getMsisdn() );
        accountReferenceTO.setCurrency( spiAccountReference.getCurrency() );

        return accountReferenceTO;
    }

    @Override
    public Remittance mapToRemittance(RemittanceInformationStructuredTO remittanceInformationStructuredTO) {
        if ( remittanceInformationStructuredTO == null ) {
            return null;
        }

        Remittance remittance = new Remittance();

        remittance.setReference( remittanceInformationStructuredTO.getReference() );
        remittance.setReferenceType( remittanceInformationStructuredTO.getReferenceType() );
        remittance.setReferenceIssuer( remittanceInformationStructuredTO.getReferenceIssuer() );

        return remittance;
    }

    protected AmountTO spiAmountToAmountTO(SpiAmount spiAmount) {
        if ( spiAmount == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( spiAmount.getCurrency() );
        amountTO.setAmount( spiAmount.getAmount() );

        return amountTO;
    }
}
