package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-12-11T09:06:29+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class LedgersSpiPaymentMapperImpl extends LedgersSpiPaymentMapper {

    @Autowired
    private LedgersSpiAccountMapper ledgersSpiAccountMapper;
    @Autowired
    private ChallengeDataMapper challengeDataMapper;
    @Autowired
    private AddressMapper addressMapper;

    @Override
    public SinglePaymentTO toSinglePaymentTO(SpiSinglePayment payment) {
        if ( payment == null ) {
            return null;
        }

        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();

        singlePaymentTO.setPaymentId( payment.getPaymentId() );
        singlePaymentTO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        singlePaymentTO.setDebtorAccount( ledgersSpiAccountMapper.mapToAccountReferenceTO( payment.getDebtorAccount() ) );
        singlePaymentTO.setInstructedAmount( spiAmountToAmountTO( payment.getInstructedAmount() ) );
        singlePaymentTO.setCreditorAccount( ledgersSpiAccountMapper.mapToAccountReferenceTO( payment.getCreditorAccount() ) );
        singlePaymentTO.setCreditorAgent( payment.getCreditorAgent() );
        singlePaymentTO.setCreditorName( payment.getCreditorName() );
        singlePaymentTO.setCreditorAddress( addressMapper.toAddressTO( payment.getCreditorAddress() ) );
        singlePaymentTO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        singlePaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( payment.getPaymentStatus() ) );
        singlePaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );

        singlePaymentTO.setPaymentProduct( toPaymentProduct(payment.getPaymentProduct()) );
        singlePaymentTO.setRequestedExecutionTime( toTime(payment.getRequestedExecutionTime()) );

        return singlePaymentTO;
    }

    @Override
    public PeriodicPaymentTO toPeriodicPaymentTO(SpiPeriodicPayment payment) {
        if ( payment == null ) {
            return null;
        }

        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();

        periodicPaymentTO.setPaymentId( payment.getPaymentId() );
        periodicPaymentTO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        periodicPaymentTO.setDebtorAccount( ledgersSpiAccountMapper.mapToAccountReferenceTO( payment.getDebtorAccount() ) );
        periodicPaymentTO.setInstructedAmount( spiAmountToAmountTO( payment.getInstructedAmount() ) );
        periodicPaymentTO.setCreditorAccount( ledgersSpiAccountMapper.mapToAccountReferenceTO( payment.getCreditorAccount() ) );
        periodicPaymentTO.setCreditorAgent( payment.getCreditorAgent() );
        periodicPaymentTO.setCreditorName( payment.getCreditorName() );
        periodicPaymentTO.setCreditorAddress( addressMapper.toAddressTO( payment.getCreditorAddress() ) );
        periodicPaymentTO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        periodicPaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( payment.getPaymentStatus() ) );
        periodicPaymentTO.setPaymentProduct( toPaymentProduct( payment.getPaymentProduct() ) );
        periodicPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        periodicPaymentTO.setRequestedExecutionTime( toTime( payment.getRequestedExecutionTime() ) );
        periodicPaymentTO.setStartDate( payment.getStartDate() );
        periodicPaymentTO.setEndDate( payment.getEndDate() );

        periodicPaymentTO.setExecutionRule( LedgersSpiPaymentMapperHelper.mapPisExecutionRule(payment.getExecutionRule()) );
        periodicPaymentTO.setDayOfExecution( LedgersSpiPaymentMapperHelper.mapPisDayOfExecution(payment.getDayOfExecution()) );
        periodicPaymentTO.setFrequency( LedgersSpiPaymentMapperHelper.mapFrequencyCode(payment.getFrequency()) );

        return periodicPaymentTO;
    }

    @Override
    public BulkPaymentTO toBulkPaymentTO(SpiBulkPayment payment) {
        if ( payment == null ) {
            return null;
        }

        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();

        bulkPaymentTO.setPaymentId( payment.getPaymentId() );
        bulkPaymentTO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        bulkPaymentTO.setDebtorAccount( ledgersSpiAccountMapper.mapToAccountReferenceTO( payment.getDebtorAccount() ) );
        bulkPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        bulkPaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( payment.getPaymentStatus() ) );
        bulkPaymentTO.setPayments( spiSinglePaymentListToSinglePaymentTOList( payment.getPayments() ) );
        bulkPaymentTO.setPaymentProduct( toPaymentProduct( payment.getPaymentProduct() ) );

        return bulkPaymentTO;
    }

    @Override
    public SpiSinglePaymentInitiationResponse toSpiSingleResponse(SinglePaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        SpiSinglePaymentInitiationResponse spiSinglePaymentInitiationResponse = new SpiSinglePaymentInitiationResponse();

        spiSinglePaymentInitiationResponse.setTransactionStatus( transactionStatusTOToTransactionStatus( payment.getPaymentStatus() ) );
        spiSinglePaymentInitiationResponse.setPaymentId( payment.getPaymentId() );

        return spiSinglePaymentInitiationResponse;
    }

    @Override
    public SpiSinglePaymentInitiationResponse toSpiSingleResponse(SCAPaymentResponseTO response) {
        if ( response == null ) {
            return null;
        }

        SpiSinglePaymentInitiationResponse spiSinglePaymentInitiationResponse = new SpiSinglePaymentInitiationResponse();

        spiSinglePaymentInitiationResponse.setTransactionStatus( transactionStatusTOToTransactionStatus( response.getTransactionStatus() ) );
        spiSinglePaymentInitiationResponse.setPaymentId( response.getPaymentId() );
        spiSinglePaymentInitiationResponse.setMultilevelScaRequired( response.isMultilevelScaRequired() );
        spiSinglePaymentInitiationResponse.setChallengeData( challengeDataMapper.toChallengeData( response.getChallengeData() ) );
        spiSinglePaymentInitiationResponse.setPsuMessage( response.getPsuMessage() );

        spiSinglePaymentInitiationResponse.setChosenScaMethod( ScaMethodUtils.toScaMethod(response.getChosenScaMethod()) );
        spiSinglePaymentInitiationResponse.setScaMethods( ScaMethodUtils.toScaMethods(response.getScaMethods()) );

        return spiSinglePaymentInitiationResponse;
    }

    @Override
    public SpiPeriodicPaymentInitiationResponse toSpiPeriodicResponse(PeriodicPaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        SpiPeriodicPaymentInitiationResponse spiPeriodicPaymentInitiationResponse = new SpiPeriodicPaymentInitiationResponse();

        spiPeriodicPaymentInitiationResponse.setTransactionStatus( transactionStatusTOToTransactionStatus( payment.getPaymentStatus() ) );
        spiPeriodicPaymentInitiationResponse.setPaymentId( payment.getPaymentId() );

        return spiPeriodicPaymentInitiationResponse;
    }

    @Override
    public SpiPeriodicPaymentInitiationResponse toSpiPeriodicResponse(SCAPaymentResponseTO response) {
        if ( response == null ) {
            return null;
        }

        SpiPeriodicPaymentInitiationResponse spiPeriodicPaymentInitiationResponse = new SpiPeriodicPaymentInitiationResponse();

        spiPeriodicPaymentInitiationResponse.setTransactionStatus( transactionStatusTOToTransactionStatus( response.getTransactionStatus() ) );
        spiPeriodicPaymentInitiationResponse.setPaymentId( response.getPaymentId() );
        spiPeriodicPaymentInitiationResponse.setMultilevelScaRequired( response.isMultilevelScaRequired() );
        spiPeriodicPaymentInitiationResponse.setChallengeData( challengeDataMapper.toChallengeData( response.getChallengeData() ) );
        spiPeriodicPaymentInitiationResponse.setPsuMessage( response.getPsuMessage() );

        spiPeriodicPaymentInitiationResponse.setChosenScaMethod( ScaMethodUtils.toScaMethod(response.getChosenScaMethod()) );
        spiPeriodicPaymentInitiationResponse.setScaMethods( ScaMethodUtils.toScaMethods(response.getScaMethods()) );

        return spiPeriodicPaymentInitiationResponse;
    }

    @Override
    public SpiBulkPaymentInitiationResponse toSpiBulkResponse(BulkPaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        SpiBulkPaymentInitiationResponse spiBulkPaymentInitiationResponse = new SpiBulkPaymentInitiationResponse();

        spiBulkPaymentInitiationResponse.setTransactionStatus( transactionStatusTOToTransactionStatus( payment.getPaymentStatus() ) );
        spiBulkPaymentInitiationResponse.setPaymentId( payment.getPaymentId() );
        spiBulkPaymentInitiationResponse.setPayments( toSpiSinglePaymentsList( payment.getPayments() ) );

        return spiBulkPaymentInitiationResponse;
    }

    @Override
    public SpiBulkPaymentInitiationResponse toSpiBulkResponse(SCAPaymentResponseTO response) {
        if ( response == null ) {
            return null;
        }

        SpiBulkPaymentInitiationResponse spiBulkPaymentInitiationResponse = new SpiBulkPaymentInitiationResponse();

        spiBulkPaymentInitiationResponse.setTransactionStatus( transactionStatusTOToTransactionStatus( response.getTransactionStatus() ) );
        spiBulkPaymentInitiationResponse.setPaymentId( response.getPaymentId() );
        spiBulkPaymentInitiationResponse.setMultilevelScaRequired( response.isMultilevelScaRequired() );
        spiBulkPaymentInitiationResponse.setChallengeData( challengeDataMapper.toChallengeData( response.getChallengeData() ) );
        spiBulkPaymentInitiationResponse.setPsuMessage( response.getPsuMessage() );

        spiBulkPaymentInitiationResponse.setChosenScaMethod( ScaMethodUtils.toScaMethod(response.getChosenScaMethod()) );
        spiBulkPaymentInitiationResponse.setScaMethods( ScaMethodUtils.toScaMethods(response.getScaMethods()) );

        return spiBulkPaymentInitiationResponse;
    }

    @Override
    public List<SpiSinglePayment> toSpiSinglePaymentsList(List<SinglePaymentTO> payments) {
        if ( payments == null ) {
            return null;
        }

        List<SpiSinglePayment> list = new ArrayList<SpiSinglePayment>( payments.size() );
        for ( SinglePaymentTO singlePaymentTO : payments ) {
            list.add( toSpiSinglePayment( singlePaymentTO ) );
        }

        return list;
    }

    protected AmountTO spiAmountToAmountTO(SpiAmount spiAmount) {
        if ( spiAmount == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( spiAmount.getCurrency() );
        amountTO.setAmount( spiAmount.getAmount() );

        return amountTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        if ( transactionStatus == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( transactionStatus ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatus );
        }

        return transactionStatusTO;
    }

    protected List<SinglePaymentTO> spiSinglePaymentListToSinglePaymentTOList(List<SpiSinglePayment> list) {
        if ( list == null ) {
            return null;
        }

        List<SinglePaymentTO> list1 = new ArrayList<SinglePaymentTO>( list.size() );
        for ( SpiSinglePayment spiSinglePayment : list ) {
            list1.add( toSinglePaymentTO( spiSinglePayment ) );
        }

        return list1;
    }

    protected TransactionStatus transactionStatusTOToTransactionStatus(TransactionStatusTO transactionStatusTO) {
        if ( transactionStatusTO == null ) {
            return null;
        }

        TransactionStatus transactionStatus;

        switch ( transactionStatusTO ) {
            case ACCC: transactionStatus = TransactionStatus.ACCC;
            break;
            case ACCP: transactionStatus = TransactionStatus.ACCP;
            break;
            case ACSC: transactionStatus = TransactionStatus.ACSC;
            break;
            case ACSP: transactionStatus = TransactionStatus.ACSP;
            break;
            case ACTC: transactionStatus = TransactionStatus.ACTC;
            break;
            case ACWC: transactionStatus = TransactionStatus.ACWC;
            break;
            case ACWP: transactionStatus = TransactionStatus.ACWP;
            break;
            case RCVD: transactionStatus = TransactionStatus.RCVD;
            break;
            case PDNG: transactionStatus = TransactionStatus.PDNG;
            break;
            case RJCT: transactionStatus = TransactionStatus.RJCT;
            break;
            case CANC: transactionStatus = TransactionStatus.CANC;
            break;
            case ACFC: transactionStatus = TransactionStatus.ACFC;
            break;
            case PATC: transactionStatus = TransactionStatus.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatusTO );
        }

        return transactionStatus;
    }
}
