/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionReport;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import feign.FeignException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:mock-data.properties"})
public class AccountSpiImpl
implements AccountSpi {
    private static final String RESPONSE_STATUS_200_WITH_EMPTY_BODY = "Response status was 200, but the body was empty!";
    @Value(value="${test-download-transaction-list}")
    private String transactionList;
    private static final Logger logger = LoggerFactory.getLogger(AccountSpiImpl.class);
    private static final String DEFAULT_ACCEPT_MEDIA_TYPE = "application/json";
    private static final String WILDCARD_ACCEPT_HEADER = "*/*";
    private final AccountRestClient accountRestClient;
    private final LedgersSpiAccountMapper accountMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService tokenService;
    private final FeignExceptionReader feignExceptionReader;

    public AccountSpiImpl(AccountRestClient restClient, LedgersSpiAccountMapper accountMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService tokenService, FeignExceptionReader feignExceptionReader) {
        this.accountRestClient = restClient;
        this.accountMapper = accountMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.tokenService = tokenService;
        this.feignExceptionReader = feignExceptionReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<List<SpiAccountDetails>> requestAccountList(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested account list for consent with ID: {} and withBalance: {}", (Object)accountConsent.getId(), (Object)withBalance);
            List<SpiAccountDetails> accountDetailsList = this.getSpiAccountDetails(withBalance, accountConsent, aspspConsentData);
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload(this.filterAccountDetailsByWithBalance(withBalance, accountDetailsList, accountConsent.getAccess())).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request account list failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiAccountDetails> requestAccountDetailForAccount(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested details for account, ACCOUNT-ID: {}, withBalance: {}", (Object)accountReference.getResourceId(), (Object)withBalance);
            SpiAccountDetails accountDetails = Optional.ofNullable(this.accountRestClient.getAccountDetailsById(accountReference.getResourceId()).getBody()).map(this.accountMapper::toSpiAccountDetails).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            if (!withBalance) {
                accountDetails.emptyBalances();
            }
            logger.info("The responded account RESOURCE-ID: {}", (Object)accountDetails.getResourceId());
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)accountDetails).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request account details for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiTransactionReport> requestTransactionsForAccount(@NotNull SpiContextData contextData, String acceptMediaType, boolean withBalance, @NotNull LocalDate dateFrom, @NotNull LocalDate dateTo, @NotNull BookingStatus bookingStatus, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested transactions for account: {}, dates from: {}, to: {}, withBalance: {}", new Object[]{accountReference.getResourceId(), dateFrom, dateTo, withBalance});
            List transactions = Optional.ofNullable(this.accountRestClient.getTransactionByDates(accountReference.getResourceId(), dateFrom, dateTo).getBody()).map(this.accountMapper::toSpiTransactions).orElseGet(ArrayList::new);
            List<SpiAccountBalance> balances = this.getSpiAccountBalances(contextData, withBalance, accountReference, accountConsent, aspspConsentDataProvider);
            SpiTransactionReport transactionReport = new SpiTransactionReport("downloadId", transactions, balances, this.processAcceptMediaType(acceptMediaType), null);
            logger.info("Finally found {} transactions.", (Object)transactionReport.getTransactions().size());
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transactionReport).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private String processAcceptMediaType(String acceptMediaType) {
        return StringUtils.isBlank((CharSequence)acceptMediaType) || WILDCARD_ACCEPT_HEADER.equals(acceptMediaType) ? DEFAULT_ACCEPT_MEDIA_TYPE : acceptMediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiTransaction> requestTransactionForAccountByTransactionId(@NotNull SpiContextData contextData, @NotNull String transactionId, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested transaction with TRANSACTION-ID: {} for ACCOUNT-ID: {}", (Object)transactionId, (Object)accountReference.getResourceId());
            SpiTransaction transaction = Optional.ofNullable(this.accountRestClient.getTransactionById(accountReference.getResourceId(), transactionId).getBody()).map(this.accountMapper::toSpiTransaction).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            logger.info("Found transaction with TRANSACTION-ID: {}", (Object)transaction.getTransactionId());
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transaction).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions for account by transaction id failed: consent ID {}, resource ID {}, transaction ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), transactionId, devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<List<SpiAccountBalance>> requestBalancesForAccount(@NotNull SpiContextData contextData, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested Balances for ACCOUNT-ID: {}", (Object)accountReference.getResourceId());
            List accountBalances = Optional.ofNullable(this.accountRestClient.getBalances(accountReference.getResourceId()).getBody()).map(this.accountMapper::toSpiAccountBalancesList).orElseThrow(() -> FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, RESPONSE_STATUS_200_WITH_EMPTY_BODY));
            logger.info("Found Balances: {}", (Object)accountBalances.size());
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)accountBalances).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request balances for account failed: consent ID {}, resource ID {}, devMessage {}", new Object[]{accountConsent.getId(), accountReference.getResourceId(), devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiTransactionsDownloadResponse> requestTransactionsByDownloadLink(@NotNull SpiContextData spiContextData, @NotNull SpiAccountConsent spiAccountConsent, @NotNull String downloadId, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.applyAuthorisation(aspspConsentData);
            logger.info("Requested downloading list of transactions by download ID: {}", (Object)downloadId);
            ByteArrayInputStream stream = new ByteArrayInputStream(this.transactionList.getBytes());
            SpiTransactionsDownloadResponse transactionsDownloadResponse = new SpiTransactionsDownloadResponse((InputStream)stream, "transactions.json", Integer.valueOf(this.transactionList.getBytes().length));
            aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)transactionsDownloadResponse).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Request transactions by download link failed: consent ID {}, download link {}, devMessage {}", new Object[]{spiAccountConsent.getId(), downloadId, devMessage});
            SpiResponse spiResponse = SpiResponse.builder().error(this.buildTppMessage(feignException)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiAccountDetails> getSpiAccountDetails(boolean withBalance, @NotNull SpiAccountConsent accountConsent, byte[] aspspConsentData) {
        List<SpiAccountDetails> accountDetailsList;
        if (this.isGlobalConsent(accountConsent.getAccess()) || this.isAllAvailableAccountsConsent(accountConsent)) {
            logger.info("Consent with ID: {} is a global or available account Consent", (Object)accountConsent.getId());
            accountDetailsList = this.getAccountDetailsByConsentId(aspspConsentData);
        } else {
            logger.info("Consent with ID: {} is a regular consent", (Object)accountConsent.getId());
            accountDetailsList = this.getAccountDetailsFromReferences(withBalance, accountConsent, aspspConsentData);
        }
        return accountDetailsList;
    }

    private List<SpiAccountBalance> getSpiAccountBalances(@NotNull SpiContextData contextData, boolean withBalance, @NotNull SpiAccountReference accountReference, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (withBalance) {
            SpiResponse<List<SpiAccountBalance>> response = this.requestBalancesForAccount(contextData, accountReference, accountConsent, aspspConsentDataProvider);
            if (response.isSuccessful()) {
                return (List)response.getPayload();
            }
            throw FeignExceptionHandler.getException(HttpStatus.NOT_FOUND, "Requested transaction can`t be found");
        }
        return null;
    }

    private boolean isGlobalConsent(SpiAccountAccess accountAccess) {
        return accountAccess.getAllPsd2() != null;
    }

    private boolean isAllAvailableAccountsConsent(SpiAccountConsent accountConsent) {
        return accountConsent.getAisConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
    }

    private List<SpiAccountDetails> getAccountDetailsByConsentId(byte[] aspspConsentData) {
        try {
            this.applyAuthorisation(aspspConsentData);
            List list = Optional.ofNullable(this.accountRestClient.getListOfAccounts().getBody()).map(l -> l.stream().map(this.accountMapper::toSpiAccountDetails).collect(Collectors.toList())).orElseGet(Collections::emptyList);
            return list;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(boolean withBalance, SpiAccountConsent accountConsent, byte[] aspspConsentData) {
        SpiAccountAccess accountAccess = accountConsent.getAccess();
        List references = withBalance ? accountAccess.getBalances() : accountAccess.getAccounts();
        return this.getAccountDetailsFromReferences(references, aspspConsentData);
    }

    private List<SpiAccountDetails> getAccountDetailsFromReferences(List<SpiAccountReference> references, byte[] aspspConsentData) {
        return references.stream().map(r -> this.getAccountDetailsByAccountReference((SpiAccountReference)r, aspspConsentData)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SpiAccountDetails> getAccountDetailsByAccountReference(SpiAccountReference reference, byte[] aspspConsentData) {
        if (reference == null) {
            return Optional.empty();
        }
        try {
            this.applyAuthorisation(aspspConsentData);
            AccountDetailsTO response = (AccountDetailsTO)this.accountRestClient.getAccountDetailsByIban(reference.getIban()).getBody();
            Optional<SpiAccountDetails> optional = Optional.ofNullable(response).map(this.accountMapper::toSpiAccountDetails);
            return optional;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiAccountDetails> filterAccountDetailsByWithBalance(boolean withBalance, List<SpiAccountDetails> details, SpiAccountAccess spiAccountAccess) {
        if (withBalance && this.isConsentSupportedBalances(spiAccountAccess)) {
            return details;
        }
        for (SpiAccountDetails spiAccountDetails : details) {
            if (withBalance && this.isValidAccountByAccess(spiAccountDetails.getIban(), spiAccountAccess.getBalances())) continue;
            spiAccountDetails.emptyBalances();
        }
        return details;
    }

    private boolean isConsentSupportedBalances(SpiAccountAccess spiAccountAccess) {
        boolean isConsentGlobal = spiAccountAccess.getAllPsd2() != null;
        boolean isConsentForAvailableAccountsWithBalances = spiAccountAccess.getAvailableAccountsWithBalance() == AccountAccessType.ALL_ACCOUNTS;
        return isConsentGlobal || isConsentForAvailableAccountsWithBalances;
    }

    private SCAResponseTO applyAuthorisation(byte[] aspspConsentData) {
        SCAResponseTO sca = this.tokenService.response(aspspConsentData);
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        return sca;
    }

    private boolean isValidAccountByAccess(String iban, List<SpiAccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> iban.equals(a.getIban()));
    }

    private TppMessage buildTppMessage(FeignException exception) {
        return FeignExceptionHandler.getFailureMessage(exception, MessageErrorCode.CONSENT_UNKNOWN_400, this.feignExceptionReader.getErrorMessage(exception));
    }
}

