/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.payment.type;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.GeneralPaymentService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.type.AbstractPaymentSpi;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePaymentSpiImpl
extends AbstractPaymentSpi<SpiSinglePayment, SpiSinglePaymentInitiationResponse>
implements SinglePaymentSpi {
    private LedgersSpiPaymentMapper paymentMapper;
    private GeneralPaymentService paymentService;

    @Autowired
    public SinglePaymentSpiImpl(GeneralPaymentService paymentService, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, LedgersSpiPaymentMapper paymentMapper) {
        super(paymentService, consentDataService, feignExceptionReader);
        this.paymentService = paymentService;
        this.paymentMapper = paymentMapper;
    }

    @NotNull
    public SpiResponse<SpiSinglePayment> getPaymentById(@NotNull SpiContextData contextData, @NotNull SpiSinglePayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.paymentService.getPaymentById(payment, aspspConsentDataProvider, SinglePaymentTO.class, this.paymentMapper::toSpiSinglePayment, PaymentTypeTO.SINGLE);
    }

    @Override
    protected SCAPaymentResponseTO initiatePaymentInternal(SpiSinglePayment payment, byte[] initialAspspConsentData) {
        SinglePaymentTO request = this.paymentMapper.toSinglePaymentTO(payment);
        if (request.getPaymentProduct() == null) {
            String product = this.paymentService.getSCAPaymentResponseTO(initialAspspConsentData).getPaymentProduct();
            request.setPaymentProduct((PaymentProductTO)PaymentProductTO.getByValue((String)product).orElse(null));
        }
        return this.paymentService.initiatePaymentInternal(payment, initialAspspConsentData, PaymentTypeTO.SINGLE, request);
    }

    @Override
    protected SpiResponse<SpiSinglePaymentInitiationResponse> processEmptyAspspConsentData(@NotNull SpiSinglePayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.paymentService.firstCallInstantiatingPayment(PaymentTypeTO.SINGLE, (SpiPayment)payment, aspspConsentDataProvider, new SpiSinglePaymentInitiationResponse());
    }

    @Override
    @NotNull
    protected SpiSinglePaymentInitiationResponse getToSpiPaymentResponse(SCAPaymentResponseTO response) {
        return this.paymentMapper.toSpiSingleResponse(response);
    }
}

