/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.payment;

import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.NotSupportedPaymentTypeException;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.PaymentSpi;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class PaymentSpiImpl
implements PaymentSpi {
    private final SinglePaymentSpi singlePaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;

    @Override
    public <P extends SpiPayment> SpiResponse<? extends SpiPaymentInitiationResponse> initiatePayment(@NotNull SpiContextData contextData, @NotNull P spiPayment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) throws NotSupportedPaymentTypeException {
        PaymentType paymentType = spiPayment.getPaymentType();
        switch (paymentType) {
            case SINGLE: {
                return this.singlePaymentSpi.initiatePayment(contextData, (SpiSinglePayment)spiPayment, aspspConsentDataProvider);
            }
            case BULK: {
                return this.bulkPaymentSpi.initiatePayment(contextData, (SpiBulkPayment)spiPayment, aspspConsentDataProvider);
            }
            case PERIODIC: {
                return this.periodicPaymentSpi.initiatePayment(contextData, (SpiPeriodicPayment)spiPayment, aspspConsentDataProvider);
            }
        }
        throw new NotSupportedPaymentTypeException(String.format("Unknown payment type: %s", paymentType.getValue()));
    }

    public PaymentSpiImpl(SinglePaymentSpi singlePaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, BulkPaymentSpi bulkPaymentSpi) {
        this.singlePaymentSpi = singlePaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
    }
}

