/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import feign.FeignException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public abstract class AbstractAuthorisationSpi<T, R extends SCAResponseTO> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorisationSpi.class);
    private static final String DECOUPLED_PSU_MESSAGE = "Please check your app to continue...";
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final GeneralAuthorisationService authorisationService;
    private final ScaMethodConverter scaMethodConverter;
    private final FeignExceptionReader feignExceptionReader;

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData contextData, @NotNull SpiPsuData psuLoginData, String password, T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        R scaBusinessObjectResponse;
        R originalResponse;
        try {
            originalResponse = this.getSCAConsentResponse(aspspConsentDataProvider, false);
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            log.error("Read aspspConsentData in authorise PSU failed: consent ID {}, devMessage {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, new Object[0])).build();
        }
        SpiResponse<SpiAuthorisationStatus> authorisePsu = this.authorisationService.authorisePsuForConsent(psuLoginData, password, this.getBusinessObjectId(businessObject), originalResponse, this.getOtpType(), aspspConsentDataProvider);
        if (!authorisePsu.isSuccessful()) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, new Object[0])).build();
        }
        try {
            scaBusinessObjectResponse = this.mapToScaResponse(businessObject, aspspConsentDataProvider.loadAspspConsentData(), originalResponse);
        }
        catch (IOException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_RESPONSE_TYPE, new Object[0])).build();
        }
        return this.onSuccessfulAuthorisation(businessObject, aspspConsentDataProvider, authorisePsu, scaBusinessObjectResponse);
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData contextData, T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            R sca = this.getSCAConsentResponse(aspspConsentDataProvider, true);
            if (this.validateStatuses(businessObject, sca)) {
                return SpiResponse.builder().payload(Collections.emptyList()).build();
            }
            Optional<List<ScaUserDataTO>> scaMethods = this.getScaMethods(sca);
            if (scaMethods.isPresent()) {
                BearerTokenTO bearerTokenTO = this.authorisationService.validateToken(sca.getBearerToken().getAccess_token());
                sca.setBearerToken(bearerTokenTO);
                List<SpiAuthenticationObject> authenticationObjects = this.scaMethodConverter.toSpiAuthenticationObjectList(scaMethods.get());
                aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)sca));
                return SpiResponse.builder().payload(authenticationObjects).build();
            }
            return this.getForZeroScaMethods(sca.getScaStatus());
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            log.error("Read available sca methods failed: consent ID {}, devMessage {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR_SCA_METHODS)).build();
        }
    }

    SpiResponse<List<SpiAuthenticationObject>> getForZeroScaMethods(ScaStatusTO status) {
        log.error("Process mismatch. Current SCA Status is {}", (Object)status);
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_METHOD_UNKNOWN_PROCESS_MISMATCH, new Object[0])).build();
    }

    protected Optional<List<ScaUserDataTO>> getScaMethods(R sca) {
        return Optional.ofNullable(sca.getScaMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        R sca = this.getSCAConsentResponse(aspspConsentDataProvider, true);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(sca.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
                ResponseEntity<R> selectMethodResponse = this.getSelectMethodResponse(authenticationMethodId, sca);
                SCAResponseTO authCodeResponse = (SCAResponseTO)selectMethodResponse.getBody();
                if (authCodeResponse != null && authCodeResponse.getBearerToken() == null) {
                    authCodeResponse.setBearerToken(sca.getBearerToken());
                }
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentDataProvider, authCodeResponse);
                return spiResponse;
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                log.error("Request authorisation code failed: consent ID {}, devMessage {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
                TppMessage errorMessage = new TppMessage(this.getMessageErrorCodeByStatus(feignException.status()), new Object[0]);
                SpiResponse spiResponse = SpiResponse.builder().error(errorMessage).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentDataProvider, (SCAResponseTO)sca);
    }

    @NotNull
    public SpiResponse<SpiAuthorisationDecoupledScaResponse> startScaDecoupled(@NotNull SpiContextData contextData, @NotNull String authorisationId, @Nullable String authenticationMethodId, @NotNull T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (authenticationMethodId == null) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SERVICE_NOT_SUPPORTED, new Object[0])).build();
        }
        SpiResponse<SpiAuthorizationCodeResult> response = this.requestAuthorisationCode(contextData, authenticationMethodId, businessObject, aspspConsentDataProvider);
        if (response.hasError()) {
            return SpiResponse.builder().error(response.getErrors()).build();
        }
        String psuMessage = this.generatePsuMessage(contextData, authorisationId, aspspConsentDataProvider, response);
        return SpiResponse.builder().payload((Object)new SpiAuthorisationDecoupledScaResponse(psuMessage)).build();
    }

    protected abstract ResponseEntity<R> getSelectMethodResponse(@NotNull String var1, R var2);

    protected abstract R getSCAConsentResponse(@NotNull SpiAspspConsentDataProvider var1, boolean var2);

    protected abstract String getBusinessObjectId(T var1);

    protected abstract OpTypeTO getOtpType();

    protected abstract TppMessage getAuthorisePsuFailureMessage(T var1);

    protected abstract SCAResponseTO initiateBusinessObject(T var1, byte[] var2);

    protected abstract R mapToScaResponse(T var1, byte[] var2, R var3) throws IOException;

    protected String generatePsuMessage(@NotNull SpiContextData contextData, @NotNull String authorisationId, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, SpiResponse<SpiAuthorizationCodeResult> response) {
        return DECOUPLED_PSU_MESSAGE;
    }

    protected boolean validateStatuses(T businessObject, R sca) {
        return false;
    }

    protected SpiResponse<SpiAuthorisationStatus> onSuccessfulAuthorisation(T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, SpiResponse<SpiAuthorisationStatus> authorisePsu, R scaBusinessObjectResponse) {
        if (EnumSet.of(ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.PSUIDENTIFIED).contains(scaBusinessObjectResponse.getScaStatus())) {
            SCAResponseTO aisConsentResponse;
            try {
                aisConsentResponse = this.initiateBusinessObject(businessObject, aspspConsentDataProvider.loadAspspConsentData());
            }
            catch (FeignException feignException) {
                return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID)).build();
            }
            if (aisConsentResponse == null) {
                return SpiResponse.builder().error(this.getAuthorisePsuFailureMessage(businessObject)).build();
            }
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(aisConsentResponse));
            String scaStatusName = aisConsentResponse.getScaStatus().name();
            log.info("SCA status is: {}", (Object)scaStatusName);
        }
        return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
    }

    private MessageErrorCode getMessageErrorCodeByStatus(int status) {
        if (status == 501) {
            return MessageErrorCode.SCA_METHOD_UNKNOWN;
        }
        if (Arrays.asList(400, 401, 403).contains(status)) {
            return MessageErrorCode.FORMAT_ERROR;
        }
        if (status == 404) {
            return MessageErrorCode.PSU_CREDENTIALS_INVALID;
        }
        return MessageErrorCode.INTERNAL_SERVER_ERROR;
    }

    public AbstractAuthorisationSpi(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, FeignExceptionReader feignExceptionReader) {
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.authorisationService = authorisationService;
        this.scaMethodConverter = scaMethodConverter;
        this.feignExceptionReader = feignExceptionReader;
    }
}

