/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FeignExceptionReader {
    private static final Logger log = LoggerFactory.getLogger(FeignExceptionReader.class);
    private final ObjectMapper objectMapper;

    public String getErrorMessage(FeignException feignException) {
        return Optional.ofNullable(feignException.content()).map(this::readTree).map(this::getDevMessage).map(JsonNode::asText).orElse(null);
    }

    private JsonNode getDevMessage(JsonNode jsonNode) {
        return jsonNode.get("devMessage");
    }

    private JsonNode readTree(byte[] content) {
        try {
            return this.objectMapper.readTree(content);
        }
        catch (IOException ex) {
            log.error("Could not parse Error Message from Bank!");
            return null;
        }
    }

    public FeignExceptionReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

