/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.AddressMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ChallengeDataMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapperHelper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PurposeCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.psd2.xs2a.core.pis.FrequencyCode;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.PurposeCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiRemittance;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring", uses={LedgersSpiAccountMapper.class, ChallengeDataMapper.class, AddressMapper.class}, imports={LedgersSpiPaymentMapperHelper.class, ScaMethodUtils.class})
public abstract class LedgersSpiPaymentMapper {
    private LedgersSpiAccountMapper accountMapper = (LedgersSpiAccountMapper)Mappers.getMapper(LedgersSpiAccountMapper.class);

    public SpiSinglePayment toSpiSinglePayment(SinglePaymentTO payment) {
        SpiSinglePayment spiPayment = new SpiSinglePayment(payment.getPaymentProduct().getValue());
        spiPayment.setPaymentId(payment.getPaymentId());
        spiPayment.setEndToEndIdentification(payment.getEndToEndIdentification());
        spiPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(payment.getDebtorAccount()));
        spiPayment.setInstructedAmount(this.accountMapper.toSpiAmount(payment.getInstructedAmount()));
        spiPayment.setCreditorAccount(this.accountMapper.toSpiAccountReference(payment.getCreditorAccount()));
        spiPayment.setCreditorAgent(payment.getCreditorAgent());
        spiPayment.setCreditorName(payment.getCreditorName());
        spiPayment.setCreditorAddress(this.toSpiAddress(payment.getCreditorAddress()));
        spiPayment.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        spiPayment.setPaymentStatus(TransactionStatus.valueOf((String)payment.getPaymentStatus().name()));
        spiPayment.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        spiPayment.setRequestedExecutionTime((OffsetDateTime)Optional.ofNullable(payment.getRequestedExecutionDate()).map(d -> this.toDateTime((LocalDate)d, payment.getRequestedExecutionTime())).orElse(null));
        return spiPayment;
    }

    public SpiPeriodicPayment mapToSpiPeriodicPayment(PeriodicPaymentTO payment) {
        SpiPeriodicPayment spiPayment = new SpiPeriodicPayment(payment.getPaymentProduct().getValue());
        spiPayment.setPaymentId(payment.getPaymentId());
        spiPayment.setEndToEndIdentification(payment.getEndToEndIdentification());
        spiPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(payment.getDebtorAccount()));
        spiPayment.setInstructedAmount(this.accountMapper.toSpiAmount(payment.getInstructedAmount()));
        spiPayment.setCreditorAccount(this.accountMapper.toSpiAccountReference(payment.getCreditorAccount()));
        spiPayment.setCreditorAgent(payment.getCreditorAgent());
        spiPayment.setCreditorName(payment.getCreditorName());
        spiPayment.setCreditorAddress(this.toSpiAddress(payment.getCreditorAddress()));
        spiPayment.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        spiPayment.setPaymentStatus(TransactionStatus.valueOf((String)payment.getPaymentStatus().name()));
        spiPayment.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        spiPayment.setRequestedExecutionTime(this.toDateTime(payment.getRequestedExecutionDate(), payment.getRequestedExecutionTime()));
        spiPayment.setStartDate(payment.getStartDate());
        spiPayment.setEndDate(payment.getEndDate());
        Optional pisExecutionRule = PisExecutionRule.getByValue((String)payment.getExecutionRule());
        pisExecutionRule.ifPresent(arg_0 -> ((SpiPeriodicPayment)spiPayment).setExecutionRule(arg_0));
        spiPayment.setFrequency(FrequencyCode.valueOf((String)payment.getFrequency().name()));
        spiPayment.setDayOfExecution(PisDayOfExecution.fromValue((String)String.valueOf(payment.getDayOfExecution())));
        return spiPayment;
    }

    public SpiBulkPayment mapToSpiBulkPayment(BulkPaymentTO payment) {
        return Optional.ofNullable(payment).map(p -> {
            SpiBulkPayment spiBulkPayment = new SpiBulkPayment();
            spiBulkPayment.setPaymentId(p.getPaymentId());
            spiBulkPayment.setBatchBookingPreferred(p.getBatchBookingPreferred());
            spiBulkPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(p.getDebtorAccount()));
            spiBulkPayment.setRequestedExecutionDate(p.getRequestedExecutionDate());
            spiBulkPayment.setPaymentStatus(TransactionStatus.valueOf((String)p.getPaymentStatus().name()));
            spiBulkPayment.setPayments(this.toSpiSinglePaymentsList(p.getPayments()));
            spiBulkPayment.setPaymentProduct(p.getPaymentProduct().getValue());
            return spiBulkPayment;
        }).orElse(null);
    }

    public abstract List<SpiSinglePayment> toSpiSinglePaymentsList(List<SinglePaymentTO> var1);

    public OffsetDateTime toDateTime(LocalDate date, LocalTime time) {
        return Optional.ofNullable(date).map(d -> LocalDateTime.of(d, Optional.ofNullable(time).orElse(LocalTime.ofSecondOfDay(0L))).atOffset(ZoneOffset.UTC)).orElse(null);
    }

    private SpiAddress toSpiAddress(AddressTO address) {
        return Optional.ofNullable(address).map(a -> new SpiAddress(a.getStreet(), a.getBuildingNumber(), a.getCity(), a.getPostalCode(), a.getCountry())).orElse(null);
    }

    public PaymentTO mapToPaymentTO(SpiSinglePayment spiSinglePayment) {
        return Optional.ofNullable(spiSinglePayment).map(payment -> {
            PaymentTO paymentTO = new PaymentTO();
            paymentTO.setPaymentId(payment.getPaymentId());
            paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)payment.getPaymentType().name()));
            paymentTO.setPaymentProduct(payment.getPaymentProduct());
            paymentTO.setDebtorAccount(this.mapToAccountReferenceTO(payment.getDebtorAccount()));
            paymentTO.setDebtorName(payment.getUltimateDebtor());
            paymentTO.setTargets(Collections.singletonList(this.mapToPaymentTargetTO((SpiSinglePayment)payment)));
            return paymentTO;
        }).orElse(null);
    }

    public PaymentTO mapToPaymentTO(SpiPeriodicPayment spiPeriodicPayment) {
        return Optional.ofNullable(spiPeriodicPayment).map(payment -> {
            PaymentTO paymentTO = new PaymentTO();
            paymentTO.setPaymentId(payment.getPaymentId());
            paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)payment.getPaymentType().name()));
            paymentTO.setPaymentProduct(payment.getPaymentProduct());
            paymentTO.setDebtorAccount(this.mapToAccountReferenceTO(payment.getDebtorAccount()));
            paymentTO.setStartDate(payment.getStartDate());
            paymentTO.setEndDate(payment.getEndDate());
            paymentTO.setExecutionRule((String)Optional.ofNullable(payment.getExecutionRule()).map(PisExecutionRule::toString).orElse(null));
            paymentTO.setFrequency(this.mapToFrequencyCodeTO(payment.getFrequency()));
            paymentTO.setDayOfExecution(Integer.valueOf(payment.getDayOfExecution().toString()));
            paymentTO.setDebtorName(payment.getUltimateDebtor());
            paymentTO.setTargets(Collections.singletonList(this.mapToPaymentTargetTO((SpiSinglePayment)payment)));
            return paymentTO;
        }).orElse(null);
    }

    public PaymentTO mapToPaymentTO(SpiBulkPayment spiBulkPayment) {
        return Optional.ofNullable(spiBulkPayment).map(payment -> {
            PaymentTO paymentTO = new PaymentTO();
            paymentTO.setPaymentId(payment.getPaymentId());
            paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)payment.getPaymentType().name()));
            paymentTO.setPaymentProduct(payment.getPaymentProduct());
            paymentTO.setDebtorAccount(this.mapToAccountReferenceTO(payment.getDebtorAccount()));
            paymentTO.setBatchBookingPreferred(payment.getBatchBookingPreferred());
            paymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
            paymentTO.setRequestedExecutionTime((LocalTime)Optional.ofNullable(payment.getRequestedExecutionTime()).map(OffsetDateTime::toLocalTime).orElse(null));
            paymentTO.setTargets(payment.getPayments().stream().map(this::mapToPaymentTargetTO).collect(Collectors.toList()));
            return paymentTO;
        }).orElse(null);
    }

    private PaymentTargetTO mapToPaymentTargetTO(SpiSinglePayment spiSinglePayment) {
        if (spiSinglePayment == null) {
            return null;
        }
        PaymentTargetTO paymentTargetTO = new PaymentTargetTO();
        paymentTargetTO.setPaymentId(spiSinglePayment.getPaymentId());
        paymentTargetTO.setEndToEndIdentification(spiSinglePayment.getEndToEndIdentification());
        paymentTargetTO.setInstructedAmount(this.mapToAmountTO(spiSinglePayment.getInstructedAmount()));
        paymentTargetTO.setCreditorAccount(this.mapToAccountReferenceTO(spiSinglePayment.getCreditorAccount()));
        paymentTargetTO.setCreditorAgent(spiSinglePayment.getCreditorAgent());
        paymentTargetTO.setCreditorName(spiSinglePayment.getCreditorName());
        paymentTargetTO.setCreditorAddress(this.mapToAddressTO(spiSinglePayment.getCreditorAddress()));
        paymentTargetTO.setPurposeCode(this.mapToPurposeCodeTO(spiSinglePayment.getPurposeCode()));
        paymentTargetTO.setRemittanceInformationUnstructured(spiSinglePayment.getRemittanceInformationUnstructured());
        paymentTargetTO.setRemittanceInformationStructured(this.mapToRemittanceInformationStructuredTO(spiSinglePayment.getRemittanceInformationStructured()));
        return paymentTargetTO;
    }

    private RemittanceInformationStructuredTO mapToRemittanceInformationStructuredTO(SpiRemittance spiRemittance) {
        if (spiRemittance == null) {
            return null;
        }
        RemittanceInformationStructuredTO remittanceInformationStructuredTO = new RemittanceInformationStructuredTO();
        remittanceInformationStructuredTO.setReference(spiRemittance.getReference());
        remittanceInformationStructuredTO.setReferenceType(spiRemittance.getReferenceType());
        remittanceInformationStructuredTO.setReferenceIssuer(spiRemittance.getReferenceIssuer());
        return remittanceInformationStructuredTO;
    }

    private PurposeCodeTO mapToPurposeCodeTO(PurposeCode purposeCode) {
        return Optional.ofNullable(purposeCode).map(Enum::name).map(PurposeCodeTO::valueOf).orElse(null);
    }

    private AddressTO mapToAddressTO(SpiAddress address) {
        if (address == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(address.getStreetName());
        addressTO.setBuildingNumber(address.getBuildingNumber());
        addressTO.setCity(address.getTownName());
        addressTO.setPostalCode(address.getPostCode());
        addressTO.setCountry(address.getCountry());
        return addressTO;
    }

    private AmountTO mapToAmountTO(SpiAmount amount) {
        if (amount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(amount.getCurrency());
        amountTO.setAmount(amount.getAmount());
        return amountTO;
    }

    private AccountReferenceTO mapToAccountReferenceTO(SpiAccountReference spiAccountReference) {
        if (spiAccountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(spiAccountReference.getIban());
        accountReferenceTO.setBban(spiAccountReference.getBban());
        accountReferenceTO.setPan(spiAccountReference.getPan());
        accountReferenceTO.setMaskedPan(spiAccountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(spiAccountReference.getMsisdn());
        accountReferenceTO.setCurrency(spiAccountReference.getCurrency());
        return accountReferenceTO;
    }

    private FrequencyCodeTO mapToFrequencyCodeTO(FrequencyCode frequencyCode) {
        return Optional.ofNullable(frequencyCode).map(Enum::name).map(FrequencyCodeTO::valueOf).orElse(null);
    }
}

