package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-02-14T10:01:33+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class AisConsentMapperImpl extends AisConsentMapper {

    @Override
    public AisConsentTO mapToAisConsent(SpiAccountConsent consent) {
        if ( consent == null ) {
            return null;
        }

        AisConsentTO aisConsentTO = new AisConsentTO();

        aisConsentTO.setTppId( consentTppInfoAuthorisationNumber( consent ) );
        aisConsentTO.setId( consent.getId() );
        aisConsentTO.setFrequencyPerDay( consent.getFrequencyPerDay() );
        aisConsentTO.setAccess( spiAccountAccessToAisAccountAccessInfoTO( consent.getAccess() ) );
        aisConsentTO.setValidUntil( consent.getValidUntil() );
        aisConsentTO.setRecurringIndicator( consent.isRecurringIndicator() );

        return aisConsentTO;
    }

    private String consentTppInfoAuthorisationNumber(SpiAccountConsent spiAccountConsent) {
        if ( spiAccountConsent == null ) {
            return null;
        }
        TppInfo tppInfo = spiAccountConsent.getTppInfo();
        if ( tppInfo == null ) {
            return null;
        }
        String authorisationNumber = tppInfo.getAuthorisationNumber();
        if ( authorisationNumber == null ) {
            return null;
        }
        return authorisationNumber;
    }

    protected List<String> spiAccountReferenceListToStringList(List<SpiAccountReference> list) {
        if ( list == null ) {
            return null;
        }

        List<String> list1 = new ArrayList<String>( list.size() );
        for ( SpiAccountReference spiAccountReference : list ) {
            list1.add( mapSpiAccountReferenceToString( spiAccountReference ) );
        }

        return list1;
    }

    protected AisAccountAccessTypeTO accountAccessTypeToAisAccountAccessTypeTO(AccountAccessType accountAccessType) {
        if ( accountAccessType == null ) {
            return null;
        }

        AisAccountAccessTypeTO aisAccountAccessTypeTO;

        switch ( accountAccessType ) {
            case ALL_ACCOUNTS: aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountAccessType );
        }

        return aisAccountAccessTypeTO;
    }

    protected AisAccountAccessInfoTO spiAccountAccessToAisAccountAccessInfoTO(SpiAccountAccess spiAccountAccess) {
        if ( spiAccountAccess == null ) {
            return null;
        }

        AisAccountAccessInfoTO aisAccountAccessInfoTO = new AisAccountAccessInfoTO();

        aisAccountAccessInfoTO.setAccounts( spiAccountReferenceListToStringList( spiAccountAccess.getAccounts() ) );
        aisAccountAccessInfoTO.setBalances( spiAccountReferenceListToStringList( spiAccountAccess.getBalances() ) );
        aisAccountAccessInfoTO.setTransactions( spiAccountReferenceListToStringList( spiAccountAccess.getTransactions() ) );
        aisAccountAccessInfoTO.setAvailableAccounts( accountAccessTypeToAisAccountAccessTypeTO( spiAccountAccess.getAvailableAccounts() ) );
        aisAccountAccessInfoTO.setAllPsd2( accountAccessTypeToAisAccountAccessTypeTO( spiAccountAccess.getAllPsd2() ) );

        return aisAccountAccessInfoTO;
    }
}
