/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.GeneralAuthorisationService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.PaymentAuthorisationSpiImpl;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentCancellationSpiImpl
implements PaymentCancellationSpi {
    private static final Logger logger = LoggerFactory.getLogger(PaymentCancellationSpiImpl.class);
    private static final String PAYMENT_CANCELLATION_EXCEPTION_MESSAGE = "Couldn't execute payment cancellation.";
    private static final String DECOUPLED_PSU_MESSAGE = "Please check your app to continue...";
    private static final String DECOUPLED_NOT_SUPPORTED_MESSAGE = "Service is not supported";
    private final PaymentRestClient paymentRestClient;
    private final TokenStorageService tokenStorageService;
    private final ScaMethodConverter scaMethodConverter;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final GeneralAuthorisationService authorisationService;
    private final PaymentAuthorisationSpiImpl paymentAuthorisation;
    private final FeignExceptionReader feignExceptionReader;

    public PaymentCancellationSpiImpl(PaymentRestClient ledgersRestClient, TokenStorageService tokenStorageService, ScaMethodConverter scaMethodConverter, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, PaymentAuthorisationSpiImpl paymentAuthorisation, FeignExceptionReader feignExceptionReader) {
        this.paymentRestClient = ledgersRestClient;
        this.tokenStorageService = tokenStorageService;
        this.scaMethodConverter = scaMethodConverter;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.authorisationService = authorisationService;
        this.paymentAuthorisation = paymentAuthorisation;
        this.feignExceptionReader = feignExceptionReader;
    }

    @NotNull
    public SpiResponse<SpiPaymentCancellationResponse> initiatePaymentCancellation(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SpiPaymentCancellationResponse response = new SpiPaymentCancellationResponse();
        boolean cancellationMandated = payment.getPaymentStatus() != TransactionStatus.RCVD;
        response.setCancellationAuthorisationMandated(cancellationMandated);
        response.setTransactionStatus(payment.getPaymentStatus());
        return SpiResponse.builder().payload((Object)response).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> cancelPaymentWithoutSca(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (payment.getPaymentStatus() == TransactionStatus.RCVD) {
            return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
        }
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
        if (sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            try {
                this.paymentRestClient.initiatePmtCancellation(payment.getPaymentId());
                return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                logger.error("Cancel payment without sca failed: payment ID {}, devMessage {}", (Object)payment.getPaymentId(), (Object)devMessage);
                return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR, devMessage, PAYMENT_CANCELLATION_EXCEPTION_MESSAGE)).build();
            }
        }
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.CANCELLATION_INVALID, "Couldn't execute payment cancellation", new Object[0])).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisationAndCancelPayment(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity response = this.paymentRestClient.authorizeCancelPayment(sca.getPaymentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            return response.getStatusCode() == HttpStatus.OK ? SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build() : SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED, "Couldn't authorise payment cancellation", new Object[0])).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Verify sca authorisation and cancel payment failed: payment ID {}, devMessage {}", (Object)payment.getPaymentId(), (Object)devMessage);
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, "Couldn't execute authorisation payment cancellation", new Object[0])).build();
        }
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData contextData, @NotNull SpiPsuData psuData, String password, SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO originalResponse = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class, false);
        SpiResponse<SpiAuthorisationStatus> authorisePsu = this.authorisationService.authorisePsuForConsent(psuData, password, businessObject.getPaymentId(), originalResponse, OpTypeTO.CANCEL_PAYMENT, aspspConsentDataProvider);
        if (!authorisePsu.isSuccessful()) {
            return authorisePsu;
        }
        try {
            SCAPaymentResponseTO scaPaymentResponse = this.paymentAuthorisation.toPaymentConsent(businessObject, aspspConsentDataProvider, originalResponse);
            aspspConsentDataProvider.updateAspspConsentData(this.tokenStorageService.toBytes((SCAResponseTO)scaPaymentResponse));
            return SpiResponse.builder().payload((Object)SpiAuthorisationStatus.SUCCESS).build();
        }
        catch (IOException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED, "Couldn't authorise payment cancellation", new Object[0])).build();
        }
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData contextData, SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
        if (businessObject.getPaymentStatus() == TransactionStatus.RCVD || sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
            return SpiResponse.builder().payload(Collections.emptyList()).build();
        }
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        ResponseEntity cancelSCA = this.paymentRestClient.getCancelSCA(sca.getPaymentId(), sca.getAuthorisationId());
        List authenticationObjectList = Optional.ofNullable(cancelSCA.getBody()).map(SCAResponseTO::getScaMethods).map(this.scaMethodConverter::toSpiAuthenticationObjectList).orElseGet(Collections::emptyList);
        return authenticationObjectList.isEmpty() ? SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED, "Getting SCA methods failed", new Object[0])).build() : SpiResponse.builder().payload((Object)authenticationObjectList).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO response = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(response.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
                logger.info("Request to generate SCA {}", (Object)response.getPaymentId());
                ResponseEntity selectMethodResponse = this.paymentRestClient.selecCancelPaymentSCAtMethod(response.getPaymentId(), response.getAuthorisationId(), authenticationMethodId);
                logger.info("SCA was send, operationId is {}", (Object)response.getPaymentId());
                response = (SCAPaymentResponseTO)selectMethodResponse.getBody();
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentDataProvider, (SCAResponseTO)response);
                return spiResponse;
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                logger.error("Request authorisation code failed: payment ID {}, authentication method ID {}, devMessage {}", new Object[]{businessObject.getPaymentId(), authenticationMethodId, devMessage});
                SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage, PAYMENT_CANCELLATION_EXCEPTION_MESSAGE)).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentDataProvider, (SCAResponseTO)response);
    }

    @NotNull
    public SpiResponse<SpiAuthorisationDecoupledScaResponse> startScaDecoupled(@NotNull SpiContextData contextData, @NotNull String authorisationId, @Nullable String authenticationMethodId, @NotNull SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (authenticationMethodId == null) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SERVICE_NOT_SUPPORTED, DECOUPLED_NOT_SUPPORTED_MESSAGE, new Object[0])).build();
        }
        SpiResponse<SpiAuthorizationCodeResult> response = this.requestAuthorisationCode(contextData, authenticationMethodId, businessObject, aspspConsentDataProvider);
        return response.hasError() ? SpiResponse.builder().error(response.getErrors()).build() : SpiResponse.builder().payload((Object)new SpiAuthorisationDecoupledScaResponse(DECOUPLED_PSU_MESSAGE)).build();
    }
}

