/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.AisConsentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaLoginMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.GeneralAuthorisationService;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.ConsentRestClient;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import feign.FeignException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AisConsentSpiImpl
implements AisConsentSpi {
    private static final Logger logger = LoggerFactory.getLogger(AisConsentSpiImpl.class);
    private static final String USER_LOGIN = "{userLogin}";
    private static final String CONSENT_ID = "{consentId}";
    private static final String AUTH_ID = "{authorizationId}";
    private static final String TAN = "{tan}";
    private static final String DECOUPLED_USR_MSG = "Please check your app to continue... %s";
    private static final String SCA_STATUS_LOG = "SCA status is {}";
    private static final String DECOUPLED_NOT_SUPPORTED_MESSAGE = "Service is not supported";
    private final ConsentRestClient consentRestClient;
    private final TokenStorageService tokenStorageService;
    private final AisConsentMapper aisConsentMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final GeneralAuthorisationService authorisationService;
    private final ScaMethodConverter scaMethodConverter;
    private final ScaLoginMapper scaLoginMapper;
    private final FeignExceptionReader feignExceptionReader;
    @Value(value="${online-banking.url}")
    private String onlineBankingUrl;

    public AisConsentSpiImpl(ConsentRestClient consentRestClient, TokenStorageService tokenStorageService, AisConsentMapper aisConsentMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, ScaLoginMapper scaLoginMapper, FeignExceptionReader feignExceptionReader) {
        this.consentRestClient = consentRestClient;
        this.tokenStorageService = tokenStorageService;
        this.aisConsentMapper = aisConsentMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.authorisationService = authorisationService;
        this.scaMethodConverter = scaMethodConverter;
        this.scaLoginMapper = scaLoginMapper;
        this.feignExceptionReader = feignExceptionReader;
    }

    public SpiResponse<SpiInitiateAisConsentResponse> initiateAisConsent(@NotNull SpiContextData contextData, SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO aisConsentResponse;
        byte[] initialAspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        if (ArrayUtils.isEmpty((byte[])initialAspspConsentData)) {
            return this.firstCallInstantiatingConsent(accountConsent, aspspConsentDataProvider, new SpiInitiateAisConsentResponse());
        }
        try {
            aisConsentResponse = this.initiateConsentInternal(accountConsent, initialAspspConsentData);
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Initiate AIS consent failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR, "Addressed account is unknown to the ASPSP or not associated to the PSU.")).build();
        }
        logger.info(SCA_STATUS_LOG, (Object)aisConsentResponse.getScaStatus());
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)aisConsentResponse));
        return SpiResponse.builder().payload((Object)new SpiInitiateAisConsentResponse(accountConsent.getAccess(), false, "")).build();
    }

    public SpiResponse<SpiResponse.VoidResponse> revokeAisConsent(@NotNull SpiContextData contextData, SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class, false);
            sca.setScaStatus(ScaStatusTO.FINALISED);
            sca.setStatusDate(LocalDateTime.now());
            sca.setBearerToken(new BearerTokenTO());
            String scaStatusName = sca.getScaStatus().name();
            logger.info(SCA_STATUS_LOG, (Object)scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)sca));
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Revoke AIS consent failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, feignException.getMessage())).build();
        }
        return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiVerifyScaAuthorisationResponse> verifyScaAuthorisation(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizeConsentResponse = this.consentRestClient.authorizeConsent(sca.getConsentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            SCAConsentResponseTO consentResponse = (SCAConsentResponseTO)authorizeConsentResponse.getBody();
            String scaStatusName = sca.getScaStatus().name();
            logger.info(SCA_STATUS_LOG, (Object)scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)consentResponse, !consentResponse.isPartiallyAuthorised()));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(this.getConsentStatus(consentResponse))).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Verify sca authorisation failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage, "authorisation PSU for consent was failed")).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData contextData, @NotNull SpiPsuData psuLoginData, String password, SpiAccountConsent aisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO scaConsentResponse;
        SCAConsentResponseTO originalResponse;
        try {
            originalResponse = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class, false);
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Read aspspConsentData in authorise PSU failed: consent ID {}, devMessage {}", (Object)aisConsent.getId(), (Object)devMessage);
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.TOKEN_UNKNOWN, "Missing credentials. Expecting a bearer token in the consent data object.", new Object[0])).build();
        }
        SpiResponse<SpiAuthorisationStatus> authorisePsu = this.authorisationService.authorisePsuForConsent(psuLoginData, password, aisConsent.getId(), originalResponse, OpTypeTO.CONSENT, aspspConsentDataProvider);
        if (!authorisePsu.isSuccessful()) {
            String spiErrorMessage = ((TppMessage)authorisePsu.getErrors().get(0)).getMessageText();
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, (String)StringUtils.defaultIfBlank((CharSequence)spiErrorMessage, (CharSequence)"authorisation PSU for consent was failed"), new Object[0])).build();
        }
        try {
            scaConsentResponse = this.mapToScaConsentResponse(aisConsent, aspspConsentDataProvider.loadAspspConsentData());
        }
        catch (IOException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Unknown response type", new Object[0])).build();
        }
        if (EnumSet.of(ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.PSUIDENTIFIED).contains(scaConsentResponse.getScaStatus())) {
            SCAConsentResponseTO aisConsentResponse;
            try {
                aisConsentResponse = this.initiateConsentInternal(aisConsent, aspspConsentDataProvider.loadAspspConsentData());
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                logger.error("Initiate consent internal in authorise PSU failed: consent ID {}, devMessage {}", (Object)aisConsent.getId(), (Object)devMessage);
                return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR, "Addressed account is unknown to the ASPSP or not associated to the PSU.")).build();
            }
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)aisConsentResponse));
            return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
        }
        return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData contextData, SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
            if (sca.getScaMethods() != null) {
                BearerTokenTO bearerTokenTO = this.authorisationService.validateToken(sca.getBearerToken().getAccess_token());
                sca.setBearerToken(bearerTokenTO);
                List scaMethods = sca.getScaMethods();
                List<SpiAuthenticationObject> authenticationObjects = this.scaMethodConverter.toSpiAuthenticationObjectList(scaMethods);
                aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)sca));
                return SpiResponse.builder().payload(authenticationObjects).build();
            }
            logger.error("Process mismatch. Current SCA Status is {}", (Object)sca.getScaStatus());
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_METHOD_UNKNOWN, "Process mismatch. PSU does not have any SCA method", new Object[0])).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Read available sca methods failed: consent ID {}, devMessage {}", (Object)businessObject.getId(), (Object)devMessage);
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Getting SCA methods failed", new Object[0])).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(sca.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
                logger.info("Request to generate SCA {}", (Object)sca.getConsentId());
                ResponseEntity selectMethodResponse = this.consentRestClient.selectMethod(sca.getConsentId(), sca.getAuthorisationId(), authenticationMethodId);
                logger.info("SCA was send, operationId is {}", (Object)sca.getConsentId());
                SCAConsentResponseTO authCodeResponse = (SCAConsentResponseTO)selectMethodResponse.getBody();
                if (authCodeResponse != null && authCodeResponse.getBearerToken() == null) {
                    authCodeResponse.setBearerToken(sca.getBearerToken());
                }
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentDataProvider, (SCAResponseTO)authCodeResponse);
                return spiResponse;
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                logger.error("Request authorisation code failed: consent ID {}, devMessage {}", (Object)businessObject.getId(), (Object)devMessage);
                TppMessage errorMessage = new TppMessage(this.getMessageErrorCodeByStatus(feignException.status()), (String)StringUtils.defaultIfBlank((CharSequence)devMessage, (CharSequence)"No message from Bank available."), new Object[0]);
                SpiResponse spiResponse = SpiResponse.builder().error(errorMessage).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentDataProvider, (SCAResponseTO)sca);
    }

    @NotNull
    public SpiResponse<SpiAuthorisationDecoupledScaResponse> startScaDecoupled(@NotNull SpiContextData contextData, @NotNull String authorisationId, @Nullable String authenticationMethodId, @NotNull SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (authenticationMethodId == null) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SERVICE_NOT_SUPPORTED, DECOUPLED_NOT_SUPPORTED_MESSAGE, new Object[0])).build();
        }
        SpiResponse<SpiAuthorizationCodeResult> response = this.requestAuthorisationCode(contextData, authenticationMethodId, businessObject, aspspConsentDataProvider);
        String psuMessage = this.generatePsuMessage(contextData, authorisationId, aspspConsentDataProvider, response);
        return response.hasError() ? SpiResponse.builder().error(response.getErrors()).build() : SpiResponse.builder().payload((Object)new SpiAuthorisationDecoupledScaResponse(psuMessage)).build();
    }

    ConsentStatus getConsentStatus(SCAConsentResponseTO consentResponse) {
        if (consentResponse != null && consentResponse.isMultilevelScaRequired() && consentResponse.isPartiallyAuthorised() && ScaStatusTO.FINALISED.equals((Object)consentResponse.getScaStatus())) {
            return ConsentStatus.PARTIALLY_AUTHORISED;
        }
        return ConsentStatus.VALID;
    }

    private String generatePsuMessage(@NotNull SpiContextData contextData, @NotNull String authorisationId, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, SpiResponse<SpiAuthorizationCodeResult> response) {
        List<String> challengeDataParts = Arrays.asList(((SpiAuthorizationCodeResult)response.getPayload()).getChallengeData().getAdditionalInformation().split(" "));
        int indexOfTan = challengeDataParts.indexOf("is") + 1;
        String encryptedConsentId = "";
        try {
            encryptedConsentId = (String)FieldUtils.readField((Object)aspspConsentDataProvider, (String)"encryptedConsentId", (boolean)true);
        }
        catch (IllegalAccessException e) {
            logger.error("could not read encrypted consent id");
        }
        String url = this.onlineBankingUrl.replace(USER_LOGIN, contextData.getPsuData().getPsuId()).replace(CONSENT_ID, encryptedConsentId).replace(AUTH_ID, authorisationId).replace(TAN, challengeDataParts.get(indexOfTan));
        return String.format(DECOUPLED_USR_MSG, url);
    }

    private <T extends SpiInitiateAisConsentResponse> SpiResponse<T> firstCallInstantiatingConsent(@NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, T responsePayload) {
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        response.setScaStatus(ScaStatusTO.STARTED);
        responsePayload.setAccountAccess(accountConsent.getAccess());
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response, false));
        return SpiResponse.builder().payload(responsePayload).build();
    }

    private SCAConsentResponseTO mapToScaConsentResponse(SpiAccountConsent businessObject, byte[] aspspConsentData) throws IOException {
        SCALoginResponseTO scaResponseTO = (SCALoginResponseTO)this.tokenStorageService.fromBytes(aspspConsentData, SCALoginResponseTO.class);
        SCAConsentResponseTO consentResponse = this.scaLoginMapper.toConsentResponse(scaResponseTO);
        consentResponse.setObjectType(SCAConsentResponseTO.class.getSimpleName());
        consentResponse.setConsentId(businessObject.getId());
        return consentResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCAConsentResponseTO initiateConsentInternal(SpiAccountConsent accountConsent, byte[] initialAspspConsentData) throws FeignException {
        try {
            SCAResponseTO sca = this.consentDataService.response(initialAspspConsentData);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            AisConsentTO aisConsent = this.aisConsentMapper.mapToAisConsent(accountConsent);
            ResponseEntity consentResponse = this.consentRestClient.startSCA(accountConsent.getId(), aisConsent);
            SCAConsentResponseTO response = (SCAConsentResponseTO)consentResponse.getBody();
            if (response != null && response.getBearerToken() == null) {
                response.setBearerToken(sca.getBearerToken());
            }
            SCAConsentResponseTO sCAConsentResponseTO = response;
            return sCAConsentResponseTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private MessageErrorCode getMessageErrorCodeByStatus(int status) {
        MessageErrorCode errorCode = MessageErrorCode.INTERNAL_SERVER_ERROR;
        if (status == 501) {
            errorCode = MessageErrorCode.SCA_METHOD_UNKNOWN;
        }
        if (Arrays.asList(400, 401, 403).contains(status)) {
            errorCode = MessageErrorCode.FORMAT_ERROR;
        }
        if (status == 404) {
            errorCode = MessageErrorCode.PSU_CREDENTIALS_INVALID;
        }
        return errorCode;
    }
}

