/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaLoginToPaymentResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.CmsPaymentStatusUpdateService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.GeneralAuthorisationService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentAuthorisationSpiImpl
implements PaymentAuthorisationSpi {
    private static final Logger logger = LoggerFactory.getLogger(PaymentAuthorisationSpiImpl.class);
    private final GeneralAuthorisationService authorisationService;
    private final TokenStorageService tokenStorageService;
    private final ScaMethodConverter scaMethodConverter;
    private final ScaLoginToPaymentResponseMapper scaLoginToPaymentResponseMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final PaymentRestClient paymentRestClient;
    private final SinglePaymentSpi singlePaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final CmsPaymentStatusUpdateService cmsPaymentStatusUpdateService;

    public PaymentAuthorisationSpiImpl(GeneralAuthorisationService authorisationService, TokenStorageService tokenStorageService, ScaMethodConverter scaMethodConverter, ScaLoginToPaymentResponseMapper scaLoginToPaymentResponseMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, PaymentRestClient paymentRestClient, SinglePaymentSpi singlePaymentSpi, BulkPaymentSpi bulkPaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, CmsPaymentStatusUpdateService cmsPaymentStatusUpdateService) {
        this.authorisationService = authorisationService;
        this.tokenStorageService = tokenStorageService;
        this.scaMethodConverter = scaMethodConverter;
        this.scaLoginToPaymentResponseMapper = scaLoginToPaymentResponseMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.paymentRestClient = paymentRestClient;
        this.singlePaymentSpi = singlePaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.cmsPaymentStatusUpdateService = cmsPaymentStatusUpdateService;
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData contextData, @NotNull SpiPsuData psuLoginData, String pin, SpiPayment spiPayment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO originalResponse = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class, false);
        SpiResponse<SpiAuthorisationStatus> authorisePsu = this.authorisationService.authorisePsuForConsent(psuLoginData, pin, originalResponse.getPaymentId(), originalResponse, OpTypeTO.PAYMENT, aspspConsentDataProvider);
        if (!authorisePsu.isSuccessful()) {
            return authorisePsu;
        }
        try {
            SCAPaymentResponseTO scaPaymentResponse = this.toPaymentConsent(spiPayment, aspspConsentDataProvider, originalResponse);
            this.cmsPaymentStatusUpdateService.updatePaymentStatus(spiPayment.getPaymentId(), aspspConsentDataProvider);
            aspspConsentDataProvider.updateAspspConsentData(this.tokenStorageService.toBytes((SCAResponseTO)scaPaymentResponse));
            return this.initiatePmtOnExemptedIfRequired(contextData, spiPayment, authorisePsu, scaPaymentResponse, aspspConsentDataProvider);
        }
        catch (IOException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.TOKEN_UNKNOWN, "Getting PSU token was failed", new Object[0])).build();
        }
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData contextData, SpiPayment spiPayment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
        List<ScaUserDataTO> scaMethods = Optional.ofNullable(sca.getScaMethods()).orElse(Collections.emptyList());
        return SpiResponse.builder().payload(this.scaMethodConverter.toSpiAuthenticationObjectList(scaMethods)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull SpiPayment spiPayment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(sca.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
                logger.info("Request to generate SCA {}", (Object)sca.getPaymentId());
                ResponseEntity selectMethodResponse = this.paymentRestClient.selectMethod(sca.getPaymentId(), sca.getAuthorisationId(), authenticationMethodId);
                logger.info("SCA was send, operationId is {}", (Object)sca.getPaymentId());
                sca = (SCAPaymentResponseTO)selectMethodResponse.getBody();
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentDataProvider, (SCAResponseTO)sca);
                return spiResponse;
            }
            catch (FeignException e) {
                SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_METHOD_UNKNOWN, "Sending SCA via phone not implemented yet", new Object[0])).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentDataProvider, (SCAResponseTO)sca);
    }

    public SCAPaymentResponseTO toPaymentConsent(SpiPayment spiPayment, SpiAspspConsentDataProvider aspspConsentDataProvider, SCAPaymentResponseTO originalResponse) throws IOException {
        String paymentTypeString = Optional.ofNullable(spiPayment.getPaymentType()).orElseThrow(() -> new IOException("Missing payment type")).name();
        SCALoginResponseTO scaResponseTO = (SCALoginResponseTO)this.tokenStorageService.fromBytes(aspspConsentDataProvider.loadAspspConsentData(), SCALoginResponseTO.class);
        SCAPaymentResponseTO paymentResponse = this.scaLoginToPaymentResponseMapper.toPaymentResponse(scaResponseTO);
        paymentResponse.setObjectType(SCAPaymentResponseTO.class.getSimpleName());
        paymentResponse.setPaymentId(spiPayment.getPaymentId());
        paymentResponse.setPaymentType(PaymentTypeTO.valueOf((String)paymentTypeString));
        String paymentProduct2 = spiPayment.getPaymentProduct();
        if (paymentProduct2 != null || originalResponse == null || originalResponse.getPaymentProduct() == null) {
            throw new IOException("Missing payment product");
        }
        paymentProduct2 = originalResponse.getPaymentProduct().getValue();
        String pp = paymentProduct2;
        paymentResponse.setPaymentProduct((PaymentProductTO)PaymentProductTO.getByValue((String)paymentProduct2).orElseThrow(() -> new IOException(String.format("Unsupported payment product %s", pp))));
        return paymentResponse;
    }

    private SpiResponse<SpiAuthorisationStatus> initiatePmtOnExemptedIfRequired(@NotNull SpiContextData contextData, SpiPayment spiPayment, SpiResponse<SpiAuthorisationStatus> authorisePsu, SCAPaymentResponseTO scaPaymentResponse, SpiAspspConsentDataProvider paymentAspspConsentDataProvider) {
        if (EnumSet.of(ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.PSUIDENTIFIED).contains(scaPaymentResponse.getScaStatus())) {
            return this.initiatePaymentOnExemptedSCA(contextData, spiPayment, authorisePsu, paymentAspspConsentDataProvider);
        }
        return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
    }

    private SpiResponse<SpiAuthorisationStatus> initiatePaymentOnExemptedSCA(SpiContextData contextData, SpiPayment spiPayment, SpiResponse<SpiAuthorisationStatus> authorisePsu, SpiAspspConsentDataProvider paymentAspspConsentDataProvider) {
        PaymentType paymentType = spiPayment.getPaymentType();
        switch (paymentType) {
            case SINGLE: {
                this.singlePaymentSpi.initiatePayment(contextData, (SpiSinglePayment)spiPayment, paymentAspspConsentDataProvider);
                return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
            }
            case BULK: {
                this.bulkPaymentSpi.initiatePayment(contextData, (SpiBulkPayment)spiPayment, paymentAspspConsentDataProvider);
                return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
            }
            case PERIODIC: {
                this.periodicPaymentSpi.initiatePayment(contextData, (SpiPeriodicPayment)spiPayment, paymentAspspConsentDataProvider);
                return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
            }
        }
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PAYMENT_FAILED, String.format("Unknown payment type %s", paymentType.getValue()), new Object[0])).build();
    }
}

