/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import feign.Response;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class GeneralPaymentService {
    private static final Logger logger = LoggerFactory.getLogger(GeneralPaymentService.class);
    private final PaymentRestClient paymentRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;

    public GeneralPaymentService(PaymentRestClient ledgersRestClient, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService) {
        this.paymentRestClient = ledgersRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<TransactionStatus> getPaymentStatusById(@NotNull PaymentTypeTO paymentType, @NotNull String paymentId, @NotNull TransactionStatus spiTransactionStatus, @NotNull byte[] aspspConsentData) {
        if (!TransactionStatus.ACSP.equals((Object)spiTransactionStatus)) {
            return SpiResponse.builder().payload((Object)spiTransactionStatus).build();
        }
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Get payment status by id with type={}, and id={}", (Object)paymentType, (Object)paymentId);
            TransactionStatusTO response = (TransactionStatusTO)this.paymentRestClient.getPaymentStatusById(sca.getPaymentId()).getBody();
            TransactionStatus status = Optional.ofNullable(response).map(r -> TransactionStatus.valueOf((String)r.name())).orElseThrow(() -> FeignException.errorStatus((String)"Request failed, Response was 200, but body was empty!", (Response)Response.builder().status(400).build()));
            logger.info("The status was:{}", (Object)status);
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)status).build();
            return spiResponse;
        }
        catch (FeignException e) {
            SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Couldn't get payment status by ID", new Object[0])).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndExecutePayment(@NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizePaymentResponse = this.paymentRestClient.authorizePayment(sca.getPaymentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            SCAPaymentResponseTO consentResponse = (SCAPaymentResponseTO)authorizePaymentResponse.getBody();
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)consentResponse));
            String scaStatus = Optional.ofNullable(consentResponse).map(SCAResponseTO::getScaStatus).map(Enum::name).orElse(null);
            logger.info("SCA status is {}", (Object)scaStatus);
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)this.spiPaymentExecutionResponse(consentResponse.getTransactionStatus())).build();
            return spiResponse;
        }
        catch (Exception e) {
            SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Couldn't execute payment", new Object[0])).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    <T extends SpiPaymentInitiationResponse> SpiResponse<T> firstCallInstantiatingPayment(@NotNull PaymentTypeTO paymentType, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, T responsePayload) {
        String paymentId = StringUtils.isNotBlank((CharSequence)payment.getPaymentId()) ? payment.getPaymentId() : Ids.id();
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setPaymentId(paymentId);
        response.setTransactionStatus(TransactionStatusTO.RCVD);
        response.setPaymentProduct((PaymentProductTO)PaymentProductTO.getByValue((String)payment.getPaymentProduct()).orElse(null));
        response.setPaymentType(paymentType);
        responsePayload.setPaymentId(paymentId);
        responsePayload.setTransactionStatus(TransactionStatus.valueOf((String)response.getTransactionStatus().name()));
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response, false));
        return SpiResponse.builder().payload(responsePayload).build();
    }

    @NotNull
    SpiResponse<SpiPaymentExecutionResponse> executePaymentWithoutSca(@NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAPaymentResponseTO response = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAPaymentResponseTO.class);
            ScaStatusTO scaStatus = response.getScaStatus();
            String scaStatusName = scaStatus.name();
            if (ScaStatusTO.EXEMPTED.equals((Object)scaStatus) || ScaStatusTO.FINALISED.equals((Object)scaStatus)) {
                logger.info("SCA status` is {}", (Object)scaStatusName);
                logger.info("Payment scheduled for execution. Transaction status is {}. Als see sca status", (Object)response.getTransactionStatus());
                return SpiResponse.builder().payload((Object)this.spiPaymentExecutionResponse(response.getTransactionStatus())).build();
            }
            String message = String.format("Payment not executed. Transaction status is %s. Als see sca status %s.", response.getTransactionStatus(), scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response));
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, message, new Object[0])).build();
        }
        catch (FeignException e) {
            return SpiResponse.builder().error(this.getFailureMessageFromFeignException(e)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Object> getPaymentById(String paymentId, String toString, byte[] aspspConsentData) {
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Get payment by id with type={}, and id={}", (Object)PaymentTypeTO.SINGLE, (Object)paymentId);
            logger.debug("Single payment body={}", (Object)toString);
            Optional<Object> optional = Optional.ofNullable(this.paymentRestClient.getPaymentById(sca.getPaymentId()).getBody());
            return optional;
        }
        catch (FeignException e) {
            logger.error(e.getMessage());
            Optional<Object> optional = Optional.empty();
            return optional;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private SpiPaymentExecutionResponse spiPaymentExecutionResponse(TransactionStatusTO transactionStatus) {
        return new SpiPaymentExecutionResponse(TransactionStatus.valueOf((String)transactionStatus.name()));
    }

    private TppMessage getFailureMessageFromFeignException(FeignException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return e.status() == 500 ? new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, "Request was failed", new Object[0]) : new TppMessage(MessageErrorCode.FORMAT_ERROR, "Couldn't execute payment", new Object[0]);
    }
}

