/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.SinglePaymentSpiImpl;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import feign.FeignException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationSpiImpl
implements FundsConfirmationSpi {
    private static final Logger logger = LoggerFactory.getLogger(SinglePaymentSpiImpl.class);
    private final AccountRestClient restClient;
    private final LedgersSpiAccountMapper accountMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService tokenService;

    public FundsConfirmationSpiImpl(AccountRestClient restClient, LedgersSpiAccountMapper accountMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService tokenService) {
        this.restClient = restClient;
        this.accountMapper = accountMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.tokenService = tokenService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiFundsConfirmationResponse> performFundsSufficientCheck(@NotNull SpiContextData contextData, @Nullable PiisConsent piisConsent, @NotNull SpiFundsConfirmationRequest spiFundsConfirmationRequest, @Nullable SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] aspspConsentData = piisConsent == null || aspspConsentDataProvider == null ? null : aspspConsentDataProvider.loadAspspConsentData();
        try {
            SCAResponseTO response = this.tokenService.response(aspspConsentData);
            this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
            logger.info("Funds confirmation request e={}", (Object)spiFundsConfirmationRequest);
            FundsConfirmationRequestTO request = this.accountMapper.toFundsConfirmationTO(contextData.getPsuData(), spiFundsConfirmationRequest);
            Boolean fundsAvailable = (Boolean)this.restClient.fundsConfirmation(request).getBody();
            logger.info("And got the response ={}", (Object)fundsAvailable);
            SpiFundsConfirmationResponse spiFundsConfirmationResponse = new SpiFundsConfirmationResponse();
            spiFundsConfirmationResponse.setFundsAvailable(Optional.ofNullable(fundsAvailable).orElse(false).booleanValue());
            if (aspspConsentDataProvider != null) {
                aspspConsentDataProvider.updateAspspConsentData(this.tokenService.store(response));
            }
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)spiFundsConfirmationResponse).build();
            return spiResponse;
        }
        catch (FeignException e) {
            SpiResponse spiResponse = SpiResponse.builder().error(this.getFailureMessageFromFeignException(e)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private TppMessage getFailureMessageFromFeignException(FeignException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return e.status() == 500 ? new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, "Request was failed", new Object[0]) : new TppMessage(MessageErrorCode.PAYMENT_FAILED, "The funds confirmation request failed.", new Object[0]);
    }
}

