/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.GeneralPaymentService;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import feign.Request;
import feign.Response;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BulkPaymentSpiImpl
implements BulkPaymentSpi {
    private static final Logger logger = LoggerFactory.getLogger(BulkPaymentSpiImpl.class);
    private final PaymentRestClient ledgersRestClient;
    private final LedgersSpiPaymentMapper paymentMapper;
    private final GeneralPaymentService paymentService;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final ObjectMapper objectMapper;

    public BulkPaymentSpiImpl(PaymentRestClient ledgersRestClient, LedgersSpiPaymentMapper paymentMapper, GeneralPaymentService paymentService, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, ObjectMapper objectMapper) {
        this.ledgersRestClient = ledgersRestClient;
        this.paymentMapper = paymentMapper;
        this.paymentService = paymentService;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.objectMapper = objectMapper;
    }

    @NotNull
    public SpiResponse<SpiBulkPaymentInitiationResponse> initiatePayment(@NotNull SpiContextData contextData, @NotNull SpiBulkPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        byte[] initialAspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        if (ArrayUtils.isEmpty((byte[])initialAspspConsentData)) {
            return this.paymentService.firstCallInstantiatingPayment(PaymentTypeTO.BULK, (SpiPayment)payment, aspspConsentDataProvider, new SpiBulkPaymentInitiationResponse());
        }
        try {
            SCAPaymentResponseTO response = this.initiatePaymentInternal(payment, initialAspspConsentData);
            SpiBulkPaymentInitiationResponse spiInitiationResponse = Optional.ofNullable(response).map(this.paymentMapper::toSpiBulkResponse).orElseThrow(() -> FeignException.errorStatus((String)"Request failed, Response was 201, but body was empty!", (Response)this.error(400)));
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response));
            String scaStatusName = response.getScaStatus().name();
            logger.info("SCA status` is {}", (Object)scaStatusName);
            return SpiResponse.builder().payload((Object)spiInitiationResponse).build();
        }
        catch (FeignException e) {
            return SpiResponse.builder().error(this.getFailureMessageFromFeignException(e)).build();
        }
        catch (IllegalStateException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PAYMENT_FAILED, "The payment initiation request failed during the initial process.", new Object[0])).build();
        }
    }

    @NotNull
    public SpiResponse<SpiBulkPayment> getPaymentById(@NotNull SpiContextData contextData, @NotNull SpiBulkPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (!TransactionStatus.ACSP.equals((Object)payment.getPaymentStatus())) {
            return SpiResponse.builder().payload((Object)payment).build();
        }
        return this.paymentService.getPaymentById(payment.getPaymentId(), payment.toString(), aspspConsentDataProvider.loadAspspConsentData()).map(p -> (BulkPaymentTO)this.objectMapper.convertValue(p, BulkPaymentTO.class)).map(this.paymentMapper::mapToSpiBulkPayment).map(p -> SpiResponse.builder().payload(p).build()).orElseGet(() -> SpiResponse.builder().error(new TppMessage(MessageErrorCode.PAYMENT_FAILED, "Couldn't get payment by ID", new Object[0])).build());
    }

    @NotNull
    public SpiResponse<TransactionStatus> getPaymentStatusById(@NotNull SpiContextData contextData, @NotNull SpiBulkPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.paymentService.getPaymentStatusById(PaymentTypeTO.valueOf((String)payment.getPaymentType().name()), payment.getPaymentId(), payment.getPaymentStatus(), aspspConsentDataProvider.loadAspspConsentData());
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> executePaymentWithoutSca(@NotNull SpiContextData contextData, @NotNull SpiBulkPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.paymentService.executePaymentWithoutSca(aspspConsentDataProvider);
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndExecutePayment(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiBulkPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.paymentService.verifyScaAuthorisationAndExecutePayment(spiScaConfirmation, aspspConsentDataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCAPaymentResponseTO initiatePaymentInternal(SpiBulkPayment payment, byte[] initialAspspConsentData) {
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(initialAspspConsentData, SCAPaymentResponseTO.class, true);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Initiate bulk payment with type={}", (Object)PaymentTypeTO.BULK);
            logger.debug("Bulk payment body={}", (Object)payment);
            BulkPaymentTO request = this.paymentMapper.toBulkPaymentTO(payment);
            if (request.getPaymentProduct() == null) {
                request.setPaymentProduct(sca.getPaymentProduct());
            }
            SCAPaymentResponseTO sCAPaymentResponseTO = (SCAPaymentResponseTO)this.ledgersRestClient.initiatePayment(PaymentTypeTO.BULK, (Object)request).getBody();
            return sCAPaymentResponseTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private TppMessage getFailureMessageFromFeignException(FeignException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return e.status() == 500 ? new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, "Request was failed", new Object[0]) : new TppMessage(MessageErrorCode.PAYMENT_FAILED, "The payment initiation request failed during the initial process.", new Object[0]);
    }

    private Response error(int code) {
        return Response.builder().status(code).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"", Collections.emptyMap(), null)).headers(Collections.emptyMap()).build();
    }
}

