/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import feign.FeignException;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AspspConsentDataService {
    @Autowired
    private TokenStorageService tokenStorageService;

    public byte[] store(SCAResponseTO response) {
        return this.store(response, true);
    }

    public byte[] store(SCAResponseTO response, boolean checkCredentials) {
        if (checkCredentials && response.getBearerToken() == null) {
            throw new IllegalStateException("Missing credentials. response must contain a bearer token by default.");
        }
        try {
            return this.tokenStorageService.toBytes(response);
        }
        catch (IOException e) {
            throw FeignException.errorStatus((String)e.getMessage(), (Response)this.error(500));
        }
    }

    public <T extends SCAResponseTO> T response(byte[] aspspConsentData, Class<T> klass) {
        return this.response(aspspConsentData, klass, true);
    }

    public SCAResponseTO response(byte[] aspspConsentData) {
        return this.response(aspspConsentData, true);
    }

    public SCAResponseTO response(byte[] aspspConsentData, boolean checkCredentials) {
        try {
            SCAResponseTO sca = this.tokenStorageService.fromBytes(aspspConsentData);
            this.checkScaPresent(sca);
            this.checkBearerTokenPresent(checkCredentials, sca);
            return sca;
        }
        catch (IOException e) {
            throw FeignException.errorStatus((String)e.getMessage(), (Response)this.error(500));
        }
    }

    public <T extends SCAResponseTO> T response(byte[] aspspConsentData, Class<T> klass, boolean checkCredentials) {
        try {
            SCAResponseTO sca = this.tokenStorageService.fromBytes(aspspConsentData, klass);
            this.checkScaPresent(sca);
            this.checkBearerTokenPresent(checkCredentials, sca);
            return (T)sca;
        }
        catch (IOException e) {
            throw FeignException.errorStatus((String)e.getMessage(), (Response)this.error(500));
        }
    }

    private <T extends SCAResponseTO> void checkBearerTokenPresent(boolean checkCredentials, T sca) {
        if (checkCredentials && sca.getBearerToken() == null) {
            throw FeignException.errorStatus((String)"Missing credentials. Expecting a bearer token in the consent data object.", (Response)this.error(401));
        }
    }

    private <T extends SCAResponseTO> void checkScaPresent(T sca) {
        if (sca == null) {
            throw FeignException.errorStatus((String)"Missing consent data", (Response)this.error(401));
        }
    }

    private Response error(int code) {
        return Response.builder().status(code).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"", Collections.emptyMap(), null)).headers(Collections.emptyMap()).build();
    }
}

